
// Implementation of the CalAlarmReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
CalAlarmReader::CalAlarmReader(void): 
  TechmodelAlgorithm(PacketType::CalAlarm, "TechmodelCalAlarmReader") { 
  calAlarm = new CalAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalAlarmReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calAlarm, calAlarm->Class());
}

/**
 * Unpack the CalAlarm event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalAlarmReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
    calAlarm->calAlarmData        = new TArrayC(dataLength, subData);
}
