// Implementation of the CalibCalReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */

CalibCalReader::CalibCalReader(void): 
  TechmodelAlgorithm(PacketType::CalibCal, "TechmodelCalibCalReader") { 
  calibCal = new CalibCalEvent();  
}


/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibCalReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibCalReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibCalReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calibCal, calibCal->Class());
	//PamOffLineSW::mainLogUtil->logAll("Init CalibCal Done");			   	

}

/**
 * Unpack the calibCal event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */

void CalibCalReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){ 
  
  if ( dataLength == 6 ){
    calibCal->CAL_RESET = (((UINT16)(subData[0]<<8))&0xFF00) + (((UINT16)(subData[1]))&0x00FF);
    calibCal->WRITE_DSP_MEM = (((UINT16)(subData[2]<<8))&0xFF00) + (((UINT16)(subData[3]))&0x00FF);
    calibCal->WRITE_FPGA_REG = (((UINT16)(subData[4]<<8))&0xFF00) + (((UINT16)(subData[5]))&0x00FF);
    //    calibCal->calibCalData        = new TArrayC(dataLength, subData);
  } else {
    calibCal->CAL_RESET = 0;
    calibCal->WRITE_DSP_MEM = 0;
    calibCal->WRITE_FPGA_REG = 0;
    string msg;    
    std::stringstream oss;
    oss << "CalibCal: wrong pkt length";
    msg=oss.str();
    PamOffLineSW::mainLogUtil->logWarning(msg);	
    //    PamOffLineSW::mainLogUtil->logAll("PKT_RunEvent: Used CalibCal packet.");			   	
  };
}
