/** @file
 * $Source: /repository/PamOffLineSW/techmodel/ArrDumpReader.cpp,v $
 * $Id: ArrDumpReader.cpp,v 1.4 2008-03-04 18:09:30 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the ArrDumpReader class.
 */

extern "C" {
    #include "CRC.h"
}

#include "ReaderAlgorithms.h"
using namespace pamela::techmodel;

/**
 * Constructor. 
 */
ArrDumpReader::ArrDumpReader(void): 
  TechmodelAlgorithm(PacketType::ArrDump, "TechmodelArrDump") { 
  ArrDump = new ArrDumpEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ArrDumpReader::GetVersionInfo(void) const {
  return "$Header: /repository/PamOffLineSW/techmodel/ArrDumpReader.cpp,v 1.4 2008-03-04 18:09:30 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ArrDumpReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &ArrDump, ArrDump->Class());
}

/**
 * Unpack the ArrDump event
 */
void ArrDumpReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException){
	std::stringstream oss; 
	string msg;	
		
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;      //CRC read from the end of the subpacket
    long int  dataLength = length - 2;  //the block of data
  
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
   // if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for ArrDump Packet "); 
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for ArrDump Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for ArrDump Packet. THE PACKET IS DISCARDED ");
    }
    
    ArrDumpRecord* rec;
    ArrDump->PARAMETER_STAMP = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);
    long int offset = 4;
    int i = 0;
    ArrDump->Records->Clear();
    TClonesArray &recs = *(ArrDump->Records);
    while (offset < dataLength){
        rec = new(recs[i++]) ArrDumpRecord(); //add a new TmtcRecord
        rec->Arr_ID  = ((UINT8)subData[offset])&0xFF;
        rec->Arr_len = (((UINT16)subData[offset+1]<<8)&0xFF00) + ((UINT16)subData[offset+2])&0x00FF;
        rec->Data  = new TArrayI((int)rec->Arr_len, (int*)(subData+offset+3));
        offset = offset + sizeof(UINT32)*(rec->Arr_len) + 3;
    }
   
    /*
           if (subCRC != readCRC)
           {
           	oss.str("");
           	oss<<"Wrong CRC for ArrDump Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
           	msg=oss.str();
           	PamOffLineSW::mainLogUtil->logWarning(msg);	
           	throw WrongCRCException_PKTUsed(" Wrong CRC for ArrDump Packet. ");
           }
        */ 	
    
    
}
