/** @file
 * $Author: mocchiut $
 * $Date: 2008/09/23 07:20:23 $
 * $Revision: 1.1.1.1 $
 * 
 * Implementation of the InitTrailerReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
InitTrailerReader::InitTrailerReader(void): 
  TechmodelAlgorithm(PacketType::InitTrailer, "TechmodelInitTrailerReader") { 
  initTrailer = new InitTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string InitTrailerReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/InitTrailerReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void InitTrailerReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &initTrailer, initTrailer->Class());
}

/**
 * Unpack the InitTrailer event
 */
void InitTrailerReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
	std::stringstream oss; 
	string msg;	
	
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  length = dataLength - 2; //the block of data
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, length);
    readCRC = (((UINT16)(subData[dataLength - 2]<<8))&0xFF00) + (((UINT16)subData[dataLength - 1])&0x00FF);

    //if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for InitTrailer Packet ");
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for InitTrailer Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for InitTrailer Packet. THE PACKET IS DISCARDED ");
    }
    
    initTrailer->initTrailerData        = new TArrayC(length, subData);
    
    /*
        if (subCRC != readCRC)
        {
        	oss.str("");
        	oss<<"Wrong CRC for InitHeader Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
        	msg=oss.str();
        	PamOffLineSW::mainLogUtil->logWarning(msg);	
        	throw WrongCRCException_PKTUsed(" Wrong CRC for InitHeader Packet. ");
        }
     */ 
    
}
