/** @file
 * $Author: mocchiut $
 * $Date: 2008/09/23 07:20:24 $
 * $Revision: 1.1.1.1 $
 * 
 * Implementation of the S4AlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
S4AlarmReader::S4AlarmReader(void): 
  TechmodelAlgorithm(PacketType::S4Alarm, "S4AlarmReader") { 
  s4Alarm = new S4AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string S4AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/s4AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void S4AlarmReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &s4Alarm, s4Alarm->Class());
}

/**
 * Unpack the S4Alarm event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void S4AlarmReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){ 	  
    s4Alarm->s4AlarmData        = new TArrayC(dataLength, subData);
}
