/** @file
 * $Source: /repository/PamOffLineSW/techmodel/RunTrailerReader.cpp,v $
 * $Id: RunTrailerReader.cpp,v 1.6 2008-03-04 18:09:29 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the RunHeader class.
*/


extern "C" {
	#include "CRC.h"
}
#include "ReaderAlgorithms.h"
using namespace pamela::techmodel;

/**
 * Constructor. 
 */
RunTrailerReader::RunTrailerReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelRunTrailerReader") { 
  RunTrailer = new RunTrailerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string RunTrailerReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/RunTrailerReader.cpp,v 1.6 2008-03-04 18:09:29 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void RunTrailerReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &RunTrailer, RunTrailer->Class());
}


/**
 * Unpack the RunTrailer event 
 */
void RunTrailerReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException){
	std::stringstream oss; 
	string msg;	
	
    UINT16    subCRC;      //CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength;
 
    //the 2 bytes subtracted belong to the final event CRC bytes
    dataLength = length - (long int)2;
    subCRC = CM_Compute_CRC16(0, (BYTE*)subData, dataLength);
    //took the final CRC to compare it with the previous calculated CRC of the data
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);  

    //ORIG: if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for RunTrailer Packet ");
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for RunTrailer Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for RunTrailer Packet. THE PACKET IS DISCARDED ");
    }	
  
    RunTrailer->PKT_COUNTER         = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00) + (((UINT32)subData[3])&0x000000FF);
    RunTrailer->PKT_ReadyCounter    = (((UINT32)subData[4]<<24)&0xFF000000) + (((UINT32)subData[5]<<16)&0x00FF0000) +  (((UINT32)subData[6]<<8)&0x0000FF00) + (((UINT32)subData[7])&0x000000FF);
    RunTrailer->OBT_TYME_SYNC       = (((UINT32)subData[8]<<24)&0xFF000000) + (((UINT32)subData[9]<<16)&0x00FF0000) +  (((UINT32)subData[10]<<8)&0x0000FF00) + (((UINT32)subData[11])&0x000000FF);
    RunTrailer->LAST_TYME_SYNC_INFO = (((UINT32)subData[12]<<24)&0xFF000000) + (((UINT32)subData[13]<<16)&0x00FF0000) +  (((UINT32)subData[14]<<8)&0x0000FF00) + (((UINT32)subData[15])&0x000000FF);
/*    
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for RunTrailer Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logWarning(msg);	
    	throw WrongCRCException_PKTUsed(" Wrong CRC for RunTrailer Packet. ");
    }
*/    	
}

