/** @file
 * $Source: /repository/PamOffLineSW/physics/TriggerReader.cpp,v $
 * $Id: TriggerReader.cpp,v 1.4 2008-03-05 11:37:37 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the CalorimeterReader class.
 */

#include <iostream>
#include <string>
#include "TriggerReader.h"

extern "C" {
  

  extern struct {
    int         evcount;
    int         pmtpl[3];
    int         trigrate[6];
    int         dltime[2];
    int         s4calcount[2]; 
    int         pmtcount1[24];
    int         pmtcount2[24];
    int         patternbusy[3];
    int         patterntrig[6];
    int         trigconf;
  } trig_; 

  void triggerunpack_(unsigned char[], long int*, int*);

    //Struct per il passaggio di dati da e verso la chiamata fortran
}

using namespace pamela;
using namespace pamela::trigger;

 
/**
 * Constructor.     
 */
TriggerReader::TriggerReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelTriggerReader") { 
  trigger = new TriggerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TriggerReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/physics/TriggerReader.cpp,v 1.4 2008-03-05 11:37:37 messineo Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TriggerReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &trigger, trigger->Class());
}

/**
 * Unpack the trigger event from an input file.
 */
void TriggerReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the Trigger data event from the physical packet.
 */
void TriggerReader::RunEvent(int EventNumber, const char subData[], long int length) {
	std::stringstream oss; 
    string msg;

    char *data = new char[length];
    memcpy(data, subData, length);
    int  ERROR = 0;
    
    /*unsigned short convdata[length];
    for (int i = 0; i<length; i++){
        convdata[i] = (unsigned short)((unsigned char)subData[i]&0xFF);
    }*/

    
    //Call to the routine that unpack trigger events
    if ( length < 500000 && length >= 0 ){
      triggerunpack_((unsigned char*)data, &length, &ERROR);
    } else {
      ERROR = 1;
    };
    

    if (ERROR != 0) {
        char *errmsg;
        switch (ERROR){
            case 1: errmsg = "GENERIC TRIGGER ERROR";
            break;
            default: errmsg = "TRIGGER ERRROR CODE UNIDENTIFIED";
        }
        oss.str("");
        oss << "Trigger: Fortran77 function triggerunpack: " <<  errmsg;
        msg=oss.str();
        PamOffLineSW::mainLogUtil->logWarning(msg);	  
        
    }
    //  In case of "ERROR != 0" the calunpack will take care to set all 
    //  parameters to zero
    //} else {
    trigger->unpackError = (unsigned short)ERROR;
    trigger->evcount   = trig_.evcount;
    memcpy(trigger->pmtpl, trig_.pmtpl, sizeof(trigger->pmtpl));
    memcpy(trigger->trigrate, trig_.trigrate, sizeof(trigger->trigrate));
    memcpy(trigger->dltime, trig_.dltime, sizeof(trigger->dltime));
    memcpy(trigger->s4calcount, trig_.s4calcount, sizeof(trigger->s4calcount));
    memcpy(trigger->pmtcount1, trig_.pmtcount1, sizeof(trigger->pmtcount1));
    memcpy(trigger->pmtcount2, trig_.pmtcount2, sizeof(trigger->pmtcount2));
    memcpy(trigger->patternbusy, trig_.patternbusy, sizeof(trigger->patternbusy));
    memcpy(trigger->patterntrig, trig_.patterntrig, sizeof(trigger->patterntrig));
    trigger->trigconf = trig_.trigconf;
    delete [] data;

}
