/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/physics/TofReader.cpp,v $
 * $Id: TofReader.cpp,v 1.1.1.1 2008/09/23 07:20:22 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Implementation of the CalorimeterReader class.
 */


#include <iostream>
#include <string>
#include "TofReader.h"

extern "C" {
  

 extern struct {
        int         tdcid[12];
        int         evcount[12];
        int         tdcmask[12];
        int         adc[4][12];
        int         tdc[4][12];
        int         temp1[12];
        int         temp2[12];

    } tofvar_; 

  void tofunpack_(unsigned char[], long int*, int*);

    //Struct per il passaggio di dati da e verso la chiamata fortran
}

using namespace pamela;
using namespace pamela::tof;

 
/**
 * Constructor.     
 */
TofReader::TofReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelTofReader") { 
  tof = new TofEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/physics/TofReader.cpp,v 1.1.1.1 2008/09/23 07:20:22 mocchiut Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &tof, tof->Class());
}

/**
 * Unpack the tof event from an input file.
 */
void TofReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the Tof data event from the physical packet.
 */
void TofReader::RunEvent(int EventNumber, const char subData[], long int length) {
	std::stringstream oss;
    string msg;

    char *data = new char[length];
    memcpy(data, subData, length);
    int  ERROR = 0;
    
    /*unsigned short convdata[length];
    for (int i = 0; i<length; i++){
        convdata[i] = (unsigned short)((unsigned char)subData[i]&0xFF);
    }*/

    
    //Call to the routine that unpack tof events
    if ( length < 500000 && length >= 0 ){
      tofunpack_((unsigned char*)data, &length, &ERROR);
    } else {
      ERROR = 1;
    };

    if (ERROR != 0) {
        char *errmsg;
        switch (ERROR){
            case 1: errmsg = "CRC TOF ERROR";
            break;
            default: errmsg = "TOF ERROR CODE UNIDENTIFIED";
        }
        oss.str("");
        oss << "Tof: Fortran77 function tofunpack: " <<  errmsg;
        msg=oss.str();
        PamOffLineSW::mainLogUtil->logAll(msg);	      
        //ORIGINAL: logger->debug(oss.str().c_str());
        //marco: better switch to level warning?
        //    PamOffLineSW::mainLogUtil->logWarning(msg);	      
    }
    //  In case of "ERROR != 0" the calunpack will take care to set all 
    //  parameters to zero
    //} else {
    // only for a variable    tof->tof1int   = evento_.IEV2;
    //        memcpy(tof->tof1int, tofvar_.tof1int, sizeof(tofvar_.tof1int));
    //  printf("tof->tof1int[1] %i \n",tof->tof1int[0]);
    tof->unpackError = (unsigned short)ERROR;

    // for (int i = 0; i < 6; i++){
    //  tof->tof1int[i] = tofvar_.tof1int[i];
    //};
    //      printf("tof->tof1int[2] %i \n",tof->tof1int[1]);

        memcpy(tof->tdcid,   tofvar_.tdcid,   sizeof(tof->tdcid));
        memcpy(tof->evcount, tofvar_.evcount, sizeof(tof->evcount));
        memcpy(tof->tdcmask, tofvar_.tdcmask, sizeof(tof->tdcmask));
        memcpy(tof->temp1,   tofvar_.temp1,   sizeof(tof->temp1));
        memcpy(tof->temp2,   tofvar_.temp2,   sizeof(tof->temp2));


    //--------have to invert array because of FORTRAN <-> C different management of the indexes

	//        int temptofmat[6][12];
       
	//        memcpy(temptofmat,         toftest_.tofmat,        sizeof(temptofmat));
     
	//        for (int i = 0; i < 6; i++){
	//            for (int j = 0; j < 12; j++){
	//                tof->tofmat[j][i] = temptofmat[i][j];
		//            }
	//        }

        int        tmpadc[12][4];
        int        tmptdc[12][4];
       
        memcpy(tmpadc,         tofvar_.adc,        sizeof(tmpadc));
        memcpy(tmptdc,         tofvar_.tdc,        sizeof(tmptdc));
          
        for (int i = 0; i < 12; i++){
            for (int j = 0; j < 4; j++){
                tof->adc[j][i] = tmpadc[i][j];
                tof->tdc[j][i] = tmptdc[i][j];
            }
        }
 
    delete [] data;
}
