*************************************************************************
*     
*     functions.f
*     
*     - !???
*     
*     needs:
*     - !???
*     
*     output variables:
*     - !???
*     
*     to be called inside !???
*     
*************************************************************************


      function pitch(view)      !da' il pitch delle strip di una vista

      real pitch
      integer view

      include './commontracker.f'

      if(mod(view,2).eq.0) then !X
         pitch=pitchX
      else                      !Y
         pitch=pitchY
      endif

      end



c------------------------------------------------------------------------



      function npl(view)        !da' il numero del piano a partire dalla vista!???

      integer npl,view

      npl=INT((view-1)/2)+1

      end



c------------------------------------------------------------------------



      function nld(istrip,view) 
c     da' il numero del ladder a partire dalla 
C     strip del piano

c     chiamo ladder 1 quello dove si trova la prima strip 
c     letta X
c     quindi la prima strip letta Y si trova sul ladder 3

      integer istrip,view,nld

      include './commontracker.f'

      nld=INT((istrip-1)/nstrips_ladder)+1

c$$$      if(mod(view,2).eq.1) then !Y 
c$$$         nld=4-nld
c$$$      endif

      end



c------------------------------------------------------------------------




      function nvk(istrip)      !da' il numero del va1 a partire dalla strip del piano!???

      integer istrip,nvk

      include './commontracker.f'

      nvk=INT((istrip-1)/nstrips_va1)+1

      end



c------------------------------------------------------------------------



      function nst(istrip)      !da' la strip del va1 a partire dalla strip del piano!???

      integer istrip,nst

      include './commontracker.f'

      nst=INT(mod((istrip-1),nstrips_va1))+1

      end



c------------------------------------------------------------------------



c$$$  function coordpl(iev,ic,istrip,view,ladder,sen) !reads strip number of the planes 
c$$$  ! and gives strip coordinate in micrometers, taking into 
c$$$  ! account plane geometry.
c$$$  ! the origin of the coordinate is on the first 
c$$$  ! strip of the plane
c$$$  integer is,istrip,view,ladder
c$$$  integer sensor,sen        !for test2002: tells if the cluster belongs to the 
c$$$  ! Si sensor next to the hybrid or to the far one!???
c$$$  real coordpl
c$$$  
c$$$  
c$$$  include './commontracker.f'
c$$$  
c$$$  c     NB mettere il 1024 nel commontracker...!???
c$$$  
c$$$  
c$$$  is=istrip                 !per evitare che cambi il valore di istrip...!???
c$$$  
c$$$  coordpl=0.
c$$$  
c$$$  if(mod(view,2).eq.0) then !X view
c$$$  
c$$$  if((is.le.3)           !X has 1018 strips...
c$$$  $        .or.(is.ge.1022.and.is.le.1027)
c$$$  $        .or.(is.ge.2046.and.is.le.2051)
c$$$  $        .or.(is.ge.3070)) then
c$$$  print*,'functions: WARNING: false X strip: strip ',is !servirebbe
c$$$  $           ,' view ',view,' ladder ',ladder ! errflag per poter
c$$$  $           ,' iev ',iev,' ic ',ic ! errflag per poter
c$$$  endif                  ! segnalare anche l'evento dal main program...!???
c$$$  
c$$$  if(ladder.eq.1) then
c$$$  is=is-3             !4 =< istrip =< 1021
c$$$  coordpl=(is-1)*pitch(view)
c$$$  elseif(ladder.eq.2) then
c$$$  is=is-1024-3        !1028 =< istrip =< 2045
c$$$  coordpl=(1018-1)*pitch(view)+731.5+610.+731.5
c$$$  $           +(is-1)*pitch(view) !takes into account space between ladders (C
c$$$  ! fiber rails + dead Si)
c$$$  elseif(ladder.eq.3) then
c$$$  is=is-2048-3        !2052 =< istrip =< 3069
c$$$  coordpl=(1018-1)*pitch(view)+731.5+610.
c$$$  $           +731.5+(1018-1)*pitch(view)+731.5+610.
c$$$  $           +731.5+(is-1)*pitch(view)
c$$$  endif
c$$$  
c$$$  elseif(mod(view,2).eq.1) then !Y view
c$$$  
c$$$  is=mod(is-1,1024)+1
c$$$  
c$$$  c     questo non funziona sempre perche' il fascio puo' entrare su uno e uscire da un altro:/ !???
c$$$  c     questo non funziona sempre :/ !???
c$$$  c     questo non funziona sempre :/ !???
c$$$  c     questo non funziona sempre :/ !???
c$$$  c     questo non funziona sempre :/ !???
c$$$  
c$$$  c     if(view.ne.11) then    !in 2002 beam test 11th view was flipped...!???
c$$$  sensor=sen
c$$$  c     else
c$$$  c     if(sen.eq.0) sensor=1
c$$$  c     if(sen.eq.1) sensor=0
c$$$  c     endif                  !ZZZZZZZZZZZZZZz
c$$$  
c$$$  
c$$$  if(sensor.eq.0) then   !sensor=0 --> Si sensor next to hybrid!???
c$$$  coordpl=(is-1)*pitch(view)
c$$$  elseif(sensor.eq.1) then !sensor=1 --> Si sensor far from hybrid!???
c$$$  coordpl=(1024-1)*pitch(view)+985.0+30.
c$$$  $           +985.5+(is-1)*pitch(view)
c$$$  endif
c$$$  
c$$$  if(view.eq.11) then    !in 2002 beam test 11th view was flipped...!???
c$$$  coordpl=(is-1)*pitch(view)
c$$$  c            coordpl=142400.-coordpl!???
c$$$  coordpl=0. !???
c$$$  c$$$            if(sensor.eq.0) then !sensor=0 --> Si sensor next to hybrid!???
c$$$  c$$$               coordpl=(is-1)*pitch(view)
c$$$  c$$$            elseif(sensor.eq.1) then !sensor=1 --> Si sensor far from hybrid!???
c$$$  c$$$               coordpl=(1024-1)*pitch(view)+985.0+30.
c$$$  c$$$     $              +985.5+(is-1)*pitch(view)
c$$$  c$$$            endif
c$$$  endif
c$$$  
c$$$  endif
c$$$  
c$$$  end
c$$$  
c$$$  
c$$$  
c$$$  
c$$$  c------------------------------------------------------------------------
c$$$  
c$$$  
c$$$  
c$$$  
c$$$  function coord(coordpl,view) !reads strip coordinate in micrometers respect 
c$$$  ! to the first strip of the plane and gives it 
c$$$  ! in PAMELA reference frame (the origin is in the
c$$$  ! centre of the magnet)
c$$$  integer view
c$$$  
c$$$  real coord,coordpl
c$$$  
c$$$  
c$$$  coord=0.
c$$$  
c$$$  
c$$$  if(mod(view,2).eq.0) then !X view
c$$$  
c$$$  traslX=(1018-1)*51. + 731.5 + 610. + (53330./2)
c$$$  coord=coordpl-traslX
c$$$  
c$$$  elseif(mod(view,2).eq.1) then !Y view
c$$$  
c$$$  traslY=(1024-1)*66.5 + 985. + 15. + 
c$$$  $        ((288000./2) - 
c$$$  $        (15000. + 1470. + 55000. + 30. + 70000. + 15.))
c$$$  
c$$$  c         traslY=0.!???
c$$$  
c$$$  c         if(view.ne.11) then    !in 2002 beam test 11th view was flipped...!???
c$$$  coord=coordpl-traslY
c$$$  c         else
c$$$  c            coord=traslY-coordpl
c$$$  c         endif!ZZZZZZZZZZZZZz
c$$$  
c$$$  endif
c$$$  
c$$$  end
c$$$  
c$$$  
c$$$  
c$$$  c------------------------------------------------------------------------




      function coordsi(istrip,view) 
c     reads strip number and gives                                
c     strip coordinate in micrometers.                                
c     the origin of the coordinate is on the centre                                
c     of the sensor
      integer is,istrip,view

      real coordsi


      include './commontracker.f'

c     NB mettere il 1024 nel commontracker...!???


      is=istrip                 !per evitare che cambi il valore di istrip...!???

      is=mod(is-1,1024)+1

      coordsi=0.
      
      if(mod(view,2).eq.0) then !X view

         if((is.le.3).or.(is.ge.1022)) then !X has 1018 strips...
            print*,'functions: WARNING: false X strip: strip ',is !servirebbe
c     $           ,' view ',view ! errflag per poter
         endif                  ! segnalare anche l'evento dal main program...!???

         is=is-3                !4 =< is =< 1021

         edge=edgeX
         dim=SiDimX

      elseif(mod(view,2).eq.1) then !Y view

         edge=edgeY
         dim=SiDimY

         if(view.eq.11) then !INVERSIONE!???
            is=1025-is
         endif

      endif

      p=pitch(view)

      coord1=(is-1)*p           !rispetto alla prima strip del sensore
      coord1=coord1+edge        !rispetto al bordo del sensore
      
      coordsi=coord1-dim/2      !rispetto al centro del sensore
      
      

      end



c------------------------------------------------------------------------




      function coord(coordsi,view,ladder,sen) 
c     reads strip coordinate in 
c     micrometers respect to center of the 
c     sensor and gives it in PAMELA reference frame
c     (the origin is in the centre of the magnet)

      include './commontracker.f'
      include './runinfo.f'

      integer view,ladder,sen
      integer sx,sy,sz

      real coord,coordsi,trasl

      parameter (offset=4365.)  !???  ! um
c      parameter (offset=0.)!???


      coord=0.
      
      sx=ladder
      sy=sen
      sz=npl(view)

      call mech_sensor


      if(mod(view,2).eq.0) then !X view

         trasl=x_mech_sensor(sz,sx,sy) !in millimetri

      elseif(mod(view,2).eq.1) then !Y view
         
         trasl=y_mech_sensor(sz,sx,sy) !in millimetri

         if(view.eq.11) then    !INVERSIONE!???
            coordsi=coordsi+offset
         endif

      endif


      coord=coordsi+trasl*1000


      end



c------------------------------------------------------------------------



      subroutine mech_sensor

      include './commontracker.f'
      
      open(20,FILE='../common/mechanical_positions.dat')
      do ip=1,6
         do j=1,3
            read(20,*)(x_mech_sensor(ip,j,k),k=1,2)
            read(20,*)(y_mech_sensor(ip,j,k),k=1,2)
            read(20,*)(z_mech_sensor(ip,j,k),k=1,2)
         enddo
      enddo
      close(20)
      

      return
      end
