//============================================================================
// $Id: Logger.cpp,v 1.1.1.1 2008-09-23 07:20:10 mocchiut Exp $ 
// Description : 
//============================================================================
#include "Logger.h"
#include <iostream>

namespace PamOffLineSW{

LogUtil::LogUtil(std::string& filename){
	mtempstring="";
	mFilename=filename;
	mLevel=LogUtil::LOGERROR;
	mOutStream.open(mFilename.c_str(), std::ios::binary);
}
LogUtil::LogUtil(const char* filename){
	mtempstring="";
	mFilename=std::string(filename); 
	mLevel=LogUtil::LOGERROR;
	mOutStream.open(mFilename.c_str(), std::ios::binary);
}
LogUtil::LogUtil(std::string& filename, logLevel level){
	mtempstring="";
	mFilename=filename;
	mLevel=level;
	mOutStream.open(mFilename.c_str(), std::ios::binary);
}
LogUtil::LogUtil(const char* filename, logLevel level){
	mtempstring="";
	mFilename=std::string(filename);
	mLevel=level;
	mOutStream.open(mFilename.c_str(), std::ios::binary);
}
std::string& LogUtil::getLogFileName(){
	return mFilename;
}
void LogUtil::setLoglevel(logLevel level){
	mLevel=level;
}
void LogUtil::logError(std::string& msg){
	if(!mOutStream.fail()){
		mOutStream << "[Error] " << msg << std::endl;
	}else{
		std::cout << "[Error] " << msg << std::endl;
	}
}
void LogUtil::logWarning(std::string& msg){
	if(mLevel >= LogUtil::LOGWARN){
		if(!mOutStream.fail()){
			mOutStream << "[Warning] " << msg << std::endl;
		}else{
			std::cout << "[Warning] " << msg << std::endl; 
		}
	}
}

void LogUtil::logInfo(std::string& msg){
	if(mLevel >= LogUtil::LOGINFO){
		if(!mOutStream.fail()){
			mOutStream << "[Info] " << msg << std::endl;
		}else{
			std::cout << "[Info] " << msg << std::endl;
		}
	}
}

void LogUtil::logAll(std::string& msg){
	if(mLevel >= LogUtil::LOGALL){
		if(!mOutStream.fail()){
			mOutStream << "[Debug:] " << msg << std::endl;
		}else{
			std::cout << "[Debug:] " << msg << std::endl;
		}
	}
}

void LogUtil::logAlways(std::string& msg){
		if(!mOutStream.fail()){
			mOutStream << "[LOG:] " << msg << std::endl;
		}else{
			std::cout << "[LOG:] " << msg << std::endl;
		}
	
}

void LogUtil::logAlways(const char* msg){
	std::string tmp = msg;
	logAlways(tmp);
}

void LogUtil::logError(const char* msg){
	std::string tmp = msg;
	logError(tmp);
}
void LogUtil::logWarning(const char* msg){
	std::string tmp = msg;
	logWarning(tmp);
}
void LogUtil::logInfo(const char* msg){
	std::string tmp = msg;
	logInfo(tmp);
}

void LogUtil::logAll(const char* msg){
	std::string tmp = msg;
	logAll(tmp);
}

LogUtil::~LogUtil(){
	mOutStream.close();
}


const int Logger::OPEN_FILE_OPERATION = 1;
const int Logger::LOG_MSG_OPERATION = 2;
const int Logger::CLOSE_FILE_OPERATION = 3;

Logger::Logger(){
	mAutoFlush = true;
	mFileName = "";
	//mOutStream = new std::ofstream();
	initStringMsg();
}

Logger::Logger(bool autoflush){
	mAutoFlush = autoflush;
	mFileName = "";
	//mOutStream = new std::ofstream();
	initStringMsg();
}

Logger::~Logger(){
	mOutStream.flush();
	/*
	if(mOutStream){	
		delete mOutStream;
	}
	*/
}

void Logger::initStringMsg(){
	mDummyOptionalMsg.assign("");
	mBlankString.assign("");
	mUnableToOpenFileMsg.assign("Unable to open file ");
	mUnableToLogMsg.assign("Unable to log msg \"");
	mToFileMsg.assign("\" to file ");
	mUnableToCloseMsg.assign("Unable to close \"");
	mFileMsg.assign("\" file ");
}
std::string& Logger::getLogFileName(){
	return mFileName;
}

bool Logger::setLogFile(std::string& fileName){
	mFileName.assign(fileName.c_str());
	mOutStream.open(fileName.c_str(), std::ios::binary);
	return checkOutFileStreamError(Logger::OPEN_FILE_OPERATION,mDummyOptionalMsg);
}

bool Logger::setLogFile(char* fileName){
	mFileName.assign(fileName);
	mOutStream.open(fileName, std::ios::binary);
	return checkOutFileStreamError(Logger::OPEN_FILE_OPERATION,mDummyOptionalMsg);
}

std::ofstream& Logger::getOutStream(){
	return mOutStream;
}

bool Logger::close(){
	//std::string dummyOptionalMsg("");
	/*
	if(mOutStream){
		mOutStream.close();
	}
	*/
	mOutStream.close();
	return checkOutFileStreamError(Logger::CLOSE_FILE_OPERATION,mDummyOptionalMsg);
}



bool Logger::checkOutFileStreamError(int operation, std::string& optionalMsg){
	if(mOutStream.fail()){
		switch(operation){
			case Logger::OPEN_FILE_OPERATION : {
				mBlankString.assign(mUnableToOpenFileMsg.c_str());
				mBlankString.append(mFileName);
				
			}break;
			case Logger::LOG_MSG_OPERATION : {
				mBlankString.assign(mUnableToLogMsg.c_str());
				mBlankString.append(optionalMsg.c_str());
				mBlankString.append(mToFileMsg.c_str());
				mBlankString.append(mFileName.c_str());
				//msg+="Unable to log msg \"";
				//msg+=optionalMsg;
				//msg+="\" to file ";
				//msg+=mFileName;
			}break;
			case Logger::CLOSE_FILE_OPERATION : {
				mBlankString.assign(mUnableToCloseMsg.c_str());
				mBlankString.append(optionalMsg.c_str());
				mBlankString.append(mFileMsg.c_str());
				mBlankString.append(mFileName.c_str());
			};
		}
		////MessageBox(NULL,msg.c_str(),"Error",MB_OK);
		//mBlankString.assign("");//TOO optimisation needed
		std::cout << mBlankString << std::endl; 
		return false;
	}
	else
		return true;
}

bool Logger::checkOutFileStreamError(int operation)
{
	if(mOutStream.fail()){
		switch(operation){
			case Logger::OPEN_FILE_OPERATION : {
				mBlankString.assign(mUnableToOpenFileMsg.c_str());
				mBlankString.append(mFileName);
				
			}break;
			case Logger::LOG_MSG_OPERATION : {
				mBlankString.assign(mUnableToLogMsg.c_str());
				mBlankString.append(mToFileMsg.c_str());
				mBlankString.append(mFileName.c_str());
				
			}break;
			case Logger::CLOSE_FILE_OPERATION : {
				mBlankString.assign(mUnableToCloseMsg.c_str());
				mBlankString.append(mFileMsg.c_str());
				mBlankString.append(mFileName.c_str());
			};
		}
		std::cout << mBlankString << std::endl; 
		return false;
	}
	else
		return true;
}

bool Logger::logENDL(){
	mOutStream << std::endl;
		return checkOutFileStreamError(Logger::LOG_MSG_OPERATION);
}

bool Logger::logMsg(std::string& msg){
	mOutStream << msg;// << std::endl;
	return checkOutFileStreamError(Logger::LOG_MSG_OPERATION, msg);
}

bool Logger::logMsg(char* charstar_nullterminated){
	mOutStream << charstar_nullterminated;
	return checkOutFileStreamError(Logger::LOG_MSG_OPERATION);
}

bool Logger::logMsg(char* charstar, int lenght){
	mOutStream.write(charstar,lenght);
	return checkOutFileStreamError(Logger::LOG_MSG_OPERATION);
}

bool Logger::logMsg(char* charstar, long int lenght){
	mOutStream.write(charstar,lenght);
	return checkOutFileStreamError(Logger::LOG_MSG_OPERATION);
}

}
