/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/physics/AnticounterReader.cpp,v $
 * $Id: AnticounterReader.cpp,v 1.1.1.1 2008/09/23 07:20:22 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Implementation of the AnticounterReader class.
 */

#include <string>
#include "AnticounterReader.h"

extern "C" {
    #include "../forroutines/anticounter/AC.h"
    extern int ACphysics(int, unsigned char[] , struct physicsstruct*);
}

using namespace pamela;
using namespace pamela::anticounter;


/**
 * Constructor. 
 */
AnticounterReader::AnticounterReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelAnticounterReader") { 
  anticounter = new AnticounterEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string AnticounterReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/physics/AnticounterReader.cpp,v 1.1.1.1 2008/09/23 07:20:22 mocchiut Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void AnticounterReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &anticounter, anticounter->Class());
}

/**
 * Unpack the anticounter event from an input file.
 */
void AnticounterReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the Anticounter data event from the physical packet.
 */
void AnticounterReader::RunEvent(int EventNumber, const char subData[], long int length) {
	std::stringstream oss;
	string msg;

	char *data = new char[length];
	memcpy(data, subData, length);
	struct physicsstruct output[2] = {0};

	//Call to the routine that unpack anitocounter events
	//anticounter->ERROR = ACphysics(length, (unsigned char*) data, &(*output));
	anticounter->unpackError = ACphysics(length, (unsigned char*) data, output);

	oss.str("");
	UInt_t uerr = anticounter->unpackError;
	switch (uerr){
	case 0xFF: 
	  //		oss << "Anticounter unpacking: " << "data (physics or calibration) from both cards found";
	  //msg=oss.str();
	  //PamOffLineSW::mainLogUtil->logAll(msg);	
	  anticounter->unpackError = 0;
	  break;
	case 0xF0: 
	  oss << "Anticounter unpacking: " << "only data from main card found";
	  msg=oss.str();
	  PamOffLineSW::mainLogUtil->logError(msg);	
	  break;
	case 0x0F: 
	  oss << "Anticounter unpacking: " << "only data from extra card found";
	  msg=oss.str();
	  PamOffLineSW::mainLogUtil->logError(msg);	
	  break;
	case 0x00: 
	  oss << "Anticounter unpacking: " << "no data found";
	  msg=oss.str();
	  PamOffLineSW::mainLogUtil->logError(msg);	
	  anticounter->unpackError = 0xFF;
	  break;
	  oss << "Anticounter unpacking: " << "ANTICOUNTER ERRROR CODE UNIDENTIFIED";
	  msg=oss.str();
	  PamOffLineSW::mainLogUtil->logError(msg);	
	}


	for(int i = 0; i<2; i++){
		memcpy(anticounter->header[i], output[i].header, sizeof(anticounter->header[i]));
		anticounter->status[i] = output[i].status;
		anticounter->hitmap[i] = output[i].hitmap;
		memcpy(anticounter->regist[i],     output[i].regist,    sizeof(output[i].regist));
		memcpy(anticounter->shift[i],      output[i].shift,     sizeof(output[i].shift));
		memcpy(anticounter->counters[i],   output[i].counters,  sizeof(output[i].counters));
		memcpy(anticounter->coinc[i],      output[i].coinc,     sizeof(output[i].coinc));
		anticounter->trigg[i] = output[i].trigg;
		memcpy(anticounter->clock[i],      output[i].clock,     sizeof(output[i].clock));
		memcpy(anticounter->temp[i],       output[i].temp,      sizeof(output[i].temp));
		memcpy(anticounter->DAC[i],        output[i].DAC,       sizeof(output[i].DAC));
		anticounter->CRC[i]         = output[i].CRC;
		anticounter->CRCcheck[i]    = output[i].CRCcheck;
	}

	//}
	delete [] data;
}
