/** @file
 * $Source: /repository/PamOffLineSW/techmodel/RunHeaderReader.cpp,v $
 * $Id: RunHeaderReader.cpp,v 1.5 2008-03-04 18:09:31 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the RunHeader class.
*/


extern "C" {
	#include "CRC.h"
}
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
RunHeaderReader::RunHeaderReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelRunHeaderReader") { 
  RunHeader = new RunHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string RunHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/RunHeaderReader.cpp,v 1.5 2008-03-04 18:09:31 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void RunHeaderReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &RunHeader, RunHeader->Class());
}

/**
 * Unpack the RunHeader event from an input file.
 */
void RunHeaderReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException)
{
	std::stringstream oss; 
	string msg;	
	
    UINT16    subCRC;                   //calculated CRC of the data
    UINT16    readCRC;                  //CRC read from the end of the subpacket
    long int  dataLength = length - 2;  //the block of data
    subCRC = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);

    //TODO:check here ....
   //ORIG:    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for RunHeader Packet ");
  
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for RunHeader Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for RunHeader Packet. THE PACKET IS DISCARDED ");
    }	
 
    RunHeader->COMPILATIONTIMESTAMP       = (((UINT32)subData[0]<<24)&0xFF000000) + (((UINT32)subData[1]<<16)&0x00FF0000) +  (((UINT32)subData[2]<<8)&0x0000FF00)  + (((UINT32)subData[3])&0x000000FF);
    RunHeader->RM_ACQ_SETTING_MODE        = (BYTE)subData[4];
    RunHeader->OBT_TIME_SYNC              = (((UINT32)subData[5]<<24)&0xFF000000) + (((UINT32)subData[6]<<16)&0x00FF0000) +  (((UINT32)subData[7]<<8)&0x0000FF00)  + (((UINT32)subData[8])&0x000000FF);
    RunHeader->LAST_TIME_SYNC_INFO        = (((UINT32)subData[9]<<24)&0xFF000000) + (((UINT32)subData[10]<<16)&0x00FF0000) +  (((UINT32)subData[11]<<8)&0x0000FF00) + (((UINT32)subData[12])&0x000000FF);
    RunHeader->FAVOURITE_WORKING_SCHEDULE = (BYTE)subData[13];
    RunHeader->EFFECTIVE_WORKING_SCHEDULE = (BYTE)subData[14];
    RunHeader->PRH_VAR_TRIGGER_MODE_A     = (((UINT32)subData[15]<<24)&0xFF000000) + (((UINT32)subData[16]<<16)&0x00FF0000) +  (((UINT32)subData[17]<<8)&0x0000FF00) + (((UINT32)subData[18])&0x000000FF);
    RunHeader->PRH_VAR_TRIGGER_MODE_B     = (((UINT32)subData[19]<<24)&0xFF000000) + (((UINT32)subData[20]<<16)&0x00FF0000) +  (((UINT32)subData[21]<<8)&0x0000FF00) + (((UINT32)subData[22])&0x000000FF);
    RunHeader->RM_ACQ_AFTER_CALIB         = (BYTE)subData[23];
    RunHeader->TRK_CALIB_USED             = (((UINT32)subData[24]<<24)&0xFF000000) + (((UINT32)subData[25]<<16)&0x00FF0000) +  (((UINT32)subData[26]<<8)&0x0000FF00) + (((UINT32)subData[27])&0x000000FF);
    RunHeader->ACQ_BUILD_INFO             = (((UINT32)subData[28]<<24)&0xFF000000) + (((UINT32)subData[29]<<16)&0x00FF0000) +  (((UINT32)subData[30]<<8)&0x0000FF00) + (((UINT32)subData[31])&0x000000FF);
    RunHeader->ACQ_VAR_INFO               = ((((UINT16)subData[32]<<8)&0xFF00) + (((UINT16)subData[33])&0x00FF));
    RunHeader->CAL_DSP_MASK               = (BYTE)subData[34];
/*
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for RunHeader Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logWarning(msg);	
    	throw WrongCRCException_PKTUsed(" Wrong CRC for RunHeader Packet. ");
    }	
*/
}

