/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.4 $
 * 
 * Implementation of the InitHeaderReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
InitHeaderReader::InitHeaderReader(void): 
  TechmodelAlgorithm(PacketType::InitHeader, "TechmodelInitHeaderReader") { 
  initHeader = new InitHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string InitHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/InitHeaderReader.cpp,v 1.4 2008-03-04 18:09:30 messineo Exp $\n";
}

/**
 Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 *
 * @param run 
 */
void InitHeaderReader::Init(PamelaRun *run) { 
  run->WriteSubPacket(this, &initHeader, initHeader->Class());
}


/**
 * Unpack the InitHeader event from an input file.
 * @param EventNumber 
 * @param dataLength 
 */
void InitHeaderReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
	std::stringstream oss; 
	string msg;	

    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  length = dataLength - 2; //the block of data
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, length);
    readCRC = (((UINT16)(subData[dataLength - 2]<<8))&0xFF00) + (((UINT16)subData[dataLength - 1])&0x00FF);

    //if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for InitHeader Packet ");    
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for InitHeader Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for InitHeader Packet. THE PACKET IS DISCARDED ");
    }
    
	initHeader->initHeaderData        = new TArrayC(length, subData);
	
/*
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for InitHeader Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logWarning(msg);	
    	throw WrongCRCException_PKTUsed(" Wrong CRC for InitHeader Packet. ");
    }
 */ 	
}
