/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:31 $
 * $Revision: 1.4 $
 * 
 * Implementation of the Ac2InitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
Ac2InitReader::Ac2InitReader(void): 
  TechmodelAlgorithm(PacketType::Ac2Init, "Ac2InitReader") { 
  ac2Init = new Ac2InitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac2InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/Ac2InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac2InitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &ac2Init, ac2Init->Class());
}

/**
 * Unpack the Ac2Init event 
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void Ac2InitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){   
    ac2Init->ac2InitData        = new TArrayC(dataLength, subData);
}
