/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:31 $
 * $Revision: 1.4 $
 * 
 * Implementation of the TofAlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
TofAlarmReader::TofAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TofAlarm, "TechmodelTofAlarmReader") { 
  tofAlarm = new TofAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TofAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofAlarmReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &tofAlarm, tofAlarm->Class());
}

/**
 * Unpack the TofAlarm event 
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TofAlarmReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){  
    tofAlarm->tofAlarmData        = new TArrayC(dataLength, subData);
}
