// Implementation of the PhysEndRunReader class.
//new version...
extern "C" {
#include "CRC.h"
}

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
PhysEndRunReader::PhysEndRunReader(void): 
  TechmodelAlgorithm(PacketType::PhysEndRun, "TechmodelPhysEndRunReader") { 
  physEndRun = new PhysEndRunEvent();
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PhysEndRunReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &physEndRun, physEndRun->Class());
}

/**
 * Unpack the PhysEndRun event from an input file.
 * void PhysEndRunReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException_PKTUsed){
 * 
 */
void PhysEndRunReader::PKT_RunEvent(char* subData, long int length) throw (Exception){
	std::stringstream oss; 
	string msg;	

	// baco  /gpfs/wizard/flight/production/preRawreader/05510005.pam 
	if (length<21) 
	  {
	    oss.str("");
	    oss<<"Wrong Lenght for PhysEndRun Packet: "<<" length = "<< length<<" too small to be real";
	    msg=oss.str();
	    PamOffLineSW::mainLogUtil->logError(msg);			   	
	    //the packet is not good and will be discarded
	    throw FatalException(" Wrong Lenght for PhysEndRun Packet ");      	
	  }

	long int  dataLength = length ; // -2    
	long int  tbInitPos  = dataLength - 19; // 19 is the length of th TB

	//--------------- CALO SECTION------------------------------------
	long int offset = 0;
	int j = 0;
	// physEndRun->CALO_ENDRUN.
	while(offset < tbInitPos){
	  physEndRun->CALO_ENDRUN[j].CALO_BOARD_ID_HK     = (((UINT8)subData[offset])&0xFF);
	  physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_HK = ((UINT8)subData[offset+1]);
	  //
	  if (!(physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_HK & 0x02)) {
	    UInt_t kk = 0;
            for(int k = 0; k < 11 ; k++){
	      physEndRun->CALO_ENDRUN[j].CALO_HK0[k] = (((UINT16)(subData[offset+4+kk]<<8))&0xFF00) + (((UINT16)subData[offset+5+kk])&0x00FF);
	      physEndRun->CALO_ENDRUN[j].CALO_HK1[k] = (((UINT16)(subData[offset+26+kk]<<8))&0xFF00) + (((UINT16)subData[offset+27+kk])&0x00FF);
	      kk += 2;
            }	    
            offset = offset + 50; //CALO_BOARD_ID_HK + CALO_BOARD_STATUS_HK + 2*CALO_HKx + CRC (2Bytes)
	  } else offset = offset + 4; //CALO_BOARD_ID_HK + CALO_BOARD_STATUS_HK + CRC (2Bytes)
	  //
	  for(int k = 0; k < 7 ; k++){
	    //
	    // in CALO_BOARD_ID_REG and CALO_BOARD_STATUS_REG we save only the last id and status register of the 7 and we don't save the CRC for each register.
	    // 
	    physEndRun->CALO_ENDRUN[j].CALO_BOARD_ID_REG[k]     = ((UINT8)(subData[offset])&0xFF);
	    offset++;
	    physEndRun->CALO_ENDRUN[j].CALO_BOARD_STATUS_REG[k] = (UINT8)(subData[offset]);
	    offset++;
	    offset++;
	    offset++;
	    physEndRun->CALO_ENDRUN[j].CALO_REG[k] = (((UINT16)(subData[offset]<<8))&0xFF00) + (((UINT16)subData[offset+1])&0x00FF);
	    offset++;
	    // CRC
	    offset++;
	    offset++;
	    offset++;
	    //
	  };
	  //
	  j++;
	}
	//
	physEndRun->TB_ENDRUN.TB_ALARM_MASK   = (((UINT32)(subData[offset]<<16))&0x00FF0000) + (((UINT32)(subData[offset + 1]<<8))&0x0000FF00) + (((UINT32)(subData[offset + 2]))&0x000000FF);
	offset += 3;
	//
	physEndRun->TB_ENDRUN.TB_PMT_MASK_S3S2S12 = (((UINT32)(subData[offset]<<24))&0xFF000000) + (((UINT32)(subData[offset + 1]<<16))&0x00FF0000) + (((UINT32)(subData[offset + 2]<<8))&0x0000FF00)  + (((UINT32)(subData[offset + 3]))&0x000000FF);
	offset += 4;
	//
	physEndRun->TB_ENDRUN.TB_PMT_MASK_S11CRC = (((UINT32)(subData[offset]<<16))&0x00FF0000) + (((UINT32)(subData[offset + 1]<<8))&0x0000FF00) + (((UINT32)(subData[offset + 2]))&0x000000FF);
	offset += 3;
	//
	physEndRun->TB_ENDRUN.TB_S4_CAL_MASK = (((UINT16)(subData[offset]<<8))&0xFF00) + (((UINT16)(subData[offset + 1]))&0x00FF);
	offset += 2;
	//
	physEndRun->TB_ENDRUN.TB_BUSY_MASK = (((UINT32)(subData[offset]<<24))&0xFF000000) + (((UINT32)(subData[offset + 1]<<16))&0x00FF0000) + (((UINT32)(subData[offset + 2]<<8))&0x0000FF00)  + (((UINT32)(subData[offset + 3]))&0x000000FF);
	offset += 4;
	//
	physEndRun->TB_ENDRUN.TB_TRIG_CONF = (((UINT32)(subData[offset]<<16))&0x00FF0000) + (((UINT32)(subData[offset + 1]<<8))&0x0000FF00) + (((UINT32)(subData[offset + 2]))&0x000000FF);
	offset += 3;
	//
	// PHYSENDRUN HAS NOT CRC AT THE END!!!
	//
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PhysEndRunReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/techmodel/PhysEndRunReader.cpp,v 1.3 2008/09/24 15:17:23 mocchiut Exp $\n";
}
