/** @file
 * $Author: messineo $
 * $Date: 2008-03-03 15:37:16 $
 * $Revision: 1.10 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */

#include "event/PamelaRun.h" 
#include "TechmodelAlgorithm.h"

namespace pamela {
  namespace techmodel {
 
  /**
     * Main event reader algorithm. It handles all other specific
     * reader algorithms.
     */
    class EventReader: public TechmodelAlgorithm {
    private:
      /**
       * A map with an algorithm to read the techmodel file with the packet
       * type as key.
       */
      typedef std::map<const PacketType *, TechmodelAlgorithm *> AlgorithmMap;
      /**
       * The map that links every packet type to an algorithm that reads it.
       */
      AlgorithmMap TechmodelAlgorithmMap; //!
     
      /**
       * The Run that is processed.
       */   
      PamelaRun *Run; 

      public:
	 	
    	//The event header
	   EventHeader* Header;
	   void PKT_UnpackPscuHeader(char* buff); 
		  
	   //Distructor  
	   virtual ~EventReader(void);
	   EventReader(void);
	   
      virtual void Init(PamelaRun *);
           
//      virtual void PKT_RunEvent(char* headerPkt, char *pamPkt, long int length, const PacketType* type);
      virtual int PKT_RunEvent(char* headerPkt, char *pamPkt, long int length, const PacketType* type);

      virtual std::string GetVersionInfo(void) const;
      
      ClassDef(EventReader, 1)
    };
  }
}
