#ifndef R4_HEADER_STATE_H_
#define R4_HEADER_STATE_H_

#include "State.h"

namespace PamOffLineSW
{

class R4_HEADER_State : public PamOffLineSW::State
{
public:
	virtual ~R4_HEADER_State();
	void readInput(char inputbyte);
	static R4_HEADER_State& getInstance(){return instance;}

	void initBufferPKT(char* headPKT);
	void deleteBufferPKT();
	
private:
	R4_HEADER_State();
	static R4_HEADER_State instance;	
		
	//only the header
	char* headerPKT;
	//the header length
	//LENGTH_HEADER_PKT
	//only the pam packet without header
	char* pamPKT;
	//the packet length
	long int pamPKT_length;
	//where I am
	long int posPamPKT;
	
	bool isPKTGood;//if the packet is all good i.e. if all the cadres used are good
	
};

}

#endif /*R4_HEADER_STATE_H_*/
