/** @file
 * $Source: /repository/PamOffLineSW/techmodel/TsbBReader.cpp,v $
 * $Id: TsbBReader.cpp,v 1.5 2008-03-04 18:09:30 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the TsbBReader class.
 */

extern "C" {
    #include "CRC.h"
}
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
TsbBReader::TsbBReader(void): 
  TechmodelAlgorithm(PacketType::TsbB, "TechmodelTsbB") { 
  TsbB = new TsbBEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TsbBReader::GetVersionInfo(void) const {
  return     "$Header: /repository/PamOffLineSW/techmodel/TsbBReader.cpp,v 1.5 2008-03-04 18:09:30 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TsbBReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &TsbB, TsbB->Class());
}

/**
 * Unpack the TsbB event
 */
void TsbBReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException){ 
	std::stringstream oss; 
	string msg;	
	
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  dataLength = length - 2; //the block of data
    memset(subData,  0, length*sizeof(char));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, dataLength);
    readCRC = (((UINT16)(subData[length - 2]<<8))&0xFF00) + (((UINT16)subData[length - 1])&0x00FF);
    
   // if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for TsbB Packet ");
    if (subCRC != readCRC)
    {
    	oss.str("");
    	oss<<"Wrong CRC for TsbB Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
    	msg=oss.str();
    	PamOffLineSW::mainLogUtil->logError(msg);	
    	throw WrongCRCException(" Wrong CRC for TsbB Packet. THE PACKET IS DISCARDED ");
    }
    
    TsbBRecord* rec;
    TsbB->Records->Clear();
    TClonesArray &recs = *(TsbB->Records);
    
    int i = 0;
    long int offset = 0;
    while (offset < dataLength){
        rec               = new(recs[i++]) TsbBRecord(); //add a new TsbB
        rec->RECORD_OBT  = (((UINT32)subData[offset]<<24)&0xFF000000) + (((UINT32)subData[offset+1]<<16)&0x00FF0000) +  (((UINT32)subData[offset+2]<<8)&0x0000FF00) + (((UINT32)subData[offset+3])&0x000000FF);
        rec->STATUS_CODE = subData[offset+4];
        for (int j=0; j < 7; j++){
            rec->B_FIELD[j]  = ((((UINT16)subData[offset+5+(2*j)]<<8)&0xFF00) + (((UINT16)subData[offset+6+(2*j)])&0x00FF));
        }
        offset = offset + 19;
    }
   
    
    /*
               if (subCRC != readCRC)
               {
               	oss.str("");
               	oss<<"Wrong CRC for TsbT Packet: "<<" CRC COMPUTED= "<< subCRC<<" CRC READ=  "<< readCRC;
               	msg=oss.str();
               	PamOffLineSW::mainLogUtil->logWarning(msg);	
               	throw WrongCRCException_PKTUsed(" Wrong CRC for TsbT Packet. ");
               }
         */ 	
    
    
  }
