//============================================================================
// $Id: PacketUser.cpp,v 1.64 2008-04-01 16:03:20 messineo Exp $ 
// Description : 
//============================================================================
#include "PacketUser.h"
#include <sys/time.h>

namespace PamOffLineSW
{
extern LogUtil* mainLogUtil;
extern short compression ;
extern	char *outDir;
extern TSQLServer *sqlServer;
extern bool multiFile;
extern char* fni;
extern char * nome_output;
extern bool is_new_route;
extern unsigned int download;

extern unsigned int  mmm_number;
extern unsigned int orbit_number;	
extern unsigned long int time_Offset;
extern bool tryMerge;

extern bool do_cont_check;

//extern unsigned long int delta_Time;//unused ??

PacketUser PacketUser::instance;
	
int PacketUser::numDiscontinity=0;
int PacketUser::numPKT=0;
int PacketUser::numPKTSaved=0;

PacketUser& PacketUser::getInstance()
{
	return instance;
}

PacketUser::PacketUser()
{	
	gROOT->SetBatch(kTRUE);    	
	numDiscontinity=0;
	numPKTSaved=0;
	numPKT=0;	
	pkt_number_init=0;
	obt_init=0;
	pkt_number_last=0;
	obt_last=0;
	obt_time_sync=0;
	last_time_sync_info=0;
	real_time_init=0;
	real_time_last=0;
	bad_pkt=0;
	bad_pkt_EventReader=0;
	bad_pkt_CalibReader=0;
	reader= NULL; 
	pRun=NULL;
	reader=new pamela::techmodel::EventReader();
	Table_ROOT_Good="ROOT_TABLE";
	Table_ROOT_Bad="ROOT_TABLE_BAD";
	Table_PKT_Bad=  "BAD_PKT_TABLE";
	Table_GL_RESURS_OFFSET="GL_RESURS_OFFSET";
	
//	good_pkt_Calib=0;
	
}

PacketUser::~PacketUser()
{	
	if(reader){delete reader; reader = NULL;}
	numDiscontinity=0;
	numPKTSaved=0;
	numPKT=0;
	pkt_number_init=0;
	obt_init=0;
	pkt_number_last=0;
	obt_last=0;
	obt_time_sync = 0;
	last_time_sync_info = 0;
	real_time_init=0;
	real_time_last=0;
	bad_pkt=0;
	bad_pkt_EventReader=0;
	bad_pkt_CalibReader=0;
//	good_pkt_Calib=0;
}

//Put the packet in a root file. Create a new ROOT file for each group of packets 
void PacketUser::usePKT(char*& headerPkt, char*& pamPkt, long int length, bool isCons, bool isPKTGood, const PacketType* type, 
		unsigned long int counter, unsigned long int obt)
{			
	//If the packet type was not recognised before
	if(!type){return;} //numPKT++;
	  
	//in order to start ...
	if(numPKT==0)
	{		
		setInit(counter,obt);				
		StartGroup();		
	}
		
	//here we know if the incoming packet can be considered consecutive to the previuos	one		
	if((!isCons)&&(numPKT!=0))
	{			
		setReal_Time();				
		//closing the  group in file rootfilename 
		FinishGroup(rootfilename);		
		
		//the current pkt will be placed in a new group: rootfilename 
		numDiscontinity++;	
		setInit(counter,obt);			
		StartGroup();
	}
	
	//add current packet to the group and calculate bad_pkt_EventReader and bad_pkt_CalibReader
	int ret=
	reader->PKT_RunEvent(headerPkt, pamPkt, length, type);
	/*
	  ret
		0    packet good
	    1    exception but used    //never happen
	    2    CRC exception but used
	    3    CALIBRATION PACKET with error but used
	   -1    CRC exception  packet DISCARDED
	   -2    FATAL exception packet DISCARDED //never happen
	   -3    No way to read events of this type. packet DISCARDED( es OLD CalibCal)
	ret = 10 if the packet is good but comes from a cadre with VRL problems
	*/
	
	//here we know if the packet comes from one or more corrupted cadres
	//if(!isPKTGood){bad_pkt++;}
	if((!isPKTGood)&&(!ret)){ret=10;}	
	
	switch (ret) 
	{
		case 0: {numPKTSaved++; break;}
		case 1: {bad_pkt_EventReader++; numPKTSaved++; break;}
		case 2: {bad_pkt_EventReader++;numPKTSaved++;  break;}
		case 3: {bad_pkt_CalibReader++; numPKTSaved++; break;}
		case 10: {bad_pkt++; numPKTSaved++; break;}
		default:{ 
			stringstream oss;
			oss.str()="";
			oss<<"Packet DISCARDED, reason = "<<ret;
			string msg = oss.str();
			mainLogUtil->logAll(msg);
			break;
		}
	}
/*	
	if ((ret==0)&&((type==PacketType::CalibTrk1)||(type==PacketType::CalibTrk2)|| (type==PacketType::CalibCalPed)))
	{				
		good_pkt_Calib++;//maybe I will remove this in future
	}
*/	
	
	if(ret>=0)// only the packet not discarded of course
		setLast(counter,obt);
	
//TODO: decide what kind of packet I can use here
//	if((ret==0)||(ret==10))//I want to use only good packet
	if(ret>=0)//I want to use only accepted packet
		setTimeSync(pamPkt, type);
	
	//if(ret>0)// if I want to save all the packets with error and the reason
	if(ret==3)//I want to save only Calibration packets	
	{	
		/*			
			//dbg: save in file, 
			//TODO remove this later
			//if(SaveInFile)
			savePKT_file(headerPkt, 
					pamPkt, 
					length, 
					false,
					rootfilename);
			mainLogUtil->logInfo("saved bad packet in file");
		*/
		//TODO: move the storing in DB after, when I know the  ROOT_ID_N
		// If I don't have the DB I can exit 
		if(!do_cont_check){ 
			if(pamPkt){delete[] pamPkt; pamPkt = NULL;}	
			if(headerPkt){delete[] headerPkt; headerPkt = NULL;}		
			numPKT++;
			return;
		}
		
		if(saveBADPKT_DB(Table_PKT_Bad, 
				outDir,
				rootfilename, 
				counter, 
				obt,
				fni,
				ret,
				999)==true)
		{
			stringstream oss1;
			oss1.str()="";
			oss1<<"Saved information regarding bad packet of file: "<<rootfilename<<" in table "<<Table_PKT_Bad;
			string msg1 = oss1.str();
			mainLogUtil->logInfo(msg1);	
		}
		else
		{				
			stringstream oss1;
			oss1.str()="";
			oss1<<"Problem storing information regarding bad packet of file: "<<rootfilename<<" in table "<<Table_PKT_Bad;
			string msg1 = oss1.str();
			mainLogUtil->logError(msg1);	
		}
	}

	//just to be sure ...
	if(pamPkt){delete[] pamPkt; pamPkt = NULL;}	
	//just to be sure ...
	if(headerPkt){delete[] headerPkt; headerPkt = NULL;}

	numPKT++;		
}

//set the value of the counter and obt of the first packet of the group 
void PacketUser::setInit(unsigned long int counter, unsigned long int obt)
{				
	sprintf(nnnn_mmm_ppp,"%05d_%03d_%03d", orbit_number, mmm_number, download);
	sprintf(rootfilename,"%s_%s_%d", nome_output, nnnn_mmm_ppp, numDiscontinity);
	pkt_number_init=counter;
	obt_init=obt;
	pkt_number_last=0;
	obt_last=0;
	real_time_init=0;
	real_time_last=0;
	bad_pkt=0;	
	numPKTSaved=0;
	bad_pkt_EventReader=0; bad_pkt_CalibReader=0;
	//good_pkt_Calib=0;
}

//starts a new root file
void PacketUser::StartGroup()
{	
	pRun = new PamelaRun(rootfilename, outDir , multiFile, compression);
	reader->Init(pRun);			
	stringstream oss;
	oss.str()="";
	oss<<"######################### Start a new group in file: "<< rootfilename <<" ############################";
	string msg = oss.str();
	mainLogUtil->logInfo(msg);
}

//set the value of the counter and obt of the last packet of the group 
void PacketUser::setLast(unsigned long int counter, unsigned long int obt)
{
	pkt_number_last=counter;
	obt_last=obt;
}

//retrieve obt_time_sync and last_time_sync_info from packet if type has special values 
void PacketUser::setTimeSync(char* packet, const PacketType* type)
{
    //do nothing 
	if(!do_cont_check) {
		if(is_new_route)
			is_new_route=false;
		return;	
	}
	
//TODO: usare anche MCMD ... NOTA: questo da sempre errore ret != 0 
//In RunHeader e RunTrailer sono in secondi(?), controllare se aggiungo altri tipi di paccheti se invece sono in secondi
	
	//When I found a new download I need to reset all values
	if(is_new_route)
	{   
	  //reset
	  obt_time_sync=0; last_time_sync_info=0; is_new_route=false;
	  if(time_Offset)
	     timeOffset=time_Offset;
	  else		
	    timeOffset=retrieveTimeOffset();
	}
	
	//Retrieve if possible obt_time_sync and last_time_sync_info
	//i don't need to retrieve them again if they are good
	if((obt_time_sync)||(last_time_sync_info)) return;

	int offset=0;
	if(type==PacketType::RunHeader)
	{		
		offset=0;
	}
	else if(type==PacketType::RunTrailer)
	{			
		offset=3;
	}
	else if(type==PacketType::Mcmd)
	{	
		mainLogUtil->logAll("TODO: Packet Mcmd now is not used to retrieve Absolute time. This may cause problems somewhere.");
		return;
	}
	else
	{	
		return;
	}		
	obt_time_sync = (((UINT32)packet[5+offset]<<24)&0xFF000000) + (((UINT32)packet[6+offset]<<16)&0x00FF0000) + (((UINT32)packet[7+offset]<<8)&0x0000FF00) + (((UINT32)packet[8+offset])&0x000000FF); 
	last_time_sync_info = (((UINT32)packet[9+offset]<<24)&0xFF000000) + (((UINT32)packet[10+offset]<<16)&0x00FF0000) + (((UINT32)packet[11+offset]<<8)&0x0000FF00) + (((UINT32)packet[12+offset])&0x000000FF);   		

	stringstream oss;
	oss.str()="";
	oss<<"In download: "<<download<<" timeOffset: "<<timeOffset<<" obt_time_sync: "<<obt_time_sync<<" last_time_sync_info: "<<last_time_sync_info<<" using Packet Type: "<<type->GetName().c_str();
	string msg = oss.str();
	mainLogUtil->logAll(msg);
}

//set the real time of the first packet and the last packet oif a group of packet if possible
void PacketUser::setReal_Time()
{
	if((obt_time_sync)||(last_time_sync_info))
	{		
		real_time_init=(obt_init/1000-obt_time_sync)+last_time_sync_info;
		real_time_last=(obt_last/1000-obt_time_sync)+last_time_sync_info;	
		real_time_init+=timeOffset;
		real_time_last+=timeOffset;		
	}	
}

//timeOffset
//retrieve from table GL_RESURS_OFFSET timeOffset  
unsigned long int PacketUser::retrieveTimeOffset()
{	
	//TODO check here ... marco		  
	if(!do_cont_check) return 0;
	UInt_t t0 = 0;	//toffset		
			
	stringstream oss;
	oss.str("");
	oss << "SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE),ID FROM GL_RESURS_OFFSET WHERE SPECIAL_FILE='" 
	      << nnnn_mmm_ppp << "';";
		
	TSQLResult* res=NULL;				 
	TSQLRow* row=NULL;	
	res= sqlServer->Query(oss.str().c_str());			  
   	if(!res)
   	{	
    	cout<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;
   		return 0;
   	}

    row=res->Next();
    if (!row )
    {
    	if(res){delete res; res = NULL;}

    	oss.str("");
        oss << "SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE),ID FROM GL_RESURS_OFFSET WHERE FROM_ORBIT < " 
    	<< orbit_number << " order by FROM_ORBIT desc limit 1;";
    	res= sqlServer->Query(oss.str().c_str());			
     	if(!res)
       	{   		
        	cout<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;
       		return 0;
       	}
        row=res->Next();
        if (!row) 
        {
        	cout<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;
       		return 0;
       	}
                 
      }
     
      TTimeStamp tu = TTimeStamp((UInt_t)atoi(row->GetField(0)),(UInt_t)atoi(row->GetField(1)),(UInt_t)atoi(row->GetField(2)),(UInt_t)atoi(row->GetField(3)),(UInt_t)atoi(row->GetField(4)),(UInt_t)atoi(row->GetField(5)),0,true,0);
      t0 = (UInt_t)tu.GetSec();
      
 if(res){delete res; res = NULL;}
 if(row){delete row; row = NULL;}	
 
 return t0;
}

//this is public and can be called from the main at the end of the game
void PacketUser::FinishLastGroup()
{	
	mainLogUtil->logAll("######################### Closing the last group ############################");	
	setReal_Time();
	FinishGroup(rootfilename);
	mainLogUtil->logAll("######################### Closed the last group ############################");	

}

//finish the old root file
void PacketUser::FinishGroup(char * filename)
{
	if(pRun)
	{
		pRun->WriteFiles();				
		delete pRun; pRun = NULL;		
		stringstream close;
		close.str()="";
		string msg;

		close<<"######################### Close group in file: "<< rootfilename <<" ############################";
		msg = close.str();
		mainLogUtil->logInfo(msg);

//TODO: check ... se non faccio proprio controlli su continuita' neanche salvo su DB
//	if((!step_pkt_number)&&(!step_pkt_obt)) return;
		if(!do_cont_check) return;
	
		stringstream oss;
		oss.str()="";
		
//TODO: check when I don't want to log in DB informations

		// se non ho salvato nessun pacchetto
		if(numPKTSaved==0){			
			stringstream err;
			err.str()="";
			err<<"NO PACKET SAVED in file: "<< rootfilename <<" The group is empty: you can remove this file.";
			msg = err.str();
			mainLogUtil->logError(msg);
			return;
		}
			
		//se non ho salvato nessun pacchetto buono
		if((numPKTSaved-bad_pkt_EventReader-bad_pkt_CalibReader-bad_pkt)==0){			
			stringstream err;
			err.str()="";
			err<<"NO GOOD PACKET SAVED in file: "<< rootfilename <<" The group is BAD: you may want to remove this file.";
			msg = err.str();
			mainLogUtil->logInfo(msg);
//			mainLogUtil->logError(msg);
//			return; //TODO: ???
		}
/*		
		//se non ho salvato nessun pacchetto buono di calibrazione
		if(good_pkt_Calib==0){
			stringstream err;
			err.str()="";
			err<<"NO GOOD CALIB PACKET SAVED in file: "<< rootfilename <<" this is strange";
			msg = err.str();
			mainLogUtil->logInfo(msg);
//			mainLogUtil->logError(msg);
//			return;			
		}
//TODO: I should/can use good_pkt_Calib storing this info in DB??				
*/		
		
		//don't save in Table_ROOT_Good and don't search for ROOT files in the same temporal range
		if((!real_time_init)&&(!real_time_last))
		{ 
			//saved in another table for future study	  Record_Time()	
			if(saveROOT_DB(Table_ROOT_Bad, outDir,
								filename, 
							   pkt_number_init, pkt_number_last,
							   obt_init, obt_last,
							   obt_time_sync, last_time_sync_info,	   
							   real_time_init, real_time_last, 
							   timeOffset,
							   bad_pkt, bad_pkt_EventReader, bad_pkt_CalibReader, numPKTSaved,
							   fni)==true)
				{
					oss.str()="";
					oss<<"Saved information regarding file: "<<filename<<" in table "<<Table_ROOT_Bad;
					msg = oss.str();
					mainLogUtil->logInfo(msg);	
				}
				else
				{	
					oss.str()="";
					oss<<"Problem storing information in DB regarding file: "<<filename;
					msg = oss.str();
					mainLogUtil->logError(msg);		
				}			
			return;
		}
					
		//saves info in DB in table Table_ROOT_Good
		if(saveROOT_DB(Table_ROOT_Good, outDir,
					filename, 
				   pkt_number_init, pkt_number_last,
				   obt_init, obt_last,
				   obt_time_sync, last_time_sync_info,	   
				   real_time_init, real_time_last,
				   timeOffset,
				   bad_pkt, bad_pkt_EventReader, bad_pkt_CalibReader, numPKTSaved,
				   fni)==true)
		{						
			oss<<"Saved information regarding file: "<<filename<<" in table "<<Table_ROOT_Good;
			msg = oss.str();
			mainLogUtil->logInfo(msg);	
			
			//TODO : work on this ....			
			if(tryMerge){				
				merge_ROOTfiles();
			}
		}
		else
		{
			oss<<"Problem storing information in DB regarding file: "<<filename;
			msg = oss.str();
			mainLogUtil->logError(msg);	
		}				
	}
}

//inserisci in DB in apposita tabella il pkt con errore
bool PacketUser::saveBADPKT_DB(char* table_name, 
			char* folder_name, 
			char* file_name, 
			unsigned long int pkt_number, 
			unsigned long int pkt_obt, 
			char* nome_input,
			int reason,
			int rootID)
{
		stringstream oss;
		oss.str("");	
		oss << "INSERT INTO "<< table_name <<" (ID_N, FOLDER_NAME, FILE_NAME, PKT_NUMBER, PKT_OBT, INPUT_NAME, REASON, ROOT_ID_N, INSERT_TIME)"
	    << " VALUES ('"<<0<< "','" <<folder_name<<"','" <<file_name<< "','" 
	    << pkt_number <<"','"
	    << pkt_obt << "','"
	    << nome_input <<"','"
	    << reason <<"','"<< rootID<< "'," 
	    <<"NULL"<<	    
	    ")";   	    
		string msg = oss.str();
		mainLogUtil->logAll(msg);	
		
		stringstream oss1;
		oss1.str()="";
		string msg1;
	   
	   TSQLResult* res=NULL;	
	   res= sqlServer->Query(oss.str().c_str());
	   if(!res)
	   {	
		   oss1<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;   
		   msg1=oss1.str();
		   mainLogUtil->logError(msg1);   
		   return false;
	   }
	   if(res){delete res; res = NULL;}			   
	   return true;	
}

//save in Table_ROOT_Good or in Table_ROOT_Bad
bool PacketUser::saveROOT_DB(char* table_name, char* folder_name, char* file_name, 
		unsigned long int pkt_number_init, unsigned long int pkt_number_final,
		unsigned long int obt_init, unsigned long int obt_final,
		unsigned long int  oT_sync, unsigned long int lT_sync_info,	   
		unsigned long int mtime_init, 	unsigned long int mtime_last, 
		unsigned long int time_offset, 	
		int bad_pkt, int bad_pkt_read, int bad_pkt_CalRead, int num_PKT_Saved,		
		char* nome_input)
{			
	//TODO: forse far ritornare ID della cosa appena inserita se e' andatato tutto ok invece che true false?	
	stringstream oss;
	oss.str("");	
	oss << "INSERT INTO "<< table_name <<" (ID_N, FOLDER_NAME, FILE_NAME, PKT_NUMBER_INIT, PKT_NUMBER_FINAL, PKT_OBT_INIT, PKT_OBT_FINAL, OBT_TIME_SYNC, LAST_TIME_SYNC_INFO, REAL_TIME_INIT,REAL_TIME_LAST,TIME_OFFSET,BAD_PKT,BAD_PKT_READ,BAD_PKT_CALREAD,NUM_PKT_SAVED,INPUT_NAME,INSERT_TIME)"
    << " VALUES ('"<<0<< "','" <<folder_name<<"','" <<file_name<< "','" << pkt_number_init <<"','"<< pkt_number_final << "','"<< obt_init <<"','"<< obt_final<< "','" 
    << oT_sync << "','" << lT_sync_info << "','"
    << mtime_init << "','" << mtime_last << "','"
    << time_offset << "','"
    << bad_pkt <<"','" << bad_pkt_read <<"','"<< bad_pkt_CalRead <<"','"<< numPKTSaved<<"','"
    << nome_input <<"',"
    <<"NULL"<<	    
    ")";   	    
	string msg = oss.str();
	mainLogUtil->logAll(msg);	
	
	stringstream oss1;
	oss1.str()="";
	string msg1;
   
   TSQLResult* res=NULL;	
   res= sqlServer->Query(oss.str().c_str());
   if(!res)
   {	
	   oss1<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;   
	   msg1=oss1.str();
	   mainLogUtil->logError(msg1);   
	   return false;
   }
   if(res){delete res; res = NULL;}
   return true;
}

//save a packet in a file
void PacketUser::savePKT_file(char* headerPkt, 
							 char* pamPkt, 
							 long int length, 
							 bool append,
							 char* nomefile)
{
	char fno[80]="";
	ofstream fout;
	sprintf(fno,"%s/pkt%d_of_%s.pkt", outDir, numPKTSaved, nomefile);

	if(append==true)
		fout.open(fno, ios::binary | ios::app);
	else
		fout.open(fno, ios::binary);			
		
	if (!fout) {cout<<"can not open output file "<<fno<<endl; return;}		    
	fout.write(headerPkt,LENGTH_HEADER_PKT);
	fout.write(pamPkt,length);
	fout.close(); 	 
}


/**********************************************************************************************/
/*###########################################################################################################*/
/**********************************         MERGING          *************************************************/
/*###########################################################################################################*/
//    Merge ROOT files: found other ROOT files in the same temporal ranges
//it finds ROOT files that covers particular temporal range of interest and save this info in DB
/**********************************************************************************************/
bool PacketUser::merge_ROOTfiles()
{
	//do nothing....
	//mainLogUtil->logAlways(" Merging functionality doesn't work properly. Try to do it later !!");
	//cout<<"DBG: Merging functionality doesn't work properly. Try to do it later !!"<<endl;
	//return false;
	
//TODO: se non ho almeno due packetti buoni non uso		
	if((numPKTSaved-bad_pkt_EventReader-bad_pkt_CalibReader-bad_pkt)<2){	
		stringstream oss;
		string msg;
		oss.str()="";
		oss<<"NO ENOUGH GOOD PACKET SAVED in file: "<< rootfilename <<" The group is BAD and don't used in Merging.";

		msg = oss.str();
		mainLogUtil->logError(msg);		
		return false;
	}		

	//the ID of the current ROOT file in table Table_ROOT_Good
	unsigned int my_id = select_maxIDN_DB(Table_ROOT_Good);
	unsigned int n_tot_ass =0;
	unsigned int *idN_ass = NULL;	   
	unsigned int num_ass =0;
	for(int relaz=AFTER; relaz<=BIGGER; relaz++){		
		idN_ass = Return_IDN_ASS(real_time_init, real_time_last, (type_Rel_ROOT)relaz, my_id, num_ass);

		for(int i=0;i<num_ass;i++)
			saveROOT_ASS_DB("ROOT_TABLE_ASS", my_id, idN_ass[i], relaz);//change here					   			

		n_tot_ass += num_ass;
		num_ass =0;
		if(idN_ass){delete[] idN_ass; idN_ass=NULL;}
	}	
	
	if(n_tot_ass)
	{		
		mainLogUtil->logInfo(" Merged ");	
		return true;
	}
	else
	{
		mainLogUtil->logInfo(" Nothing to Merge ");	
		return false;
	}
}


unsigned int* PacketUser::Return_IDN_ASS(unsigned long int mtime_init, unsigned long int mtime_last, type_Rel_ROOT type_rel, unsigned int my_id, unsigned int &num_ass)
{	
	unsigned int *idNass = NULL;	   	
	stringstream query;
	query.str("");
	
	//ordinare in qualche modo
	//TODO usare delta_Time: almeno per AFTER e BEFORE ho una certa tolleranza?	
	
	if(type_rel == AFTER) 		
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_LAST = "<< real_time_init<<" and ID_N != " <<my_id;
	else if(type_rel == AFTER2)
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_LAST > "<< real_time_init <<" and REAL_TIME_LAST < "<< real_time_last <<" and REAL_TIME_INIT < "<< real_time_init<<" and ID_N != " <<my_id ;
	else if(type_rel == BEFORE)
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_INIT = "<< real_time_last<<" and ID_N != " <<my_id ;
	else if(type_rel == BEFORE2)
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_INIT > "<< real_time_init <<" and REAL_TIME_INIT < "<< real_time_last <<" and REAL_TIME_LAST > "<< real_time_last <<" and ID_N != " <<my_id ;
	else if(type_rel == SMALLER) 
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_INIT < "<< real_time_init <<" and REAL_TIME_LAST > "<< real_time_last<<" and ID_N != " <<my_id ;
	else if(type_rel == BIGGER) 
		query<<"select ID_N from "<<Table_ROOT_Good<<" where REAL_TIME_INIT > "<< real_time_init <<" and REAL_TIME_LAST < "<< real_time_last<<" and ID_N != " <<my_id ;
	else 
		return 0;
	//TODO: change here ....
	query<<" and NUM_PKT_SAVED - BAD_PKT_CALREAD - BAD_PKT_READ - BAD_PKT >= 2" ;
	///cout<<"$$$$$ DBG: "<<query.str().c_str()<<endl;
	
	 TSQLResult* res=NULL;				 
	 TSQLRow* row=NULL;
	 unsigned int num_rows=0;
 
	 res= sqlServer->Query(query.str().c_str());			

	 stringstream oss1;
	 oss1.str()="";
	 string msg1;
  
	 if (!res) 
	 {
		 oss1<<"DBError UNABLE to: "<<query.str().c_str()<<endl;   
		 msg1=oss1.str();
		 mainLogUtil->logError(msg1);   
		 return 0;
	 }

	 num_rows=res->GetRowCount();
	 if(num_rows>0)
	 {			
		 idNass = new unsigned int[num_rows];	  
   
		 for(unsigned int i=0; i<num_rows; i++)
		 {
			 row=res->Next();
			 if (!row) 
			 {
				 oss1<<"DBError UNABLE to: "<<query.str().c_str()<<endl;   
				 msg1=oss1.str();
				 mainLogUtil->logError(msg1);   
				 return 0;
			 }
			 idNass[i]=atoi(row->GetField(0));
			 stringstream oss2;
			 oss2.str()="";
			 oss2<<" my_id "<<my_id<<"  ha type_rel = "<<type_rel<<" rispetto: "<<idNass[i];
			 string msg2 = oss2.str();
			 mainLogUtil->logAll(msg2);

		 }	   
   }
	   		   
	if(res){delete res; res = NULL;}
	if(row){delete row; row = NULL;}
	
	num_ass=num_rows;
		return idNass;
}

//Utility: return max(IDN) 
unsigned  int PacketUser::select_maxIDN_DB(char* table_name)
{
	unsigned  int idN=0;
	TSQLResult* res=NULL;
	stringstream oss;
    oss.str("");
    oss<<"select max(ID_N) from "<<table_name;
    res= sqlServer->Query(oss.str().c_str());
		
	stringstream oss1;
	oss1.str()="";
	string msg1;
  	
  	if(!res)
  	{	
	   oss1<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;   
	 	msg1=oss1.str();
		mainLogUtil->logError(msg1);   
  		return 0;
	}
  	   
	TSQLRow* row=NULL;	
	row=res->Next();
    if (!row ) 
    {
	   oss1<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;   
	 	msg1=oss1.str();
		mainLogUtil->logError(msg1);   
   		return 0;
   	}

	idN=atoi(row->GetField(0));
	if(row){delete row; row = NULL;}
	if(res){delete res; res = NULL;}
	return idN;
}


//save in Table_ROOT_ASS 
bool PacketUser::saveROOT_ASS_DB(char* table_name,  
						unsigned int my_idn, 
						unsigned int idn_ass,
						int type_ass)
{
	stringstream oss;
	oss.str("");
	oss << "INSERT INTO "<< table_name <<" (ID_N, ROOT_ID_N, ID_N_ASS, TYPE_ASS, INSERT_TIME)"
    << " VALUES ('"<<0<< "','" <<my_idn<<"','" <<idn_ass<< "','" << type_ass  <<"',"<<"NULL"<<")";   
	
//	cout<<"DBG: "<<oss.str().c_str()<<endl;
	string msg = oss.str();
	mainLogUtil->logAll(msg);
	
   TSQLResult* res=NULL;		
   res= sqlServer->Query(oss.str().c_str());
	stringstream oss1;
	oss1.str()="";
	string msg1;

   if (!res)
   {
	   oss1<<"DBError UNABLE to: "<<oss.str().c_str()<<endl;   
 		msg1=oss1.str();
		mainLogUtil->logError(msg1);   
	   return false;
   }	   
   if(res){delete res; res = NULL;}
   return true;
}

/**********************************************************************************************/
//UNUSED: dbg functions...

//Return the system time in ms
unsigned long long PacketUser::Record_Time(){
	timeval tv;
	gettimeofday(&tv,NULL);
	unsigned long long timems =  (unsigned long long)tv.tv_sec * (unsigned long long)1000 + tv.tv_usec / 1000; 
	return timems;	
}

//dbg_functions
void PacketUser::saveALL_PKT(char* headerPkt, char* pamPkt, long int length, bool append)
{
	char fno[80]="";
	ofstream fout;
	if(append==true)
	{		
		sprintf(fno,"%s/packets.pkt", outDir);
		fout.open(fno, ios::binary | ios::app);
	}
	else{
		sprintf(fno,"%s/packet%d.pkt", outDir, numPKT );
		fout.open(fno, ios::binary);			
	}
		
	if (!fout) {cout<<"can not open output file "<<fno<<endl; return;}		    
	fout.write(headerPkt,LENGTH_HEADER_PKT);
	fout.write(pamPkt,length);
	fout.close(); 	 
}


}
