 /** @file
 * $Source: /repository/PamOffLineSW/techmodel/PhysicsReader.cpp,v $
 * $Id: PhysicsReader.cpp,v 1.9 2008-03-04 18:09:31 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>

extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;
using namespace pamela::tracker;
using namespace pamela::anticounter;
using namespace pamela::calorimeter;
using namespace pamela::neutron;
using namespace pamela::S4;
using namespace pamela::tof;
using namespace pamela::trigger;

/**
 * Constructor. 
 */
PhysicsReader::PhysicsReader(void): 
    TechmodelAlgorithm(PacketType::Physics, "TechmodelPhysicsReader") { 
    trackerReader     = new TrackerReader;
    anticounterReader = new AnticounterReader;
    calorimeterReader = new CalorimeterReader;
    neutronReader     = new NeutronDetectorReader;
    s4Reader          = new S4Reader;
    tofReader         = new TofReader;
    triggerReader     = new TriggerReader;
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PhysicsReader::Init(PamelaRun *run) 
{	   
	trackerReader->Init(run);
    anticounterReader->Init(run);
    calorimeterReader->Init(run);
    neutronReader->Init(run);
    s4Reader->Init(run);
    tofReader->Init(run);
    triggerReader->Init(run);   
    ////run->WriteSubPacket(this, &physicsEvent, physicsEvent->Class());
}

/**
 * Unpack the Physics event from an input file.
 */
void PhysicsReader::PKT_RunEvent(char* subData, long int dataLenght) throw (Exception)
{
	int EventNumber = 0;
    /*-----------------*/
    //passo packetData a tutti i reader dei vari rivelatori
    triggerReader->RunEvent(EventNumber, subData, dataLenght);    
    tofReader->RunEvent(EventNumber, subData, dataLenght);
    trackerReader->RunEvent(EventNumber, subData, dataLenght);
    anticounterReader->RunEvent(EventNumber, subData, dataLenght);
    calorimeterReader->RunEvent(EventNumber, subData, dataLenght);
    s4Reader->RunEvent(EventNumber, subData, dataLenght);
  //  if(...)
   // 	throw WrongCRCException_PKTUsed("asdsadas");
 
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PhysicsReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/PhysicsReader.cpp,v 1.9 2008-03-04 18:09:31 messineo Exp $\n";
}

