//============================================================================
// $Id: PacketUser.h,v 1.37 2008-03-21 16:06:57 messineo Exp $ 
// Description : 
//============================================================================
#ifndef PACKETUSER_H_
#define PACKETUSER_H_
#include "PamInclude.h"
#include <TTimeStamp.h>
#include "../event/PacketType.h"
#include "EventReader.h"

#include "TROOT.h" //ROOT version > 5.14

using namespace pamela;
using namespace pamela::techmodel;

namespace PamOffLineSW
{

class PacketUser
{

public:	
	//destructor
	virtual ~PacketUser();
	//the interface called by the external module: saves packets in ROOT files using the YODA part 
	void usePKT(char*& headerPkt, char*& pamPkt, long int length, bool isCons, bool isPKTGood, const PacketType* type,
			unsigned long int counter, unsigned long int obt);

	//return the instance of the singleton
	static PacketUser& getInstance();	
	//to be called at the end of the game
	void FinishLastGroup();

private:
	//the Event Reader handler
	pamela::techmodel::EventReader* reader;	
	//the Pamela Run handler,  one for ech ROOT file created
	pamela::PamelaRun* pRun;
	//Constructor
	PacketUser();
	//The istance
	static PacketUser instance;
	//How many times I found a discontinuity
	static int numDiscontinity;
	//How many packets arrived here,	
	static int numPKT; 
	//How many packetS saved in each ROOT files
	static int numPKTSaved;	
	//Name of the final ROOT file
	char rootfilename[80];	
	//pkt counter of the first packet of the group
	unsigned long int pkt_number_init;
	//pkt OBT of the first packet of the group
	unsigned long int obt_init;
	//pkt counter of the last packet of the group
	unsigned long int pkt_number_last;
	//pkt OBT of the last packet of the group
	unsigned long int obt_last;
	//the first packet's absolute time
	unsigned long int real_time_init;
	//the last packet's absolute time
	unsigned long int real_time_last;
	//tymesync and OBT informations	
	unsigned long int obt_time_sync;
	unsigned long int last_time_sync_info;
	//TimeOffset used to obtain absolute time 
	unsigned long int timeOffset;
	//part of the ROOT filename used to retrieve timeOffset for special files
	char nnnn_mmm_ppp[80];

	//number of packets with problems( in general CRC problems) detected in EventReader: 
	int bad_pkt_EventReader;
	//num  ber of Calibration packets with problems( in general CRC problems) detected in EventReader:
	int bad_pkt_CalibReader;
	//number of good packets that comes from one or more corrupted cadres
	int bad_pkt;
	
//number of good Calibration packets in the ROOT files 
//	int good_pkt_Calib;//maybe I will remove this in future

	//the table name in our DB for the ROOT files 
	char* Table_ROOT_Good;
	//the table name in our DB where I put the ROOT files that have not Real time associated
	char* Table_ROOT_Bad;
	//table used to retrieve TimeOffset
	char* Table_GL_RESURS_OFFSET;
	//the table name in our DB for the BAD PACKETS
	char* Table_PKT_Bad;
	
	//starts a new root file
	void StartGroup();	
	//set the value of the counter and obt of the first packet of the group
	void setInit(unsigned long int counter, unsigned long int obt);
	//finish the old ROOT file
	void FinishGroup(char * filename);
	//set the value of the counter and obt of the last packet of the group 
	void setLast(unsigned long int counter, unsigned long int obt);		
	//retrieve OBT_TIME_SYNC and LAST_TIME_SYNC_INFO from packet
	void setTimeSync(char* packet, const PacketType* type);
	//set real_time_init and real_time_last
	void setReal_Time();
	//retrieve the timeOffset
	unsigned long int retrieveTimeOffset();
	
	//function that saves informations about some packets in our DB	
	bool saveBADPKT_DB(char* table_name, 
				char* folder_name, 
				char* file_name, 
				unsigned long int pkt_number, 
				unsigned long int pkt_obt, 
				char* nome_input,
				int reason,
				int rootID);
		
	//function that saves informations in our DB	
	bool saveROOT_DB(char* table_name, char* folder_name, char* file_name, 
			unsigned long int pkt_number_init, unsigned long int pkt_number_final,
			unsigned long int obt_init, unsigned long int obt_final,
			unsigned long int  oT_sync, unsigned long int lT_sync_info,	   
			unsigned long int mtime_init, 	unsigned long int mtime_last, 
			unsigned long int time_offset, 
			int bad_pkt, int bad_pkt_read, int bad_pkt_CalRead, int num_PKT_Saved,
			char* nome_input);
	
	//function used to save in a file the packet
	void savePKT_file(char* headerPkt, 
			char* pamPkt, 
			long int length, 
			bool append,
			char* nomefile);
	
/***************************************************************************************/
	//TODO: wip ... merge two root files
	//tipi di relazioni che il ROOT file puo' avere con un ROOT gia salvatto in DB
		enum type_Rel_ROOT{
			AFTER=0,	//inizia dove finisce l'altro: viene subito dopo		
			AFTER2,     //se inizia dentro e finisce fuori
			BEFORE,     //finisco dove inizia l'altro	
			BEFORE2,    //inizia prima ma finisce dentro
			SMALLER,    //se inizia e finisce dentro 
			BIGGER      //se inizia prima e finisce dopo						
		};
	
	/*	
		0 =AFTER   se temporalmente viene subito dopo il ROOT file associato		
		1 =AFTER2  se c'e' una sovrapposizione temporale parziale, inizia dopo l'inizio di quello associato e finisce dopo la sua fine
		2 =BEFORE  se temporalmente viene subito prima del ROOT file associato	
		3 =BEFORE2 se c'e' una sovrapposizione temporale parziale, ossia finisce prima della fine di quello associato ma inizia prima
		4 =SMALLER se c'e' una sovrapposizione temporale parziale: e' contenuto nel ROOT file associato
		5 =BIGGER  se c'e' una sovrapposizione temporale parziale: contiene il ROOT file associato	
	*/		
	bool merge_ROOTfiles();	
	unsigned int* Return_IDN_ASS(unsigned long int mtime_init, unsigned long int mtime_last, type_Rel_ROOT type_rel, unsigned int my_id, unsigned int &num_ass);
	unsigned  int select_maxIDN_DB(char* table_name);
	bool saveROOT_ASS_DB(char* table_name,  
			unsigned int my_idn, 
			unsigned int idn_ass,
			int type_ass);
	/**************************************************************************/	

	//UNUSED: return the system time in ms
	unsigned long long Record_Time();
	//DBG functions that saves pkt
	void saveALL_PKT(char* headerPkt, char* pamPkt, long int length, bool append);

};

}

#endif /*PACKETUSER_H_*/
