/** @file
 * $Author: messineo $
 * $Date: 2008-03-05 17:00:16 $
 * $Revision: 1.12 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */


#ifndef TECHMODEL_ALGORITHM_H
#define TECHMODEL_ALGORITHM_H

#include <iostream>
#include <fstream>

#include "event/Algorithm.h"
#include "event/Exception.h"

//my logger
#include "../Logger.h"

namespace PamOffLineSW
{ 
	//logger
	extern LogUtil* mainLogUtil;
}

namespace pamela {
  namespace techmodel {

    /**
     * Base algorithm for all techmodel reader.
     */
    class TechmodelAlgorithm: public Algorithm {
    protected:
      TechmodelAlgorithm(const PacketType*, std::string);
    public:
    virtual void Init(PamelaRun*);    
     virtual void PKT_RunEvent(char*, long int = 0) throw (Exception){}
     ClassDef(TechmodelAlgorithm, 1)
    };
  }
}

#endif /* TECHMODEL_ALGORITHM_H */


