/** @file
 * $Source: /repository/PamOffLineSW/techmodel/PscuReader.cpp,v $
 * $Id: PscuReader.cpp,v 1.4 2008-03-04 18:09:30 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the OrbitalReader class.
 */

#include <string>
//#include <log4cxx/logger.h>

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;


/**
 * Constructor. 
 */
PscuReader::PscuReader(void): 
  TechmodelAlgorithm(PacketType::Pscu, "TechmodelPscuReader") { 
  Pscu = new PscuEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PscuReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/PscuReader.cpp,v 1.4 2008-03-04 18:09:30 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PscuReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &Pscu, Pscu->Class());
}

/**
 * Unpack the orbital event 
 */
void PscuReader::PKT_RunEvent(char* subData, long int length) throw (WrongCRCException){ 
  // First step: unpack the event into the event class.
}

