
// Implementation of the CalibCalPulse2Reader class.


extern "C" {
#include "CRC.h"  
    //Struct per il passaggio di dati da e verso la chiamata fortran
extern struct {
        int   iev;
        int   pstwerr[4];
        float pperror[4];
        float calpuls[4][11][96];
    } calpul_; 
    
    //external declaration of the Fortran function 
    void calpulse_(char*, long int*, int*);
}
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
CalibCalPulse2Reader::CalibCalPulse2Reader(void): 
  TechmodelAlgorithm(PacketType::CalibCalPulse2, "TechmodelCalibCalPulse2Reader") { 
  calibCalPulse2 = new CalibCalPulse2Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibCalPulse2Reader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/CalibCalPulse2Reader.cpp,v 1.5 2008-03-04 18:09:31 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibCalPulse2Reader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calibCalPulse2, calibCalPulse2->Class());
}

/**
 * Unpack the CalibCalPulse2 event
 */
void CalibCalPulse2Reader::PKT_RunEvent(char* packetData, long int dataLength) throw (Exception){
	string msg;    

	std::stringstream oss;       
    int         ERROR;
    calpulse_(packetData, &dataLength, &ERROR);

    calibCalPulse2->unpackError = ERROR;

    if (ERROR != 0) {
        char *errmsg;
        switch (ERROR){
            case 1: errmsg = "CALORIMETER NOT FOUND";
        }
        oss.str("");
        oss << "CalibCalPulse2: Fortran77 function calpulse error code = " << ERROR
            <<  " " << errmsg;
        msg=oss.str();
        PamOffLineSW::mainLogUtil->logWarning(msg);	
    } //else {
       //Store the unpacked data
        calibCalPulse2->iev = calpul_.iev;
        memcpy(calibCalPulse2->pstwerr, calpul_.pstwerr, sizeof(calibCalPulse2->pstwerr));
        memcpy(calibCalPulse2->pperror, calpul_.pperror, sizeof(calibCalPulse2->pperror));
    //--------have to invert array because of FORTRAN <-> C different management of the indexes
        float tempCalpuls[96][11][4];
        memcpy(tempCalpuls, calpul_.calpuls, sizeof(tempCalpuls));
        for (int i = 0; i < 4; i++){
            for (int j = 0; j <11; j++){
                for (int z = 0; z < 96; z++){
                    calibCalPulse2->calpuls[i][j][z]  = tempCalpuls[z][j][i];
                }
            }
        }
   //-----------------------------------------------------------------------------------------
    //}
}
