//============================================================================
// $Id: PacketSemanticAnalyzer.h,v 1.13 2008-02-18 14:38:54 messineo Exp $ 
// Description : 
//============================================================================
#ifndef PACKETSEMANTICANALYZER_H_
#define PACKETSEMANTICANALYZER_H_
#include "PacketUser.h"

namespace PamOffLineSW
{

class PacketSemanticAnalyzer
{
public:	
	virtual ~PacketSemanticAnalyzer();
	void managePKT(char*& headerPkt, char* &pamPkt, long int length, bool isPKTGood);
	static PacketSemanticAnalyzer& getInstance();
private:
	PacketSemanticAnalyzer();
	PacketSemanticAnalyzer(PacketSemanticAnalyzer& pkta);
	void setStepValue(unsigned long int delta_pkt_num, unsigned long int delta_pkt_obt);
	void setLastValue();
	void setCurrentValues(unsigned long int ex_pkt_number, unsigned long int ex_pkt_obt);
	void extractValuesfromPKT(char * pkt);
	bool analysePKT();
	
	const PacketType* pktType;//the packet type
	const PacketType* GetPacketType(unsigned char pktType);

	unsigned char pkt_type;//the packet type
	
	unsigned long int pkt_number;//Packet Number of the current PAMELA packet
	unsigned long int pkt_obt;//OBT of the current PAMELA packet
	
	unsigned long  int last_pkt_number;//Packet Number of the previous PAMELA packet
	unsigned long  int last_pkt_obt;//OBT of the previous PAMELA packet
	
	static PacketSemanticAnalyzer instance;
};

}

#endif /*PACKETSEMANTICANALYZER_H_*/
