 /** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/techmodel/PhysicsReader.cpp,v $
 * $Id: PhysicsReader.cpp,v 1.4 2009/12/24 11:20:54 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>

extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;
using namespace pamela::tracker;
using namespace pamela::anticounter;
using namespace pamela::calorimeter;
using namespace pamela::neutron;
using namespace pamela::S4;
using namespace pamela::tof;
using namespace pamela::trigger;

/**
 * Constructor. 
 */
PhysicsReader::PhysicsReader(void): 
    TechmodelAlgorithm(PacketType::Physics, "TechmodelPhysicsReader") { 
    trackerReader     = new TrackerReader;
    anticounterReader = new AnticounterReader;
    calorimeterReader = new CalorimeterReader;
    neutronReader     = new NeutronDetectorReader;
    s4Reader          = new S4Reader;
    tofReader         = new TofReader;
    triggerReader     = new TriggerReader;
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void PhysicsReader::Init(PamelaRun *run) 
{	   
  //	printf(" physics reader in \n");
	trackerReader->Init(run);
    anticounterReader->Init(run);
    calorimeterReader->Init(run);
    neutronReader->Init(run);
    s4Reader->Init(run);
    tofReader->Init(run);
    triggerReader->Init(run);   
    //	printf(" physics reader out \n");
    ////run->WriteSubPacket(this, &physicsEvent, physicsEvent->Class());
}

/**
 * Unpack the Physics event from an input file.
 */
void PhysicsReader::PKT_RunEvent(char* subData, long int dataLenght) throw (Exception)
{
	int EventNumber = 0;
    /*-----------------*/
    //passo packetData a tutti i reader dei vari rivelatori
	//	cout << " 1" << endl;
    triggerReader->RunEvent(EventNumber, subData, dataLenght);    
    //	cout << " 2" << endl;
    tofReader->RunEvent(EventNumber, subData, dataLenght);
    //	cout << " 3" << endl;
    trackerReader->RunEvent(EventNumber, subData, dataLenght);
    //	cout << " 4" << endl;
    anticounterReader->RunEvent(EventNumber, subData, dataLenght);
    //	cout << " 5" << endl;
    calorimeterReader->RunEvent(EventNumber, subData, dataLenght);
    //	cout << " 6" << endl;
    neutronReader->RunEvent(EventNumber, subData, dataLenght); // Emiliano!
    //	cout << " 7" << endl;
    s4Reader->RunEvent(EventNumber, subData, dataLenght);
    //	cout << " 8" << endl;
  //  if(...)
   // 	throw WrongCRCException_PKTUsed("asdsadas");
 
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string PhysicsReader::GetVersionInfo(void) const {
  return 
    "$Header: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/techmodel/PhysicsReader.cpp,v 1.4 2009/12/24 11:20:54 mocchiut Exp $\n";
}

