/** @file
 * $Author: mocchiut $
 * $Date: 2008/09/23 07:20:25 $
 * $Revision: 1.1.1.1 $
 * 
 * Header file for the algorithms used to read the techmodel data file.
 */


#ifndef TECHMODEL_ALGORITHM_H
#define TECHMODEL_ALGORITHM_H

#include <iostream>
#include <fstream>

#include "event/Algorithm.h"
#include "event/Exception.h"
#include <TString.h>
//my logger
#include "../Logger.h"

namespace PamOffLineSW
{ 
	//logger
	extern LogUtil* mainLogUtil;
}

namespace pamela {
  namespace techmodel {

    /**
     * Base algorithm for all techmodel reader.
     */
    class TechmodelAlgorithm: public Algorithm {
    protected:
      TechmodelAlgorithm(const PacketType*, std::string);
    public:
      virtual void Init(PamelaRun*);    
      virtual void PKT_RunEvent(char*, long int = 0) throw (Exception){}
      virtual TObject *GetPtr(TString=""){return this;};
      ClassDef(TechmodelAlgorithm, 2)
    };
  }
}

#endif /* TECHMODEL_ALGORITHM_H */


