/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/techmodel/Calib1_Ac1Reader.cpp,v $
 * $Id: Calib1_Ac1Reader.cpp,v 1.2 2009-08-04 13:58:10 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Implementation of the Calib1_Ac1Reader class.
 */

#include <string>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
    #include "forroutines/anticounter/AC.h"
    extern int ACcalib(int length, unsigned char* datapointer, struct calibstruct* calibpointer);
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;


/**
 * Constructor. 
 */
Calib1_Ac1Reader::Calib1_Ac1Reader(void): 
  TechmodelAlgorithm(PacketType::Calib1_Ac1, "Calib1_Ac1") { 
  calib1_Ac1 = new Calib1_Ac1Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Calib1_Ac1Reader::GetVersionInfo(void) const {
  return "$Header: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/PamOffLineSW/techmodel/Calib1_Ac1Reader.cpp,v 1.2 2009-08-04 13:58:10 mocchiut Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Calib1_Ac1Reader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calib1_Ac1, calib1_Ac1->Class());
}

/**
 * Unpack the Calib1_Ac1Reader event from an input file.
 */
void Calib1_Ac1Reader::PKT_RunEvent(char* subData, long int dataLength) throw (Exception){	
  struct calibstruct output;// = {0};
    calib1_Ac1->ERROR = ACcalib(dataLength, (unsigned char*)subData, &output);
    memcpy(calib1_Ac1->header,     output.header,     sizeof(output.header));
    memcpy(calib1_Ac1->status,     output.status,     sizeof(output.status));
    memcpy(calib1_Ac1->temp,       output.temp,       sizeof(output.temp));
    memcpy(calib1_Ac1->DAC1,       output.DAC1,       sizeof(output.DAC1));
    memcpy(calib1_Ac1->DAC2,       output.DAC2,       sizeof(output.DAC2));
    memcpy(calib1_Ac1->regist,     output.regist,     sizeof(output.regist));
    memcpy(calib1_Ac1->time,       output.time,       sizeof(output.time));
    calib1_Ac1->n_tr = output.n_tr;
    memcpy(calib1_Ac1->hitmap_tr,  output.hitmap_tr,  sizeof(output.hitmap_tr));
    memcpy(calib1_Ac1->curve1,     output.curve1,     sizeof(output.curve1));
    memcpy(calib1_Ac1->curve2,     output.curve2,     sizeof(output.curve2));
    calib1_Ac1->iCRC        = output.iCRC;
    calib1_Ac1->tail        = output.tail;
    calib1_Ac1->CRC         = output.CRC;
    calib1_Ac1->CRCcheck    = output.CRCcheck;

}
