/** @file
 * $Source: /repository/event/SubDetector.h,v $
 * $Id: SubDetector.h,v 1.1 2008-01-11 17:14:20 messineo Exp $
 * $Author: messineo $
 * 
 * Header file for the SubDetector class.
 */
#ifndef SUBDETECTOR_H
#define SUBDETECTOR_H

#include <string>

namespace pamela {
  /**
   * This class is just to mark something as specific to a certain 
   * subdetector. The instances of this class are constant and initialized
   * as static members.
   */
  class SubDetector {
  private: 
    /**
     * The name of the subdetector.
     */
    std::string Name;
  protected:
    /*
     * Create a new "SubDetector". Intended to be used only internally.
     */
    SubDetector(std::string name): Name(name) { }
  public:
    /**
     * Get the name of the subdetector.
     */
    std::string GetName(void) const { return Name; }
    static const SubDetector* Tracker;      /**< Tracker */
    static const SubDetector* Calorimeter;  /**< Calorimeter */
    static const SubDetector* Anticounter;  /**< Anticounter unit */
    static const SubDetector* Trigger;      /**< Trigger */
    static const SubDetector* Neutron;      /**< Neutron */
    static const SubDetector* S4;           /**< S4 */
    static const SubDetector* Tof;          /**< TOF */
  };
}

#endif /* SUBDETECTOR_H */
