
// Implementation of the S4InitReader class.

#include "ReaderAlgorithms.h"
using namespace pamela::techmodel;


/**
 * Constructor. 
 */
S4InitReader::S4InitReader(void): 
  TechmodelAlgorithm(PacketType::S4Init, "S4InitReader") { 
  s4Init = new S4InitEvent;
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string S4InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/S4InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void S4InitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &s4Init, s4Init->Class());
}

/**
 * Unpack the S4Init event 
 */
void S4InitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){  
    s4Init->s4InitData        = new TArrayC(dataLength, subData);
}
