// Implementation of the CalibCalReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */

CalibCalReader::CalibCalReader(void): 
  TechmodelAlgorithm(PacketType::CalibCal, "TechmodelCalibCalReader") { 
  calibCal = new CalibCalEvent();  
}


/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibCalReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibCalReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibCalReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calibCal, calibCal->Class());
	//PamOffLineSW::mainLogUtil->logAll("Init CalibCal Done");			   	

}

/**
 * Unpack the calibCal event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */

void CalibCalReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){ 
    calibCal->calibCalData        = new TArrayC(dataLength, subData);
	PamOffLineSW::mainLogUtil->logAll("PKT_RunEvent: Used CalibCal packet.");			   	

}
