/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.4 $
 * 
 * Implementation of the Ac1InitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 * @param  
 * @return 
 */
Ac1InitReader::Ac1InitReader(void): 
  TechmodelAlgorithm(PacketType::Ac1Init, "Ac1InitReader") { 
  ac1Init = new Ac1InitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 * @param
 * @return
 */
std::string Ac1InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/Ac1InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}


/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 * @param run 
 */
void Ac1InitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &ac1Init, ac1Init->Class());
}

/**
 * Unpack the Ac1Init event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void Ac1InitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){   
    ac1Init->ac1InitData  = new TArrayC(dataLength, subData);
}
