/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.4 $
 * 
 * Implementation of the TrgInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
TrgInitReader::TrgInitReader(void): 
  TechmodelAlgorithm(PacketType::TrgInit, "TechmodelTrgInitReader") { 
  trgInit = new TrgInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrgInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrgInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrgInitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &trgInit, trgInit->Class());
}

/**
 * Unpack the TrgInit event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TrgInitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){ 
    trgInit->trgInitData        = new TArrayC(dataLength, subData);
}
