// Implementation of the CalibTrkBothReader class.
 
#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
CalibTrkBothReader::CalibTrkBothReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrkBoth, "TechmodelCalibTrkBothReader") { 
  calibTrkBoth = new CalibTrkBothEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrkBothReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalibTrkBothReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrkBothReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calibTrkBoth, calibTrkBoth->Class());
}

/**
 * Unpack the CalibTrkBoth event 
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalibTrkBothReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
	calibTrkBoth->calibTrkBothData        = new TArrayC(dataLength, subData);
}
