
#include <string>
#include "NeutronDetectorReader.h"

using namespace pamela;
using namespace pamela::neutron;


/**
 * Constructor. 
 */
NeutronDetectorReader::NeutronDetectorReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelNeutronDetectorReader") { 
  neutronEvent = new NeutronEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string NeutronDetectorReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/physics/NeutronDetectorReader.cpp,v 1.3 2008-03-05 11:37:37 messineo Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 * For definition the definition for Neutron detector data is located in the 
 * end of the physics packet.
 * More explicitely the neutronData is composed by 4 bytes;
 * a pattern 00 0F TR BK
 * where:
 * 00 0f is a fixed pattern
 * TR is the NeutronCounter for a trigger event
 * BK is the NeutronCounter beetween two trigger events
 */
void NeutronDetectorReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &neutronEvent, neutronEvent->Class());
}

/**
 * Unpack the anticounter event from an input file.
 */
void NeutronDetectorReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the NeutronDetector data event from the physical packet.
 */
void NeutronDetectorReader::RunEvent(int EventNumber, const char subData[], long int length) {
   NeutronRecord *rec;
   const int lenNeutronData = 12;
   //char *data = new char[lenght];
   //memcpy(data, subData, lenght);
   neutronEvent->Records->Clear();
   TClonesArray &recs = *(neutronEvent->Records);
   int offset;
   if (haveData(&*subData, length)){
        for (int i = 0; i < 3; i++){
            offset = lenNeutronData - 4*i;
            rec = new(recs[i]) NeutronRecord(); //aggiungo un nuovo NeutronRecord all'evento
            rec->trigPhysics = (UINT8)subData[length-offset];
            rec->upperBack   = (((UINT8)subData[length-offset+1])>>4);
            rec->bottomBack  = (((UINT8)subData[length-offset+1])&0x0F);
        }
        neutronEvent->unpackError = 0;
    } else {
        neutronEvent->unpackError = 1;
        //marco: scrivo in log file ...
        std::stringstream oss;  
        string msg;
        oss << "NeutronDetector: " << "no data found ";
        msg=oss.str();
        PamOffLineSW::mainLogUtil->logAll(msg);	   
    }
}


bool NeutronDetectorReader::haveData(const char data[], long int length){
    bool ret = false;
    if (((UINT8)data[length - 1] == 0x0F)&&((UINT8)data[length - 5] == 0x0F)&&((UINT8)data[length - 9] == 0x0F)) ret = true;
    return ret;
}
