/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:31 $
 * $Revision: 1.4 $
 * 
 * Implementation of the TrgAlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
TrgAlarmReader::TrgAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TrgAlarm, "TechmodelTrgAlarmReader") { 
  trgAlarm = new TrgAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrgAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrgAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrgAlarmReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &trgAlarm, trgAlarm->Class());
}

/**
 * Unpack the TrgAlarm event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TrgAlarmReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){  
    trgAlarm->trgAlarmData        = new TArrayC(dataLength, subData);
}
