/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.4 $
 * 
 * Implementation of the Ac2AlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
Ac2AlarmReader::Ac2AlarmReader(void): 
  TechmodelAlgorithm(PacketType::Ac2Alarm, "TechmodelAc2AlarmReader") { 
  acAlarm = new Ac2AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac2AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ac2AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac2AlarmReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &acAlarm, acAlarm->Class());
}

/**
 * Unpack the Ac2Alarm event
 */
void Ac2AlarmReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){ 
acAlarm->ac2AlarmData        = new TArrayC(dataLength, subData);
}
