#!/bin/bash --norc 
THISDIR=`pwd` ;
INDIR=`pwd` ;
OUTDIR=`pwd` ;
FNAME=extcalibs ;
#
if [ $# -gt 0 ]; then
    for INPUT in $*; do 
	if [ $INPUT == "--help" ] || [ $INPUT == "-h" ]; then
	    echo ""
	    echo " Usage: ./extractcalibs.sh [options] "
	    echo ""
	    echo " Options: "
	    echo ""
	    echo " --input-dir=/path/to/level0/files/ : Path to level0 files "
	    echo ""
	    echo " --output-dir=/path/to/output/tar/file/ : Path were to put the output file with calibrations and temporary folder."
	    echo ""
	    echo " --filename=name: Name of the output file (no extension) "
	    echo ""
	    exit 0
	fi
	TEST=`echo $INPUT | sed 's/--input-dir=//g'`
	if [ $TEST != $INPUT  ]; then
	    INDIR=`echo $TEST`;
	fi
	TEST=`echo $INPUT | sed 's/--output-dir=//g'`
	if [ $TEST != $INPUT  ]; then
	    OUTDIR=`echo $TEST`;
	fi
	TEST=`echo $INPUT | sed 's/--filename=//g'`
	if [ $TEST != $INPUT  ]; then
	    FNAME=`echo $TEST`;
	fi
    done
fi;
echo ""
echo " Extracting calibrations from files in the directory $INDIR "
echo ""
#
if [ -d ${OUTDIR}/${FNAME} ]; then
    echo "";
    echo " Directory ${OUTDIR}/${FNAME} already exists, DELETING IT in 30 seconds (use CTRL-C to stop me NOW) ";
    echo "";
    sleep 30;
    rm -rf ${OUTDIR}/${FNAME} ;
fi;
rm -rf ${OUTDIR}/${FNAME}.log ;
touch ${OUTDIR}/${FNAME}.log ;
LOG=${OUTDIR}/${FNAME}.log ;
mkdir ${OUTDIR}/${FNAME} ;
#
rm -rf ${OUTDIR}/extcal.template;
TEMPL=${OUTDIR}/extcal.template;
touch ${TEMPL};
echo "TFile *_file0 = TFile::Open(\"${INDIR}/nome\");" >> ${TEMPL};
echo "TTree *cp = (TTree*)_file0->Get(\"CalibCalPed\")" >> ${TEMPL};
echo "TTree *cp1 = (TTree*)_file0->Get(\"CalibCalPulse1\")" >> ${TEMPL};
echo "TTree *cp2 = (TTree*)_file0->Get(\"CalibCalPulse2\")" >> ${TEMPL};
echo "TTree *tcb = (TTree*)_file0->Get(\"CalibTrkBoth\")" >> ${TEMPL};
echo "TTree *tc1 = (TTree*)_file0->Get(\"CalibTrk1\")" >> ${TEMPL};
echo "TTree *tc2 = (TTree*)_file0->Get(\"CalibTrk2\")" >> ${TEMPL};
echo "TTree *s4c = (TTree*)_file0->Get(\"CalibS4\")" >> ${TEMPL};
echo "TTree *mcmd = (TTree*)_file0->Get(\"Mcmd\")" >> ${TEMPL};
echo "TTree *ccp = 0;" >> ${TEMPL};
echo "TTree *ccp1 = 0;" >> ${TEMPL};
echo "TTree *ccp2 = 0;" >> ${TEMPL};
echo "TTree *ctcb = 0;" >> ${TEMPL};
echo "TTree *ctc1 = 0;" >> ${TEMPL};
echo "TTree *ctc2 = 0;" >> ${TEMPL};
echo "TTree *cs4c = 0;" >> ${TEMPL};
echo "TTree *cmcmd = 0;" >> ${TEMPL};
echo "TFile *calib = new TFile(\"${OUTDIR}/${FNAME}/nome\",\"RECREATE\");" >> ${TEMPL};
echo "calib->SetCompressionLevel(9);" >> ${TEMPL};
echo "calib->cd();" >> ${TEMPL};
echo "ccp=cp->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "ccp1=cp1->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "ccp2=cp2->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "ctcb=tcb->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "ctc1=tc1->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "ctc2=tc2->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "cs4c=s4c->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "cmcmd=mcmd->CloneTree(-1,\"fast\");" >> ${TEMPL};
echo "calib->Write();" >> ${TEMPL};
echo "calib->Close();" >> ${TEMPL};
echo ".q" >> ${TEMPL};
#
rm -rf ${OUTDIR}/go.exe ;
GO=${OUTDIR}/go.exe ;
#
for file in `ls ${INDIR}`; do 
    FN=`basename $file`; 
    echo ${FN} >> ${LOG}; 
    CH=`echo $FN |grep .root`; 
    if [ "$CH" != "" ]; then 
	echo " Processing file $FN";
	cat ${TEMPL} | sed s/nome/${FN}/ > ${GO}; 
	root -n -b -l < ${GO} &> ${LOG}; 
    fi; 
done
rm -f ${LOG};
rm -f ${GO};
rm -f ${TEMPL};
cd ${OUTDIR} && tar zcvf ${OUTDIR}/${FNAME}.tar.gz ${FNAME} ;
rm -rf ${OUTDIR}/${FNAME} ;
cd ${THISDIR} ;
