/** @file
 * $Source: /repository/event/RunInfoYoda.cpp,v $
 * $Id: RunInfoYoda.cpp,v 1.1 2008-03-11 14:26:18 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the default functions of the Algorithm class.
 */
extern "C" {
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
}
#include "RunInfoYoda.h"
#include "PamelaRun.h"
using namespace pamela;

RunInfoYoda::RunInfoYoda(PamelaRun* run):  UserName(getpwuid(geteuid())->pw_name), 
				   DataPath( run->GetUnpackPath()), 
				   RunNumber(run->GetRunNumber()) {
  char* hostname = new char[1000];
  gethostname(hostname, 1000);
  HostName = TString(hostname);

  time_t t = time(NULL);
  Time = TString(asctime(gmtime(&t)));
  //marco: to avoid memory leaks
  delete[] hostname;
}

RunInfoYoda::RunInfoYoda(void) { }
RunInfoYoda::~RunInfoYoda(void) { }

ClassImp(RunInfoYoda)
