/** @file
 * $Author: mocchiut $
 * $Date: 2008/09/23 07:19:54 $
 * $Version: 1.1 $
 * 
 * Header file for the SubPacket class.
 */

////#include <log4cxx/logger.h>

#include "SubPacket.h"

////static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.EventCounter"));

using namespace pamela;

/**
 * Constructor for the SubPacket.
 * @param name Name of the SubPacket.
 * @param type Packet type.
 * @param detector SubDetector, if the SubPacket is detector specific.
 */
SubPacket::SubPacket(std::string name, const PacketType* type, 
		     const SubDetector* detector): 
  Type(type), Detector(detector), SubPacketName(name) {
}

/**
 * Default constructor. Note that this should never be used; it is here 
 * just for some thumb requirements of ROOT.
 */
SubPacket::SubPacket(void):  Type(0), Detector(0), SubPacketName("ERROR") {
}

ClassImp(SubPacket)
