/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/event/EventHeader.cpp,v $
 * $Id: EventHeader.cpp,v 1.1.1.1 2008/09/23 07:19:52 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Implementation of the EventHeader class.
 */
#include "EventHeader.h"

using namespace pamela;

/** 
 * Create a new event header object which belongs to all packet types
 * @param run Run number
 */ 
EventHeader::EventHeader(int run): 
  SubPacket("Header"), Counter(run) {

}

/** 
 * Create a new event header object.
 * @param type Packet type the header event belongs to.
 */ 
EventHeader::EventHeader(const PacketType* t): 
  SubPacket("Header", t), Counter(0) {
}



/**
 * Destroy the event header object.
 */
// EventHeader::~EventHeader() { }

ClassImp(EventHeader)
