DROP DATABASE IF EXISTS dbname;

CREATE DATABASE dbname;

USE dbname;

SET time_zone='+0:00';

CREATE TABLE `_RUNID_GEN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  PRIMARY KEY  (`ID`)
);

CREATE TABLE `GL_RAW` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `BOOT_NUMBER` smallint(5) unsigned default NULL,
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PATH_index` (`PATH`)
) ;

INSERT INTO GL_RAW VALUES(0,'$PAM_L2','level2 files',NULL,NULL);

CREATE TABLE `GL_ROOT` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `PATH_index` (`PATH`)
) ;

CREATE TABLE `GL_RESURS_OFFSET` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `FROM_ORBIT` int(10) unsigned NOT NULL default '0' COMMENT 'if dwlimit = dworbit the file takes the OLD resurs 0 -- SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE),ID FROM GL_RESURS_OFFSET WHERE FROM_ORBIT< "  << dworbit << " AND SPECIAL_FILE="" order by FROM_ORBIT desc limit 1;',
  `SPECIAL_FILE` varchar(255) NOT NULL default '',
  `OFFSET_DATE` timestamp default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ;

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','','2006-06-14 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'1619','','2006-09-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'2797','','2006-12-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'3221','','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'4576','','2007-04-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'5960','','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','07408_003_001_cln1.pam','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'7382','','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'8580','','2007-12-25 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_002_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_003_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'9908','','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_001_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_001_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_002_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'11300','','2008-06-19 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'12634','','2008-09-18 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14033_201_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14034_001_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'14044','','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_003_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15445_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'15430','','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_001_cln1.pam','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'16740','','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_122_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_123_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_132_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_133_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_152_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_153_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'18150','','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_001_cln1.pam','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_001_cln1.pam','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'19525','','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_072_001_cln1.pam','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_073_001_cln1.pam','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_074_001_cln1.pam','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_075_001_cln1.pam','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_075_002_cln1.pam','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'20820','','2010-03-03 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'22400','','2010-05-30 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'23600','','2010-08-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'24760','','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_002_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_003_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_074_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_075_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26100_002_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26104_074_001_cln1.pam','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'26080','','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'27410','','2011-05-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27409_071_001_cln1.pam','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_004_001_cln1.pam','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_005_001_cln1.pam','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_006_001_cln1.pam','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'28990','','2011-08-24 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30328_001_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_001_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_002_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_003_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_004_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_005_001_cln1.pam','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'30330','','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','31654_001_001_cln1.pam','2012-02-19 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'31660','','2012-02-19 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'32950','','2012-05-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'34330','','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'35600','','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_008_001_cln1.pam','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_007_001_cln1.pam','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_006_001_cln1.pam','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_005_001_cln1.pam','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'36920','','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_005_001_cln1.pam','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_006_001_cln1.pam','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_077_001_cln1.pam','2012-11-07 21:00:00',NULL);
-- WARNING! STARTING FROM HERE RAWREADER SPECIAL FILES DISCONTINUED (NOT UPDATED ANYMORE)
-- 10 RED BUG
INSERT INTO GL_RESURS_OFFSET VALUES(0,'38265','','2013-05-05 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'39594','','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'40931','','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'42260','','2014-01-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'43610','','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'44980','','2014-07-26 21:00:00',NULL);
--
-- 10RED END

-- CHEWBACCA SPECIAL FILES
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_001','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_001','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_001','2007-01-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001','2007-01-08 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_002_001','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_002','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_001','2007-10-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_002','2007-10-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_003','2007-10-08 21:00:00',NULL); 

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_002','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_003','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_001','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_002','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_001','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_002','2008-03-20 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14033_201_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14034_001_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14044_001_001','2008-12-15 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_003_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_002_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15445_002_001','2008-12-15 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_001','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_002','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_003','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_004','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_005','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_006','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_007','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_008','2009-03-16 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_032_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_032_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_033_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_033_002','2009-06-10 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_001','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_002','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_001','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_002','2009-09-09 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_072_001','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_072_002','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_073_001','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_073_002','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_074_002','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','20829_075_001','2009-12-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_003','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_004','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_005','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_006','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_007','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_008','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_009','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_010','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_011','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_012','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_025_013','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_003','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_004','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_005','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_006','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26099_026_007','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26100_002_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26100_002_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26104_074_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26104_074_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_075_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_075_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_074_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_074_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_003_001','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','26089_002_002','2010-11-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_006_001','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_005_002','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27436_004_001','2011-02-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','27409_071_001','2011-05-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30328_001_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30328_001_002','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_001_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_001_002','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_002_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_002_002','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_003_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_003_002','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_004_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_004_002','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','30329_005_001','2011-11-22 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','31654_001_001','2012-02-19 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_008_001','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_008_002','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_007_001','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_007_002','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_006_001','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_006_002','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_005_001','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','35612_005_002','2012-08-13 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_005_001','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_005_002','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_006_001','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_006_002','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_077_001','2012-11-07 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','36935_077_002','2012-11-07 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38270_003_001','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38270_003_002','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38271_004_001','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38271_004_002','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38271_005_001','2013-02-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','38271_005_002','2013-02-05 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_072_002','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_072_003','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_072_004','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_072_005','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_073_001','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_073_002','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_074_001','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39611_074_002','2013-05-05 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39592_051_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39592_051_002','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_002','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_003','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_004','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_005','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_006','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_007','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_008','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_009','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_010','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_011','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_071_012','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_006','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_007','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_008','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_009','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','39593_072_010','2013-08-01 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40932_077_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40932_077_002','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40947_078_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40947_078_002','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40962_077_001','2013-08-01 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40917_071_001','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40930_071_001','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','40930_071_002','2013-10-29 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42268_002_001','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42268_002_002','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42281_076_002','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42281_076_003','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42283_071_002','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42283_071_003','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42283_072_001','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42283_072_002','2013-10-29 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','42295_005_001','2013-10-29 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','43623_003_001','2014-01-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','43623_003_002','2014-01-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','43623_072_002','2014-01-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','43623_072_003','2014-01-27 21:00:00',NULL);
--
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44983_003_001','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44983_003_002','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44983_072_001','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44983_072_002','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44984_078_001','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44984_078_002','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44999_007_001','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44999_007_002','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44999_076_001','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44999_076_002','2014-04-27 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44974_001_001','2014-07-26 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','44974_001_002','2014-07-26 21:00:00',NULL);
--
-- 10RED END


CREATE TABLE `GL_TIMESYNC` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_RESURS_OFFSET` int(10) unsigned NOT NULL default '0',
  `OBT0` int(10) unsigned NOT NULL default '0',
  `TIMESYNC` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `TYPE_index` (`TYPE`)
) ;

CREATE TABLE `GL_PARAM` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  `DESCR` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `PATH_index` (`PATH`),
  KEY `NAME_index` (`NAME`),
  KEY `TYPE_index` (`TYPE`),
  KEY `DESCR_index` (`DESCR`)
) ;

insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","field_param-0/",0,0,1,"field",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mip_param-0/",0,0,2,"trk mip",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","charge_param-1/",0,0,3,"trk charge",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","eta_param-2/",0,0,4,"trk pfa",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","align_param-080805-GL1from7/",0,0,5,"trk alignment",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0/",1,         1150876185,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0/",1150876185,1152619600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1/",1152619600,1153273957,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID2/",1153273957,1153307807,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3/",1153307807,1153439464,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4/",1153439464,1153447067,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3/",1153447067,1154385336,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID5/",1154385336,1154390143,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID6/",1154390143,1154746486,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID7/",1154746486,1155728075,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID8/",1155728075,1155987238,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID9/",1155987238,1156179269,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10/",1156179269,1156184911,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID11/",1156184911,1156438857,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12/",1156438857,1156591164,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13/",1156591164,1156833624,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID14/",1156833624,1156839268,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13/",1156839268,1157165000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID15/",1157165000,1158610519,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16/",1158610519,1158659245,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID17/",1158659245,1158661285,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID18/",1158661285,1158666824,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16/",1158666824,1159135000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID19/",1159135000,1160246000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1160246000,1160454893,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21/",1160454893,1160578979,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22/",1160578979,1161554748,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1161554748,1161605509,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID23/",1161605509,1161639348,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1161639348,1161955293,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1161955293,1161994774,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25/",1161994774,1162000413,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1162000413,1162022874,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID26/",1162022874,1162232000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID27/",1162232000,1162338713,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID28/",1162338713,1162434592,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29/",1162434592,1162550280,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID30/",1162550280,1162682748,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29/",1162682748,1162987298,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31/",1162987298,1163184789,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1163184789,1163280464,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31/",1163280464,1163387718,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID32/",1163387718,1163568187,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID33/",1163568187,1164585000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID34/",1164585000,1164622760,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID35/",1164622760,1164791492,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID36/",1164791492,1165011869,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID37/",1165011869,1165137732,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165137732,1165141973,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID39/",1165141973,1165152773,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID40/",1165152773,1165158487,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165158487,1165840826,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID41/",1165840826,1165950000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165950000,1166308856,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID42/",1166308856,1166703576,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43/",1166703576,1166815000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166815000,1166912110,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1166912110,1166934766,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166934766,1166951682,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1166951682,1166957219,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166957219,1167053100,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1167053100,1167058739,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1167058739,1167075633,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167075633,1167081271,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167081271,1167109565,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167109565,1167115205,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167115205,1167126481,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167126481,1167137661,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167137661,1167154577,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167154577,1167234541,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID48/",1167234541,1167256073,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49/",1167256073,1167335114,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50/",1167335114,1167728734,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID51/",1167728734,1167730650,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50/",1167730650,1167735462,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID52/",1167735462,1168051125,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID53/",1168051125,1168118888,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID54/",1168118888,1168124527,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID55/",1168124527,1168502207,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID56/",1168502207,1168609440,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57/",1168609440,1168660085,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID58/",1168660085,1168727846,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID59/",1168727846,1168795408,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID60/",1168795408,1168874446,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61/",1168874446,1168891360,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62/",1168891360,1168896898,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61/",1168896898,1168959022,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID63/",1168959022,1168970298,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID64/",1168970298,1169060513,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID65/",1169060513,1169534050,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID66/",1169534050,1169861044,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID67/",1169861044,1169996460,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID68/",1169996460,1170019014,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID69/",1170019014,1170126038,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID70/",1170126038,1170408039,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID71/",1170408039,1170419316,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID72/",1170419316,1170892804,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID73/",1170892804,1170937907,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID74/",1170937907,1171265004,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID75/",1171265004,1171366385,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID76/",1171366385,1171890799,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77/",1171890799,1171997816,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78/",1171997816,1172009092,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77/",1172009092,1172088119,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78/",1172088119,1172093656,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79/",1172093656,1172217685,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID80/",1172217685,1172257150,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID81/",1172257150,1172268426,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID82/",1172268426,1172291075,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83/",1172291075,1172403831,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84/",1172403831,1172482657,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID85/",1172482657,1172561584,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID86/",1172561584,1172668700,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID87/",1172668700,1172674438,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID88/",1172674438,1172809741,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID87/",1172809741,1172821015,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID89/",1172821015,1172860479,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID90/",1172860479,1172995781,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID91/",1172995781,1173164908,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID92/",1173164908,1173305830,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID93/",1173305830,1173700366,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID94/",1173700366,1173739829,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID95/",1173739829,1173754000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID96/",1173754000,1174241650,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID97/",1174241650,1174280000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID98/",1174280000,1174309299,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID97/",1174309299,1174399494,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID96/",1174399494,1174489791,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID99/",1174489791,1174574249,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID100/",1174574249,1174613709,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID101/",1174613709,1174675617,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1174675617,1174799735,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID103/",1174799735,1175732000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID104/",1175732000,1175741113,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID105/",1175741113,1175746750,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID106/",1175746750,1176141323,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1176141323,1177110000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID107/",1177110000,1177477096,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID108/",1177477096,1177634000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID109/",1177634000,1177883026,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID108/",1177883026,1177977924,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1177977924,1178012562,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID101/",1178012562,1178159210,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1178159210,1178204299,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID111/",1178204299,1178677657,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1178677657,1178767838,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID112/",1178767838,1178875029,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID113/",1178875029,1178942564,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID114/",1178942564,1179179291,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1179179291,1179325936,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID115/",1179325936,1179511934,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID116/",1179511934,1180143195,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID117/",1180143195,1180154367,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID118/",1180154367,1180160105,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID117/",1180160105,1180537730,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID119/",1180537730,1180734994,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120/",1180734994,1180746267,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID119/",1180746267,1180904079,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1180904079,1181022438,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID122/",1181022438,1181033709,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1181033709,1181264790,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID122/",1181264790,1181315515,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1181315515,1181326687,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID123/",1181326687,1181349331,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181349331,1181411329,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181411329,1181416964,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181416964,1181422599,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181422599,1181445044,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181445044,1181462053,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID123/",1181462053,1181484599,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181484599,1181620531,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181620531,1181625399,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181625399,1181681759,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181681759,1181715576,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181715576,1181839668,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181839668,1182902310,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID126/",1182902310,1182933051,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID127/",1182933051,1182949959,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID128/",1182949959,1183034397,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID129/",1183034397,1183389563,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183389563,1183406472,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID131/",1183406472,1183474101,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183474101,1183780000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID132/",1183780000,1183784078,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID133/",1183784078,1183795351,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID132/",1183795351,1183834700,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183834700,1184009516,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134/",1184009516,1184026424,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID135/",1184026424,1184032059,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134/",1184032059,1184657543,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1184657543,1185460000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID136/",1185460000,1185829897,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID137/",1185829897,1185874903,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID138/",1185874903,1185926530,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID139/",1185926530,1186049691,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID140/",1186049691,1187216272,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID139/",1187216272,1187221908,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID141/",1187221908,1187695189,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID142/",1187695189,1187892528,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID143/",1187892528,1187942554,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID144/",1187942554,1188106675,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145/",1188106675,1188117846,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID146/",1188117846,1188247457,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID147/",1188247457,1188292642,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID148/",1188292642,1188315181,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID149/",1188315181,1188422151,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID150/",1188422151,1188433423,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID151/",1188433423,1188605269,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID152/",1188605269,1188827890,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID153/",1188827890,1189188641,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID154/",1189188641,1189273170,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID155/",1189273170,1189335155,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID156/",1189335155,1189498572,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID157/",1189498572,1189510000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID158/",1189510000,1189532383,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID159/",1189532383,1189583101,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID160/",1189583101,1189616912,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID159/",1189616912,1189639372,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID161/",1189639372,1189892950,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID162/",1189892950,1190135238,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1190135238,1190676197,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190676197,1190721379,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1190721379,1190760823,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190760823,1190850882,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID165/",1190850882,1190969216,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190969216,1191160802,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1191160802,1191205882,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID166/",1191205882,1191307310,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1191307310,1191955315,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID168/",1191955315,1192287786,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1192287786,1193285094,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID169/",1193285094,1193583719,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID170/",1193583719,1193611891,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID171/",1193611891,1193837267,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID170/",1193837267,1193875588,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID172/",1193875588,1193882442,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173/",1193882442,1194062742,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174/",1194062742,1194090814,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173/",1194090814,1194254208,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID166/",1194254208,1194259943,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1194259943,1194648710,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID175/",1194648710,1195031838,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1195031838,1195212133,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID176/",1195212133,1195437399,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1195437399,1195945000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID177/",1195945000,1196090956,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID178/",1196090956,1196243076,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID179/",1196243076,1196260078,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180/",1196260078,1196305050,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID181/",1196305050,1196383927,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182/",1196383927,1196688264,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID183/",1196688264,1196902358,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID184/",1196902358,1196941796,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1196941796,1198276949,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID186/",1198276949,1198282684,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1198282684,1198423431,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1198423431,1198462967,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1198462967,1198694001,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1198694001,1198958741,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID188/",1198958741,1199550280,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1199550280,1199612249,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID189/",1199612249,1199871295,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID190/",1199871295,1200048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID189/",1200048000,1200070000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1200070000,1200367144,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID188/",1200367144,1200860000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1200860000,1201544421,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID191/",1201544421,1201769754,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID192/",1201769754,1201786753,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID193/",1201786753,1201978287,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID194/",1201978287,1202040000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID195/",1202040000,1202062786,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID194/",1202062786,1202107850,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID196/",1202107850,1202141651,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID197/",1202141651,1202214782,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198/",1202214782,1202502178,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID196/",1202502178,1202868235,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID199/",1202868235,1203054231,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200/",1203054231,1203127758,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID201/",1203127758,1203285187,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID202/",1203285187,1203470979,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203/",1203470979,1203600640,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID204/",1203600640,1203713302,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID201/",1203713302,1206326783,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID205/",1206326783,1206383107,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID206/",1206383107,1206563444,6,"trk mask",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207/",1206563444,1206579876,6,"trk mask",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-1/",    1206579876,4294967295,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207/",1206563444,1206576000,6,"trk mask",NULL);
-- NDS masks:
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID256NDS/",1206576000,1206662400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID257NDS/",1206662400,1206748800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID257NDS/",1206748800,1206835200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID258NDS/",1206835200,1206921600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID258NDS/",1206921600,1207008000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID259NDS/",1207008000,1207094400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID260NDS/",1207094400,1207180800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID261NDS/",1207180800,1207267200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID262NDS/",1207267200,1207353600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID263NDS/",1207353600,1207440000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID264NDS/",1207440000,1207526400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID265NDS/",1207526400,1207612800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID266NDS/",1207612800,1207699200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID267NDS/",1207699200,1207785600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID268NDS/",1207785600,1207872000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID269NDS/",1207872000,1207958400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID270NDS/",1207958400,1208044800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID271NDS/",1208044800,1208131200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID272NDS/",1208131200,1208217600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID273NDS/",1208217600,1208304000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID274NDS/",1208304000,1208390400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID275NDS/",1208390400,1208476800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID276NDS/",1208476800,1208563200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID277NDS/",1208563200,1208649600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID278NDS/",1208649600,1208736000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID279NDS/",1208736000,1208822400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID280NDS/",1208822400,1208908800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID281NDS/",1208908800,1208995200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID282NDS/",1208995200,1209081600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID283NDS/",1209081600,1209168000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID284NDS/",1209168000,1209254400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID285NDS/",1209254400,1209340800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID283NDS/",1209340800,1209427200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID284NDS/",1209427200,1209513600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID286NDS/",1209513600,1209600000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287NDS/",1209600000,1209686400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID288NDS/",1209686400,1209772800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID289NDS/",1209772800,1209859200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID290NDS/",1209859200,1209945600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID291NDS/",1209945600,1210032000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID292NDS/",1210032000,1210118400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID293NDS/",1210118400,1210204800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID294NDS/",1210204800,1210291200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID295NDS/",1210291200,1210377600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID296NDS/",1210377600,1210464000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID297NDS/",1210464000,1210550400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID298NDS/",1210550400,1210636800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID299NDS/",1210636800,1210723200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID300NDS/",1210723200,1210809600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301NDS/",1210809600,1210896000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID302NDS/",1210896000,1210982400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID303NDS/",1210982400,1211068800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID304NDS/",1211068800,1211155200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID304NDS/",1211155200,1211241600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID305NDS/",1211241600,1211328000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306NDS/",1211328000,1211414400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID307NDS/",1211414400,1211500800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID308NDS/",1211500800,1211587200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID309NDS/",1211587200,1211673600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID310NDS/",1211673600,1211760000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID311NDS/",1211760000,1211846400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID312NDS/",1211846400,1211932800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID313NDS/",1211932800,1212019200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID314NDS/",1212019200,1212105600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID312NDS/",1212105600,1212192000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315NDS/",1212192000,1212278400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID316NDS/",1212278400,1212364800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID317NDS/",1212364800,1212451200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID318NDS/",1212451200,1212537600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID317NDS/",1212537600,1212624000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID317NDS/",1212624000,1212710400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319NDS/",1212710400,1212796800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID320NDS/",1212796800,1212883200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321NDS/",1212883200,1212969600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID322NDS/",1212969600,1213056000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID323NDS/",1213056000,1213142400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID324NDS/",1213142400,1213228800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID325NDS/",1213228800,1213315200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID326NDS/",1213315200,1213401600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID327NDS/",1213401600,1213488000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321NDS/",1213488000,1213574400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID328NDS/",1213574400,1213660800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID328NDS/",1213660800,1213747200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329NDS/",1213747200,1213833600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330NDS/",1213833600,1213920000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331NDS/",1213920000,1214006400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID332NDS/",1214006400,1214092800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID333NDS/",1214092800,1214179200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID334NDS/",1214179200,1214265600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID335NDS/",1214265600,1214352000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331NDS/",1214352000,1214438400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID336NDS/",1214438400,1214524800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID335NDS/",1214524800,1214611200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID337NDS/",1214611200,1214697600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338NDS/",1214697600,1214784000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338NDS/",1214784000,1214870400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338NDS/",1214870400,1214956800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID339NDS/",1214956800,1215043200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID340NDS/",1215043200,1215129600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID340NDS/",1215129600,1215216000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID341NDS/",1215216000,1215302400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342NDS/",1215302400,1215388800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID343NDS/",1215388800,1215475200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID344NDS/",1215475200,1215561600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID345NDS/",1215561600,1215648000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID345NDS/",1215648000,1215820800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID346NDS/",1215820800,1215907200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID347NDS/",1215907200,1215993600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348NDS/",1215993600,1216080000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID349NDS/",1216080000,1216166400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID350NDS/",1216166400,1216252800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351NDS/",1216252800,1216339200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID352NDS/",1216339200,1216425600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351NDS/",1216425600,1216512000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351NDS/",1216512000,1216598400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351NDS/",1216598400,1216684800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID353NDS/",1216684800,1216771200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID354NDS/",1216771200,1216857600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID355NDS/",1216857600,1216944000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID356NDS/",1216944000,1217030400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID357NDS/",1217030400,1217116800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID357NDS/",1217116800,1217203200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217203200,1217289600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217289600,1217376000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217376000,1217462400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID359NDS/",1217462400,1217548800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID359NDS/",1217548800,1217635200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217635200,1217721600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217721600,1217808000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358NDS/",1217808000,1217980800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID360NDS/",1217980800,1218067200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID361NDS/",1218067200,1218153600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID362NDS/",1218153600,1218240000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID362NDS/",1218240000,1218326400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID363NDS/",1218326400,1218412800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID364NDS/",1218412800,1218499200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID365NDS/",1218499200,1218585600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID366NDS/",1218585600,1218672000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID367NDS/",1218672000,1218758400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID368NDS/",1218758400,1218844800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID369NDS/",1218844800,1218931200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID370NDS/",1218931200,1219017600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID371NDS/",1219017600,1219104000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID372NDS/",1219104000,1219190400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID373NDS/",1219190400,1219276800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID374NDS/",1219276800,1219363200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID375NDS/",1219363200,1219449600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID376NDS/",1219449600,1219536000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID376NDS/",1219536000,1219622400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID377NDS/",1219622400,1219708800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID378NDS/",1219708800,1219795200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID379NDS/",1219795200,1219881600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID380NDS/",1219881600,1219968000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID381NDS/",1219968000,1220054400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382NDS/",1220054400,1220140800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID383NDS/",1220140800,1220227200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID384NDS/",1220227200,1220313600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID385NDS/",1220313600,1220400000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID386NDS/",1220400000,1220486400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID387NDS/",1220486400,1220572800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID388NDS/",1220572800,1220659200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID389NDS/",1220659200,1220745600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID390NDS/",1220745600,1220832000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID391NDS/",1220832000,1220918400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID391NDS/",1220918400,1221004800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID391NDS/",1221004800,1221091200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID390NDS/",1221091200,1222819200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID392NDS/",1222819200,1222905600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID393NDS/",1222905600,1222992000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID394NDS/",1222992000,1223078400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID394NDS/",1223078400,1223164800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID395NDS/",1223164800,1223251200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID396NDS/",1223251200,1223337600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID397NDS/",1223337600,1223424000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID398NDS/",1223424000,1223510400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID399NDS/",1223510400,1223596800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID400NDS/",1223596800,1223683200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401NDS/",1223683200,1223769600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402NDS/",1223769600,1223856000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID403NDS/",1223856000,1223942400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402NDS/",1223942400,1224028800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID404NDS/",1224028800,1224115200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID405NDS/",1224115200,1224201600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID406NDS/",1224201600,1224288000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID407NDS/",1224288000,1224374400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID408NDS/",1224374400,1224460800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID409NDS/",1224460800,1224547200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID410NDS/",1224547200,1224633600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411NDS/",1224633600,1224720000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412NDS/",1224720000,1224806400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID413NDS/",1224806400,1224892800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414NDS/",1224892800,1224979200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415NDS/",1224979200,1225065600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415NDS/",1225065600,1225152000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID416NDS/",1225152000,1225238400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415NDS/",1225238400,1225324800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415NDS/",1225324800,1225411200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415NDS/",1225411200,1225497600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID405NDS/",1225497600,1225584000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID405NDS/",1225584000,1225670400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID405NDS/",1225670400,1225756800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID417NDS/",1225756800,1225843200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID418NDS/",1225843200,1225929600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID419NDS/",1225929600,1226016000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID417NDS/",1226016000,1226102400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID420NDS/",1226102400,1226188800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421NDS/",1226188800,1226620800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421NDS/",1226620800,1226707200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID422NDS/",1226707200,1226793600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID423NDS/",1226793600,1226880000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID424NDS/",1226880000,1226966400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID425NDS/",1226966400,1227052800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID425NDS/",1227052800,1227139200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID426NDS/",1227139200,1227225600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID427NDS/",1227225600,1227312000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID428NDS/",1227312000,1227398400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID429NDS/",1227398400,1227484800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID428NDS/",1227484800,1227571200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID430NDS/",1227571200,1227657600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID429NDS/",1227657600,1227744000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID431NDS/",1227744000,1227830400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID432NDS/",1227830400,1228003200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID433NDS/",1228003200,1228089600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID433NDS/",1228089600,1228176000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID434NDS/",1228176000,1228262400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID435NDS/",1228262400,1228348800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID436NDS/",1228348800,1228435200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID436NDS/",1228435200,1228521600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID437NDS/",1228521600,1228608000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID438NDS/",1228608000,1228694400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID439NDS/",1228694400,1228780800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID437NDS/",1228780800,1228867200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID440NDS/",1228867200,1228953600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID440NDS/",1228953600,1229040000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID441NDS/",1229040000,1229126400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID442NDS/",1229126400,1229212800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID442NDS/",1229212800,1229299200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID443NDS/",1229299200,1229385600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID444NDS/",1229385600,1229472000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID445NDS/",1229472000,1229558400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID446NDS/",1229558400,1229644800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID447NDS/",1229644800,1229731200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID448NDS/",1229731200,1229817600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID449NDS/",1229817600,1229904000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID450NDS/",1229904000,1229990400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID451NDS/",1229990400,1230076800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID452NDS/",1230076800,1230249600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID453NDS/",1230249600,1230336000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID454NDS/",1230336000,1230422400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID455NDS/",1230422400,1230508800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID456NDS/",1230508800,1230595200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID457NDS/",1230595200,1230681600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID458NDS/",1230681600,1230940800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID459NDS/",1230940800,1231027200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID460NDS/",1231027200,1231113600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID460NDS/",1231113600,1231200000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID461NDS/",1231200000,1231286400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID462NDS/",1231286400,1231372800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID463NDS/",1231372800,1231459200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID464NDS/",1231459200,1231545600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID465NDS/",1231545600,1231632000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID466NDS/",1231632000,1231718400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID467NDS/",1231718400,1231804800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID468NDS/",1231804800,1231891200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID469NDS/",1231891200,1231977600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID470NDS/",1231977600,1232064000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID471NDS/",1232064000,1232150400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID472NDS/",1232150400,1232236800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID473NDS/",1232236800,1232323200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID474NDS/",1232323200,1232409600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID471NDS/",1232409600,1232496000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID474NDS/",1232496000,1232582400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID474NDS/",1232582400,1232668800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID471NDS/",1232668800,1232755200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475NDS/",1232755200,1232841600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID476NDS/",1232841600,1232928000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID477NDS/",1232928000,1233014400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID478NDS/",1233014400,1233100800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID479NDS/",1233100800,1233187200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID480NDS/",1233187200,1233273600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID480NDS/",1233273600,1233360000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID478NDS/",1233360000,1233446400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID478NDS/",1233446400,1233532800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID480NDS/",1233532800,1233619200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID478NDS/",1233619200,1233792000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481NDS/",1233792000,1233878400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID482NDS/",1233878400,1233964800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483NDS/",1233964800,1234051200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID484NDS/",1234051200,1235174400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID485NDS/",1235174400,1235260800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID486NDS/",1235260800,1235952000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID487NDS/",1235952000,1236038400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID488NDS/",1236038400,1236124800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID489NDS/",1236124800,1236211200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID490NDS/",1236211200,1236297600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491NDS/",1236297600,1236384000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492NDS/",1236384000,1236470400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID493NDS/",1236470400,1236556800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID494NDS/",1236556800,1236643200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID494NDS/",1236643200,1236729600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID495NDS/",1236729600,1236816000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496NDS/",1236816000,1236902400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID497NDS/",1236902400,1236988800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498NDS/",1236988800,1237075200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID499NDS/",1237075200,1237161600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID500NDS/",1237161600,1237248000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID501NDS/",1237248000,1237334400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID502NDS/",1237334400,1237420800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID503NDS/",1237420800,1237507200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID503NDS/",1237507200,1237593600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID504NDS/",1237593600,1237680000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID505NDS/",1237680000,1237766400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID505NDS/",1237766400,1237852800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID506NDS/",1237852800,1237939200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID507NDS/",1237939200,1238025600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID508NDS/",1238025600,1238112000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID509NDS/",1238112000,1238198400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID510NDS/",1238198400,1238284800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID511NDS/",1238284800,1238371200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID511NDS/",1238371200,1238457600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID512NDS/",1238457600,1238544000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID512NDS/",1238544000,1238630400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID513NDS/",1238630400,1238716800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID514NDS/",1238716800,1238803200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID514NDS/",1238803200,1238889600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID515NDS/",1238889600,1238976000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1238976000,1239062400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1239062400,1239148800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1239148800,1239235200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1239235200,1239321600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1239321600,1239408000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516NDS/",1239408000,1239494400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID517NDS/",1239494400,1239580800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID518NDS/",1239580800,1239667200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID519NDS/",1239667200,1239753600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID520NDS/",1239753600,1239840000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID521NDS/",1239840000,1239926400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID522NDS/",1239926400,1240012800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID521NDS/",1240012800,1240099200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID523NDS/",1240099200,1240185600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID524NDS/",1240185600,1240272000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID521NDS/",1240272000,1240358400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525NDS/",1240358400,1240444800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID526NDS/",1240444800,1240531200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID527NDS/",1240531200,1240617600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID528NDS/",1240617600,1240704000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID528NDS/",1240704000,1240790400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID529NDS/",1240790400,1240876800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID529NDS/",1240876800,1240963200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID529NDS/",1240963200,1241049600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID530NDS/",1241049600,1241136000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID531NDS/",1241136000,1241222400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID530NDS/",1241222400,1241308800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID532NDS/",1241308800,1241395200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID532NDS/",1241395200,1241481600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID533NDS/",1241481600,1241568000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID534NDS/",1241568000,1241654400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID535NDS/",1241654400,1241740800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID535NDS/",1241740800,1241827200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID536NDS/",1241827200,1241913600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID537NDS/",1241913600,1242000000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID538NDS/",1242000000,1242086400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID537NDS/",1242086400,1242172800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID537NDS/",1242172800,1242259200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539NDS/",1242259200,1242345600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539NDS/",1242345600,1242432000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539NDS/",1242432000,1242518400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID540NDS/",1242518400,1242604800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID541NDS/",1242604800,1242691200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID542NDS/",1242691200,1242777600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID543NDS/",1242777600,1242864000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID544NDS/",1242864000,1242950400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID545NDS/",1242950400,1243036800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID546NDS/",1243036800,1243123200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID546NDS/",1243123200,1243209600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID547NDS/",1243209600,1243296000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID548NDS/",1243296000,1243382400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID549NDS/",1243382400,1243468800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID550NDS/",1243468800,1243555200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID551NDS/",1243555200,1243641600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID552NDS/",1243641600,1243728000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID553NDS/",1243728000,1243814400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID554NDS/",1243814400,1243900800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID555NDS/",1243900800,1243987200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID556NDS/",1243987200,1244073600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID557NDS/",1244073600,1244160000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID558NDS/",1244160000,1244246400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID559NDS/",1244246400,1244332800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID560NDS/",1244332800,1244419200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID559NDS/",1244419200,1244505600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID561NDS/",1244505600,1244592000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID562NDS/",1244592000,1244678400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID563NDS/",1244678400,1244764800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID564NDS/",1244764800,1244851200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID565NDS/",1244851200,1244937600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID566NDS/",1244937600,1245024000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID567NDS/",1245024000,1245110400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID568NDS/",1245110400,1245196800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID569NDS/",1245196800,1245283200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID570NDS/",1245283200,1245369600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID570NDS/",1245369600,1245456000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID570NDS/",1245456000,1245542400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID568NDS/",1245542400,1245628800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID571NDS/",1245628800,1245715200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID572NDS/",1245715200,1245801600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID573NDS/",1245801600,1245888000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID574NDS/",1245888000,1245974400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID575NDS/",1245974400,1246060800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID576NDS/",1246060800,1246147200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID577NDS/",1246147200,1246233600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID578NDS/",1246233600,1246320000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID579NDS/",1246320000,1246406400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID575NDS/",1246406400,1246492800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID580NDS/",1246492800,1246579200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID580NDS/",1246579200,1246665600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID580NDS/",1246665600,1246752000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID581NDS/",1246752000,1246838400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID582NDS/",1246838400,1246924800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID583NDS/",1246924800,1247011200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID583NDS/",1247011200,1247097600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID583NDS/",1247097600,1247184000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID584NDS/",1247184000,1247270400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID585NDS/",1247270400,1247356800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID586NDS/",1247356800,1247443200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID587NDS/",1247443200,1247529600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID588NDS/",1247529600,1247616000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID589NDS/",1247616000,1247702400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID590NDS/",1247702400,1247788800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID591NDS/",1247788800,1247875200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID592NDS/",1247875200,1247961600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID592NDS/",1247961600,1248048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID591NDS/",1248048000,1248134400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID593NDS/",1248134400,1248220800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID593NDS/",1248220800,1248307200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID593NDS/",1248307200,1248393600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID594NDS/",1248393600,1248480000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID595NDS/",1248480000,1248566400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID595NDS/",1248566400,1248652800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID596NDS/",1248652800,1248739200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID597NDS/",1248739200,1248825600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID598NDS/",1248825600,1248912000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID599NDS/",1248912000,1248998400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID600NDS/",1248998400,1249084800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID601NDS/",1249084800,1249171200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID602NDS/",1249171200,1249257600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID603NDS/",1249257600,1249344000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID604NDS/",1249344000,1249430400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID605NDS/",1249430400,1249516800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID605NDS/",1249516800,1249603200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID606NDS/",1249603200,1249689600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID606NDS/",1249689600,1249948800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID607NDS/",1249948800,1250035200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608NDS/",1250035200,1250121600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608NDS/",1250121600,1250208000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID609NDS/",1250208000,1250294400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID610NDS/",1250294400,1250380800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611NDS/",1250380800,1250467200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611NDS/",1250467200,1250553600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID612NDS/",1250553600,1250640000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID612NDS/",1250640000,1250726400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID613NDS/",1250726400,1250812800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID614NDS/",1250812800,1250899200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611NDS/",1250899200,1250985600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID615NDS/",1250985600,1251072000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID615NDS/",1251072000,1251158400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID616NDS/",1251158400,1251244800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611NDS/",1251244800,1251331200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID616NDS/",1251331200,1251417600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID616NDS/",1251417600,1251504000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID610NDS/",1251504000,1251590400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID610NDS/",1251590400,1251676800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID617NDS/",1251676800,1251763200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID618NDS/",1251763200,1251849600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID619NDS/",1251849600,1251936000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID620NDS/",1251936000,1252022400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID621NDS/",1252022400,1252108800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID622NDS/",1252108800,1252195200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID623NDS/",1252195200,1252281600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID624NDS/",1252281600,1252368000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID625NDS/",1252368000,1252454400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID626NDS/",1252454400,1252540800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID627NDS/",1252540800,1252627200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID628NDS/",1252627200,1252713600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID629NDS/",1252713600,1252800000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID629NDS/",1252800000,1252886400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID630NDS/",1252886400,1252972800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID631NDS/",1252972800,1253059200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID631NDS/",1253059200,1253145600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID631NDS/",1253145600,1253232000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID632NDS/",1253232000,1253318400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID633NDS/",1253318400,1253404800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID634NDS/",1253404800,1253491200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID635NDS/",1253491200,1253577600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID636NDS/",1253577600,1253664000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID636NDS/",1253664000,1253750400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID637NDS/",1253750400,1253836800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID638NDS/",1253836800,1253923200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID639NDS/",1253923200,1254009600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID640NDS/",1254009600,1254096000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID641NDS/",1254096000,1254182400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID641NDS/",1254182400,1254268800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID642NDS/",1254268800,1254355200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID643NDS/",1254355200,1254441600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID643NDS/",1254441600,1254528000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID642NDS/",1254528000,1254614400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID642NDS/",1254614400,1254700800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID642NDS/",1254700800,1254787200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID643NDS/",1254787200,1254873600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID644NDS/",1254873600,1254960000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID643NDS/",1254960000,1255046400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID645NDS/",1255046400,1255132800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID646NDS/",1255132800,1255219200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID646NDS/",1255219200,1255305600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID647NDS/",1255305600,1255392000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID648NDS/",1255392000,1255478400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID647NDS/",1255478400,1255564800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID649NDS/",1255564800,1255651200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID650NDS/",1255651200,1255737600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1255737600,1255824000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1255824000,1255910400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1255910400,1255996800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1255996800,1256083200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1256083200,1256169600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID652NDS/",1256169600,1256256000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653NDS/",1256256000,1256342400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID652NDS/",1256342400,1256428800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1256428800,1256515200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651NDS/",1256515200,1256601600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID652NDS/",1256601600,1256688000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID652NDS/",1256688000,1256774400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID654NDS/",1256774400,1256860800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID655NDS/",1256860800,1256947200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID656NDS/",1256947200,1257033600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID657NDS/",1257033600,1257120000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653NDS/",1257120000,1257206400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653NDS/",1257206400,1257292800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653NDS/",1257292800,1257379200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653NDS/",1257379200,1257465600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID658NDS/",1257465600,1257552000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659NDS/",1257552000,1257638400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660NDS/",1257638400,1257724800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660NDS/",1257724800,1257811200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660NDS/",1257811200,1257897600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660NDS/",1257897600,1257984000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660NDS/",1257984000,1258156800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID661NDS/",1258156800,1258243200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID662NDS/",1258243200,1258329600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID663NDS/",1258329600,1258588800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID664NDS/",1258588800,1258675200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID665NDS/",1258675200,1258934400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID666NDS/",1258934400,1259020800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667NDS/",1259020800,1259107200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID668NDS/",1259107200,1259193600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID669NDS/",1259193600,1259280000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID670NDS/",1259280000,1259366400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID671NDS/",1259366400,1259452800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID672NDS/",1259452800,1259539200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID673NDS/",1259539200,1259625600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID674NDS/",1259625600,1259712000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID675NDS/",1259712000,1259798400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID676NDS/",1259798400,1259884800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID676NDS/",1259884800,1259971200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID676NDS/",1259971200,1260057600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID677NDS/",1260057600,1260144000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID678NDS/",1260144000,1260230400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID677NDS/",1260230400,1260316800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID679NDS/",1260316800,1260403200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID680NDS/",1260403200,1260489600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID681NDS/",1260489600,1260576000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID682NDS/",1260576000,1260662400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID683NDS/",1260662400,1260748800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID682NDS/",1260748800,1260835200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684NDS/",1260835200,1260921600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684NDS/",1260921600,1261008000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684NDS/",1261008000,1261094400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID685NDS/",1261094400,1261180800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID686NDS/",1261180800,1261267200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID687NDS/",1261267200,1261353600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID688NDS/",1261353600,1261440000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID687NDS/",1261440000,1261526400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID687NDS/",1261526400,1261612800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID689NDS/",1261612800,1261699200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID689NDS/",1261699200,1261785600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID690NDS/",1261785600,1261872000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID691NDS/",1261872000,1261958400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID690NDS/",1261958400,1262044800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID692NDS/",1262044800,1262131200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID693NDS/",1262131200,1262217600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID694NDS/",1262217600,1262304000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID695NDS/",1262304000,1262390400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID694NDS/",1262390400,1262476800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID696NDS/",1262476800,1262563200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID697NDS/",1262563200,1262649600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1262649600,1262736000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID699NDS/",1262736000,1262822400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1262822400,1262908800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1262908800,1262995200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID700NDS/",1262995200,1263081600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID700NDS/",1263081600,1263168000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID700NDS/",1263168000,1263254400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID700NDS/",1263254400,1263340800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1263340800,1263427200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1263427200,1263513600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1263513600,1263600000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698NDS/",1263600000,1263686400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID701NDS/",1263686400,1263772800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID701NDS/",1263772800,1263859200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID702NDS/",1263859200,1263945600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID702NDS/",1263945600,1264032000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID702NDS/",1264032000,1264118400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID702NDS/",1264118400,1264204800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID703NDS/",1264204800,1264291200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704NDS/",1264291200,1264377600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID705NDS/",1264377600,1264464000,6,"trk mask",NULL);
-- MM new masks:
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0MM/",1264464000,1264550400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM/",1264550400,1264636800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID2MM/",1264636800,1264723200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3MM/",1264723200,1264809600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4MM/",1264809600,1264896000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID5MM/",1264896000,1264982400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID6MM/",1264982400,1265068800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID7MM/",1265068800,1265155200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID8MM/",1265155200,1265241600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID9MM/",1265241600,1265328000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10MM/",1265328000,1265414400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID11MM/",1265414400,1265500800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID9MM/",1265500800,1265587200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM/",1265587200,1265673600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13MM/",1265673600,1265760000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID14MM/",1265760000,1265846400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID15MM/",1265846400,1265932800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID15MM/",1265932800,1266019200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID14MM/",1266019200,1266105600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16MM/",1266105600,1266192000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID17MM/",1266192000,1266278400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID18MM/",1266278400,1266364800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID19MM/",1266364800,1266451200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM/",1266451200,1266537600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21MM/",1266537600,1266624000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM/",1266624000,1266710400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID23MM/",1266710400,1266796800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24MM/",1266796800,1266883200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25MM/",1266883200,1266969600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25MM/",1266969600,1267056000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID26MM/",1267056000,1267142400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID27MM/",1267142400,1267228800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID28MM/",1267228800,1267315200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29MM/",1267315200,1267401600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID30MM/",1267401600,1267488000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31MM/",1267488000,1267574400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID32MM/",1267574400,1267660800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID33MM/",1267660800,1267747200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID34MM/",1267747200,1267833600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID35MM/",1267833600,1267920000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID36MM/",1267920000,1268006400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID36MM/",1268006400,1268092800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID37MM/",1268092800,1268179200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38MM/",1268179200,1268265600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID39MM/",1268265600,1268352000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID40MM/",1268352000,1268438400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID41MM/",1268438400,1268524800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID42MM/",1268524800,1268611200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM/",1268611200,1268697600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44MM/",1268697600,1268784000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM/",1268784000,1268870400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM/",1268870400,1268956800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM/",1268956800,1269043200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45MM/",1269043200,1269129600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM/",1269129600,1269216000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46MM/",1269216000,1269302400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM/",1269302400,1269388800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID48MM/",1269388800,1269475200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM/",1269475200,1269561600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50MM/",1269561600,1269648000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID51MM/",1269648000,1269734400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID52MM/",1269734400,1269820800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID53MM/",1269820800,1269907200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID54MM/",1269907200,1269993600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID55MM/",1269993600,1270080000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID56MM/",1270080000,1270166400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57MM/",1270166400,1276560000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID58MM/",1276560000,1276732800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID59MM/",1276732800,1276819200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID60MM/",1276819200,1276905600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61MM/",1276905600,1276992000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62MM/",1276992000,1277078400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID63MM/",1277078400,1283385600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID64MM/",1283385600,1283472000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID65MM/",1283472000,1283558400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID66MM/",1283558400,1283644800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID67MM/",1283644800,1283731200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID68MM/",1283731200,1283817600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID69MM/",1283817600,1283904000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID70MM/",1283904000,1283990400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID71MM/",1283990400,1284076800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID72MM/",1284076800,1284163200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID73MM/",1284163200,1284249600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID74MM/",1284249600,1284336000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID75MM/",1284336000,1284422400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID76MM/",1284422400,1284508800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77MM/",1284508800,1284595200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78MM/",1284595200,1284681600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79MM/",1284681600,1284768000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID80MM/",1284768000,1284854400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID81MM/",1284854400,1284940800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID80MM/",1284940800,1285027200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID82MM/",1285027200,1285113600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83MM/",1285113600,1285200000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM/",1285200000,1285286400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID85MM/",1285286400,1285372800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID86MM/",1285372800,1285459200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID87MM/",1285459200,1285545600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID88MM/",1285545600,1285632000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID89MM/",1285632000,1285718400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID90MM/",1285718400,1287446400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID91MM/",1287446400,1287532800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID92MM/",1287532800,1287619200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID93MM/",1287619200,1287705600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID94MM/",1287705600,1287792000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID95MM/",1287792000,1287878400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID96MM/",1287878400,1287964800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID97MM/",1287964800,1288051200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID98MM/",1288051200,1288137600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID99MM/",1288137600,1288224000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID100MM/",1288224000,1288310400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID101MM/",1288310400,1288396800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102MM/",1288396800,1288483200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID103MM/",1288483200,1288569600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID104MM/",1288569600,1288656000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID105MM/",1288656000,1288742400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID106MM/",1288742400,1288828800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID107MM/",1288828800,1288915200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID108MM/",1288915200,1289001600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID109MM/",1289001600,1289088000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110MM/",1289088000,1289174400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID111MM/",1289174400,1289260800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID111MM/",1289260800,1289347200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID112MM/",1289347200,1289433600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID113MM/",1289433600,1289520000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID114MM/",1289520000,1289606400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID115MM/",1289606400,1289692800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID116MM/",1289692800,1289779200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID117MM/",1289779200,1289865600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID118MM/",1289865600,1289952000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID119MM/",1289952000,1290038400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1290038400,1290124800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1290124800,1290211200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1290211200,1290297600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1290297600,1290384000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID122MM/",1290384000,1290470400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1290470400,1290556800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID123MM/",1290556800,1290643200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1290643200,1290729600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1290729600,1290816000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1290816000,1290902400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1290902400,1290988800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1290988800,1291075200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1291075200,1291161600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121MM/",1291161600,1291248000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1291248000,1291334400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120MM/",1291334400,1291420800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124MM/",1291420800,1291507200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125MM/",1291507200,1291593600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID126MM/",1291593600,1291680000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID127MM/",1291680000,1291766400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID128MM/",1291766400,1291852800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID129MM/",1291852800,1291939200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130MM/",1291939200,1292025600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID131MM/",1292025600,1292112000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130MM/",1292112000,1292198400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130MM/",1292198400,1292284800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID132MM/",1292284800,1292371200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID133MM/",1292371200,1292457600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134MM/",1292457600,1292544000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134MM/",1292544000,1292630400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID135MM/",1292630400,1292716800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID131MM/",1292716800,1292803200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID136MM/",1292803200,1292889600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID137MM/",1292889600,1292976000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID133MM/",1292976000,1293062400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID129MM/",1293062400,1293148800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID138MM/",1293148800,1293235200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID139MM/",1293235200,1293321600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID140MM/",1293321600,1293408000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID141MM/",1293408000,1293494400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID142MM/",1293494400,1293580800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID143MM/",1293580800,1293667200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID143MM/",1293667200,1293753600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID144MM/",1293753600,1293840000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID144MM/",1293840000,1293926400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1293926400,1294012800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1294012800,1294099200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1294099200,1294185600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID146MM/",1294185600,1294272000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID147MM/",1294272000,1294358400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1294358400,1294444800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1294444800,1294531200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145MM/",1294531200,1294617600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID147MM/",1294617600,1294704000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID148MM/",1294704000,1294790400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID149MM/",1294790400,1294876800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID150MM/",1294876800,1294963200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID151MM/",1294963200,1295049600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID152MM/",1295049600,1295136000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID153MM/",1295136000,1295222400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID154MM/",1295222400,1295308800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID155MM/",1295308800,1295395200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID155MM/",1295395200,1295481600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID156MM/",1295481600,1295568000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID156MM/",1295568000,1295654400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID157MM/",1295654400,1295740800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID158MM/",1295740800,1295827200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID159MM/",1295827200,1295913600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID160MM/",1295913600,1296000000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID160MM/",1296000000,1296086400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID160MM/",1296086400,1296172800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID161MM/",1296172800,1296259200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID161MM/",1296259200,1296345600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID161MM/",1296345600,1296518400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID162MM/",1296518400,1296604800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163MM/",1296604800,1296691200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164MM/",1296691200,1296777600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID165MM/",1296777600,1296864000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID166MM/",1296864000,1296950400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167MM/",1296950400,1297036800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID168MM/",1297036800,1297123200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID169MM/",1297123200,1297209600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID169MM/",1297209600,1297296000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID169MM/",1297296000,1297382400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID170MM/",1297382400,1297468800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID171MM/",1297468800,1297555200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID172MM/",1297555200,1297641600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173MM/",1297641600,1297728000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173MM/",1297728000,1297814400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173MM/",1297814400,1297900800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174MM/",1297900800,1297987200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173MM/",1297987200,1298073600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173MM/",1298073600,1298160000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174MM/",1298160000,1298246400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174MM/",1298246400,1298332800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174MM/",1298332800,1298419200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID175MM/",1298419200,1298505600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID176MM/",1298505600,1298592000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID177MM/",1298592000,1298678400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID177MM/",1298678400,1298764800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID178MM/",1298764800,1298851200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID179MM/",1298851200,1298937600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180MM/",1298937600,1299024000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180MM/",1299024000,1299110400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID181MM/",1299110400,1299196800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299196800,1299283200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299283200,1299369600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299369600,1299456000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299456000,1299542400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID183MM/",1299542400,1299628800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID183MM/",1299628800,1299715200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID184MM/",1299715200,1299801600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299801600,1299888000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1299888000,1299974400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185MM/",1299974400,1300060800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID184MM/",1300060800,1300147200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1300147200,1300233600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID184MM/",1300233600,1300320000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1300320000,1300406400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1300406400,1300492800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID186MM/",1300492800,1300579200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187MM/",1300579200,1300665600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID186MM/",1300665600,1300752000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1300752000,1300838400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182MM/",1300838400,1300924800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180MM/",1300924800,1301011200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180MM/",1301011200,1301097600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180MM/",1301097600,1301184000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID188MM/",1301184000,1301270400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID189MM/",1301270400,1301356800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID190MM/",1301356800,1301443200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID190MM/",1301443200,1301529600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID191MM/",1301529600,1301616000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID192MM/",1301616000,1301702400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID193MM/",1301702400,1301788800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID194MM/",1301788800,1301875200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID195MM/",1301875200,1301961600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID196MM/",1301961600,1302048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID197MM/",1302048000,1302134400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198MM/",1302134400,1302220800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198MM/",1302220800,1302307200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID199MM/",1302307200,1302393600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198MM/",1302393600,1302480000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID199MM/",1302480000,1302566400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198MM/",1302566400,1302652800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1302652800,1302739200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1302739200,1302825600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1302825600,1302912000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1302912000,1302998400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1302998400,1303084800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303084800,1303171200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303171200,1303257600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303257600,1303344000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303344000,1303430400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303430400,1303516800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303516800,1303603200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303603200,1303689600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID201MM/",1303689600,1303776000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303776000,1303862400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1303862400,1303948800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID202MM/",1303948800,1304035200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1304035200,1304121600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1304121600,1304208000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1304208000,1304294400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1304294400,1304380800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1304380800,1304467200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1304467200,1304553600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200MM/",1304553600,1304640000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID204MM/",1304640000,1304726400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1304726400,1304812800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1304812800,1304899200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID205MM/",1304899200,1304985600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1304985600,1305072000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203MM/",1305072000,1305158400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID206MM/",1305158400,1305244800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207MM/",1305244800,1305331200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID208MM/",1305331200,1305417600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207MM/",1305417600,1305504000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207MM/",1305504000,1305590400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID209MM/",1305590400,1305676800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID210MM/",1305676800,1305763200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID211MM/",1305763200,1305849600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID212MM/",1305849600,1305936000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID213MM/",1305936000,1306022400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID214MM/",1306022400,1306108800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID215MM/",1306108800,1306195200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID216MM/",1306195200,1306281600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID217MM/",1306281600,1306368000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID218MM/",1306368000,1306454400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID218MM/",1306454400,1306540800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID219MM/",1306540800,1306627200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID220MM/",1306627200,1306713600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID221MM/",1306713600,1306800000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID222MM/",1306800000,1306886400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID223MM/",1306886400,1306972800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID224MM/",1306972800,1307059200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID225MM/",1307059200,1307145600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID226MM/",1307145600,1307232000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID226MM/",1307232000,1307318400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID225MM/",1307318400,1307404800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID225MM/",1307404800,1307491200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID225MM/",1307491200,1307577600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID227MM/",1307577600,1307664000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID228MM/",1307664000,1307750400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID228MM/",1307750400,1307836800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID229MM/",1307836800,1307923200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID228MM/",1307923200,1308009600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID230MM/",1308009600,1308096000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID231MM/",1308096000,1308182400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID228MM/",1308182400,1308268800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1308268800,1308355200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID233MM/",1308355200,1308441600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID234MM/",1308441600,1308528000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID235MM/",1308528000,1308614400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID236MM/",1308614400,1308700800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID234MM/",1308700800,1308787200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1308787200,1308873600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1308873600,1308960000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID234MM/",1308960000,1309046400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID234MM/",1309046400,1309132800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1309132800,1309219200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID237MM/",1309219200,1309305600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1309305600,1309392000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID238MM/",1309392000,1309478400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID232MM/",1309478400,1309564800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID239MM/",1309564800,1309651200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID240MM/",1309651200,1309737600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID241MM/",1309737600,1309824000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID242MM/",1309824000,1309910400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID243MM/",1309910400,1309996800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID244MM/",1309996800,1310083200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID245MM/",1310083200,1310169600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID246MM/",1310169600,1310256000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID247MM/",1310256000,1310342400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID248MM/",1310342400,1310428800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID249MM/",1310428800,1310515200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID250MM/",1310515200,1310601600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID251MM/",1310601600,1310688000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID250MM/",1310688000,1310774400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID252MM/",1310774400,1310860800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID253MM/",1310860800,1310947200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1310947200,1311033600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311033600,1311120000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311120000,1311206400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID255MM/",1311206400,1311292800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311292800,1311379200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311379200,1311465600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311465600,1311552000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311552000,1311638400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311638400,1311724800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID256MM/",1311724800,1311811200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID257MM/",1311811200,1311897600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID256MM/",1311897600,1311984000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1311984000,1312070400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID254MM/",1312070400,1312156800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID258MM/",1312156800,1312243200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID256MM/",1312243200,1314230400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID259MM/",1314230400,1315180800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID260MM/",1315180800,1315267200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID261MM/",1315267200,1315353600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID262MM/",1315353600,1315440000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID261MM/",1315440000,1315526400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID262MM/",1315526400,1315612800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID263MM/",1315612800,1315699200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID264MM/",1315699200,1315785600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID265MM/",1315785600,1315872000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID266MM/",1315872000,1315958400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID267MM/",1315958400,1316044800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID268MM/",1316044800,1316131200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID269MM/",1316131200,1316217600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID264MM/",1316217600,1316304000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID270MM/",1316304000,1316390400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID271MM/",1316390400,1316476800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID272MM/",1316476800,1318809600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID273MM/",1318809600,1318896000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID274MM/",1318896000,1318982400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID275MM/",1318982400,1319068800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID276MM/",1319068800,1319155200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID277MM/",1319155200,1319241600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID277MM/",1319241600,1319328000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID278MM/",1319328000,1319414400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID278MM/",1319414400,1319500800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID279MM/",1319500800,1319587200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID280MM/",1319587200,1319673600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID281MM/",1319673600,1319760000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID281MM/",1319760000,1319846400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID282MM/",1319846400,1319932800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID283MM/",1319932800,1320019200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID284MM/",1320019200,1320105600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID284MM/",1320105600,1320192000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID284MM/",1320192000,1320278400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID285MM/",1320278400,1320364800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID285MM/",1320364800,1320451200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID285MM/",1320451200,1320537600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID285MM/",1320537600,1320624000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID286MM/",1320624000,1320710400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287MM/",1320710400,1320796800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID288MM/",1320796800,1320883200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID289MM/",1320883200,1320969600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID290MM/",1320969600,1321056000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID291MM/",1321056000,1321142400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID292MM/",1321142400,1321228800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID290MM/",1321228800,1321315200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287MM/",1321315200,1321401600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID293MM/",1321401600,1321488000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID294MM/",1321488000,1321574400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287MM/",1321574400,1321660800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287MM/",1321660800,1321747200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID295MM/",1321747200,1321833600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID287MM/",1321833600,1321920000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID291MM/",1321920000,1322006400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID296MM/",1322006400,1322092800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID297MM/",1322092800,1322179200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID297MM/",1322179200,1322265600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID298MM/",1322265600,1322352000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID299MM/",1322352000,1322438400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID299MM/",1322438400,1322524800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID300MM/",1322524800,1322611200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301MM/",1322611200,1322697600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID302MM/",1322697600,1322784000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301MM/",1322784000,1322870400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301MM/",1322870400,1322956800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301MM/",1322956800,1323043200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID301MM/",1323043200,1323129600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID303MM/",1323129600,1323216000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID304MM/",1323216000,1323302400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID305MM/",1323302400,1323388800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306MM/",1323388800,1323475200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID307MM/",1323475200,1323561600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID308MM/",1323561600,1323648000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID309MM/",1323648000,1323734400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID310MM/",1323734400,1323820800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID310MM/",1323820800,1323907200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306MM/",1323907200,1323993600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306MM/",1323993600,1324080000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306MM/",1324080000,1324166400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID306MM/",1324166400,1324252800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID311MM/",1324252800,1324339200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID312MM/",1324339200,1324425600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID313MM/",1324425600,1324512000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID314MM/",1324512000,1324598400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1324598400,1324684800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID316MM/",1324684800,1324771200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1324771200,1324857600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1324857600,1324944000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1324944000,1325030400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1325030400,1325116800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID316MM/",1325116800,1325203200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1325203200,1325289600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID315MM/",1325289600,1325376000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID317MM/",1325376000,1325462400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID318MM/",1325462400,1325548800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1325548800,1325635200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1325635200,1325721600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1325721600,1325808000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1325808000,1325894400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID320MM/",1325894400,1325980800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1325980800,1326067200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1326067200,1326153600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1326153600,1326240000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321MM/",1326240000,1326326400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1326326400,1326412800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1326412800,1326499200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID322MM/",1326499200,1326585600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID323MM/",1326585600,1326672000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321MM/",1326672000,1326758400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321MM/",1326758400,1326844800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID321MM/",1326844800,1326931200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID319MM/",1326931200,1327017600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID324MM/",1327017600,1327104000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID325MM/",1327104000,1327190400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID326MM/",1327190400,1327276800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID327MM/",1327276800,1327363200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID328MM/",1327363200,1327449600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329MM/",1327449600,1327536000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329MM/",1327536000,1327622400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329MM/",1327622400,1327708800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329MM/",1327708800,1327795200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID327MM/",1327795200,1327881600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID327MM/",1327881600,1327968000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID329MM/",1327968000,1328054400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1328054400,1328140800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1328140800,1328227200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1328227200,1328313600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1328313600,1328400000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1328400000,1328486400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331MM/",1328486400,1328572800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331MM/",1328572800,1328659200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID332MM/",1328659200,1328745600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID333MM/",1328745600,1328832000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID334MM/",1328832000,1328918400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID333MM/",1328918400,1329004800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1329004800,1329091200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1329091200,1329177600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331MM/",1329177600,1329264000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID335MM/",1329264000,1329350400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID330MM/",1329350400,1329436800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331MM/",1329436800,1329523200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID336MM/",1329523200,1329609600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID331MM/",1329609600,1329696000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID337MM/",1329696000,1329782400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338MM/",1329782400,1329868800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338MM/",1329868800,1329955200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338MM/",1329955200,1330041600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID338MM/",1330041600,1330128000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID339MM/",1330128000,1330214400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID340MM/",1330214400,1330300800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID340MM/",1330300800,1330387200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID340MM/",1330387200,1330473600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID341MM/",1330473600,1330560000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342MM/",1330560000,1330646400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342MM/",1330646400,1330732800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342MM/",1330732800,1330819200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342MM/",1330819200,1330905600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID342MM/",1330905600,1330992000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID343MM/",1330992000,1331078400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID344MM/",1331078400,1331164800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID345MM/",1331164800,1331251200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID346MM/",1331251200,1331337600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID347MM/",1331337600,1331424000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348MM/",1331424000,1331510400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348MM/",1331510400,1331596800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348MM/",1331596800,1331683200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID349MM/",1331683200,1331769600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348MM/",1331769600,1331856000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID350MM/",1331856000,1331942400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID349MM/",1331942400,1332028800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID348MM/",1332028800,1332115200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351MM/",1332115200,1332201600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID350MM/",1332201600,1332288000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID352MM/",1332288000,1332374400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID350MM/",1332374400,1332460800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID353MM/",1332460800,1332547200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID354MM/",1332547200,1332633600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID351MM/",1332633600,1332720000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID355MM/",1332720000,1332806400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID356MM/",1332806400,1332892800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID356MM/",1332892800,1332979200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID357MM/",1332979200,1333065600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID357MM/",1333065600,1333152000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID358MM/",1333152000,1333238400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID359MM/",1333238400,1333324800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID360MM/",1333324800,1333411200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID361MM/",1333411200,1333497600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID362MM/",1333497600,1333584000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID363MM/",1333584000,1333670400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID364MM/",1333670400,1333756800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID365MM/",1333756800,1333843200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID366MM/",1333843200,1333929600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID367MM/",1333929600,1334016000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID368MM/",1334016000,1334102400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID369MM/",1334102400,1336608000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID370MM/",1336608000,1336694400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID371MM/",1336694400,1336780800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID372MM/",1336780800,1336867200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID373MM/",1336867200,1336953600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID374MM/",1336953600,1337040000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID375MM/",1337040000,1337126400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID376MM/",1337126400,1337212800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID376MM/",1337212800,1337299200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID377MM/",1337299200,1337385600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID378MM/",1337385600,1337472000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID379MM/",1337472000,1337558400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID380MM/",1337558400,1337644800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID381MM/",1337644800,1337731200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1337731200,1337817600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID383MM/",1337817600,1337904000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID383MM/",1337904000,1337990400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1337990400,1338076800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID384MM/",1338076800,1338163200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID385MM/",1338163200,1338249600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID385MM/",1338249600,1338336000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID386MM/",1338336000,1338422400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1338422400,1338508800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID387MM/",1338508800,1338595200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1338595200,1338681600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID379MM/",1338681600,1338768000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1338768000,1338854400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1338854400,1338940800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1338940800,1339027200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID382MM/",1339027200,1339113600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID388MM/",1339113600,1339200000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID389MM/",1339200000,1339286400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID390MM/",1339286400,1339372800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID385MM/",1339372800,1339459200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID379MM/",1339459200,1339545600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID391MM/",1339545600,1339632000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID392MM/",1339632000,1339718400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID393MM/",1339718400,1339804800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID394MM/",1339804800,1339891200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID395MM/",1339891200,1339977600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID396MM/",1339977600,1340064000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID397MM/",1340064000,1340150400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID395MM/",1340150400,1340236800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID398MM/",1340236800,1340323200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID397MM/",1340323200,1340409600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID397MM/",1340409600,1340496000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID396MM/",1340496000,1340582400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID397MM/",1340582400,1340668800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID394MM/",1340668800,1340755200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID399MM/",1340755200,1340841600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID396MM/",1340841600,1340928000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID395MM/",1340928000,1341014400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID396MM/",1341014400,1341100800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID400MM/",1341100800,1341187200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID400MM/",1341187200,1341273600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341273600,1341360000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341360000,1341446400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1341446400,1341532800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1341532800,1341619200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1341619200,1341705600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341705600,1341792000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341792000,1341878400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341878400,1341964800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1341964800,1342051200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID403MM/",1342051200,1342137600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID404MM/",1342137600,1342224000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342224000,1342310400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342310400,1342396800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342396800,1342483200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342483200,1342569600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID405MM/",1342569600,1342656000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342656000,1342742400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342742400,1342828800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342828800,1342915200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1342915200,1343001600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1343001600,1343088000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID402MM/",1343088000,1345075200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID406MM/",1345075200,1345161600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID407MM/",1345161600,1345248000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID408MM/",1345248000,1345334400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID408MM/",1345334400,1345420800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID409MM/",1345420800,1345507200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID408MM/",1345507200,1345593600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID410MM/",1345593600,1345680000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID408MM/",1345680000,1345766400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1345766400,1345852800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1345852800,1345939200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1345939200,1346025600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346025600,1346112000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346112000,1346198400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346198400,1346284800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346284800,1346371200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1346371200,1346457600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346457600,1346544000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346544000,1346630400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID413MM/",1346630400,1346716800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID413MM/",1346716800,1346803200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID412MM/",1346803200,1346889600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1346889600,1346976000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1346976000,1347062400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1347062400,1347148800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID415MM/",1347148800,1347235200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID416MM/",1347235200,1347321600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1347321600,1347408000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1347408000,1347494400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1347494400,1347580800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID414MM/",1347580800,1347667200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID417MM/",1347667200,1347753600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1347753600,1347840000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID411MM/",1347840000,1347926400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID418MM/",1347926400,1348012800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID419MM/",1348012800,1348099200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID419MM/",1348099200,1348185600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID419MM/",1348185600,1348272000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID420MM/",1348272000,1348358400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID420MM/",1348358400,1348444800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID259MM/",1348444800,1348531200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID259MM/",1348531200,1348617600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1348617600,1348704000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1348704000,1348790400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1348790400,1348876800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1348876800,1348963200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1348963200,1349049600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID422MM/",1349049600,1349136000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1349136000,1349222400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1349222400,1349308800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID420MM/",1349308800,1349395200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID421MM/",1349395200,1349481600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID423MM/",1349481600,1349568000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID424MM/",1349568000,1349654400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID425MM/",1349654400,1349740800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID426MM/",1349740800,1349827200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID425MM/",1349827200,1349913600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID427MM/",1349913600,1350000000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID427MM/",1350000000,1350086400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID427MM/",1350086400,1350172800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID428MM/",1350172800,1350259200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID429MM/",1350259200,1350345600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID430MM/",1350345600,1350432000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID431MM/",1350432000,1350518400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID432MM/",1350518400,1350604800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID433MM/",1350604800,1350691200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID434MM/",1350691200,1350777600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID401MM/",1350777600,1350864000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID435MM/",1350864000,1350950400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID435MM/",1350950400,1351036800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID436MM/",1351036800,1351123200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID437MM/",1351123200,1351209600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID436MM/",1351209600,1351296000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID438MM/",1351296000,1351382400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID439MM/",1351382400,1351468800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID440MM/",1351468800,1351555200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID441MM/",1351555200,1351641600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID442MM/",1351641600,1351728000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID443MM/",1351728000,1351814400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID444MM/",1351814400,1351900800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID442MM/",1351900800,1351987200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID445MM/",1351987200,1352073600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID446MM/",1352073600,1352160000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID447MM/",1352160000,1352246400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID448MM/",1352246400,1352332800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID447MM/",1352332800,1353110400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID449MM/",1353110400,1353196800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID450MM/",1353196800,1353283200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID451MM/",1353283200,1353369600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID452MM/",1353369600,1353456000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID453MM/",1353456000,1353542400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID454MM/",1353542400,1353628800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID455MM/",1353628800,1353715200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID456MM/",1353715200,1353801600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID457MM/",1353801600,1353888000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID458MM/",1353888000,1353974400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID459MM/",1353974400,1354060800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID460MM/",1354060800,1354147200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID455MM/",1354147200,1354233600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID461MM/",1354233600,1354320000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID462MM/",1354320000,1354406400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID463MM/",1354406400,1354492800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID460MM/",1354492800,1354579200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID464MM/",1354579200,1354665600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID465MM/",1354665600,1354752000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID466MM/",1354752000,1354838400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID467MM/",1354838400,1354924800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID467MM/",1354924800,1355011200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID468MM/",1355011200,1355097600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID469MM/",1355097600,1355184000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID469MM/",1355184000,1355270400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID470MM/",1355270400,1355356800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID470MM/",1355356800,1355443200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID471MM/",1355443200,1355529600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID471MM/",1355529600,1355616000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID472MM/",1355616000,1355702400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID473MM/",1355702400,1355788800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID474MM/",1355788800,1355875200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1355875200,1355961600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1355961600,1356048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1356048000,1356134400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID476MM/",1356134400,1356220800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1356220800,1356307200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1356307200,1356393600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID475MM/",1356393600,1356480000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID477MM/",1356480000,1356566400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID478MM/",1356566400,1356652800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID479MM/",1356652800,1356739200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID480MM/",1356739200,1356825600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1356825600,1356912000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1356912000,1356998400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1356998400,1357084800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID482MM/",1357084800,1357171200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1357171200,1357257600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1357257600,1357344000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1357344000,1357430400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID482MM/",1357430400,1357516800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1357516800,1357603200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID481MM/",1357603200,1357689600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483MM/",1357689600,1357776000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID484MM/",1357776000,1357862400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483MM/",1357862400,1357948800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483MM/",1357948800,1358035200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID485MM/",1358035200,1358121600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID486MM/",1358121600,1358208000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483MM/",1358208000,1358294400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID483MM/",1358294400,1358380800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID487MM/",1358380800,1358467200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID488MM/",1358467200,1358553600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID488MM/",1358553600,1358640000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID489MM/",1358640000,1358726400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID490MM/",1358726400,1358812800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1358812800,1358899200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1358899200,1358985600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1358985600,1359072000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1359072000,1359158400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID493MM/",1359158400,1359244800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1359244800,1359331200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1359331200,1359417600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1359417600,1359504000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID492MM/",1359504000,1359590400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1359590400,1359676800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1359676800,1359763200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1359763200,1359849600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID494MM/",1359849600,1359936000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1359936000,1360022400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID491MM/",1360022400,1360108800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID482MM/",1360108800,1360195200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID495MM/",1360195200,1360281600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID495MM/",1360281600,1360368000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID495MM/",1360368000,1360454400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID495MM/",1360454400,1360540800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1360540800,1360627200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID497MM/",1360627200,1360713600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1360713600,1360800000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1360800000,1360886400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID499MM/",1360886400,1360972800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID500MM/",1360972800,1361059200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID500MM/",1361059200,1361145600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID501MM/",1361145600,1361232000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID502MM/",1361232000,1361318400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID502MM/",1361318400,1361404800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID503MM/",1361404800,1361491200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1361491200,1361577600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1361577600,1361664000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID504MM/",1361664000,1361750400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1361750400,1361836800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID505MM/",1361836800,1361923200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1361923200,1362009600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362009600,1362096000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1362096000,1362182400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362182400,1362268800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID506MM/",1362268800,1362355200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362355200,1362441600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362441600,1362528000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID507MM/",1362528000,1362614400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362614400,1362700800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1362700800,1362787200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID507MM/",1362787200,1362873600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID507MM/",1362873600,1362960000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1362960000,1363046400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID505MM/",1363046400,1363132800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID500MM/",1363132800,1363219200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID498MM/",1363219200,1363305600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID496MM/",1363305600,1363392000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID508MM/",1363392000,1363478400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID509MM/",1363478400,1363564800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID510MM/",1363564800,1363651200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID511MM/",1363651200,1363737600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID512MM/",1363737600,1363824000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID513MM/",1363824000,1363910400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID514MM/",1363910400,1363996800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID514MM/",1363996800,1364083200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID515MM/",1364083200,1364169600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID516MM/",1364169600,1364256000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID517MM/",1364256000,1364342400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID518MM/",1364342400,1364428800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID519MM/",1364428800,1364515200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID520MM/",1364515200,1364601600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID521MM/",1364601600,1364688000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID522MM/",1364688000,1364774400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID523MM/",1364774400,1364860800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID524MM/",1364860800,1364947200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1364947200,1365033600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1365033600,1365120000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1365120000,1365206400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID526MM/",1365206400,1365292800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID527MM/",1365292800,1365379200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID528MM/",1365379200,1365465600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID529MM/",1365465600,1365552000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID530MM/",1365552000,1365638400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID531MM/",1365638400,1365724800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID532MM/",1365724800,1365811200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID533MM/",1365811200,1365897600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID534MM/",1365897600,1365984000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID523MM/",1365984000,1366070400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1366070400,1366156800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID535MM/",1366156800,1366243200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID536MM/",1366243200,1366329600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID537MM/",1366329600,1366416000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1366416000,1366502400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1366502400,1366588800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID532MM/",1366588800,1366675200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID529MM/",1366675200,1366761600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID538MM/",1366761600,1366848000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1366848000,1366934400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539MM/",1366934400,1367020800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID540MM/",1367020800,1367107200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID525MM/",1367107200,1367193600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID524MM/",1367193600,1367280000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID541MM/",1367280000,1367366400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID542MM/",1367366400,1367452800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID543MM/",1367452800,1367539200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID544MM/",1367539200,1367625600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID545MM/",1367625600,1367712000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID546MM/",1367712000,1367798400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID547MM/",1367798400,1367884800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID548MM/",1367884800,1367971200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID549MM/",1367971200,1368057600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID550MM/",1368057600,1368144000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID551MM/",1368144000,1368230400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID552MM/",1368230400,1368316800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID553MM/",1368316800,1368403200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID554MM/",1368403200,1368489600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID550MM/",1368489600,1368576000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID555MM/",1368576000,1368662400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID556MM/",1368662400,1368748800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID556MM/",1368748800,1368835200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID557MM/",1368835200,1368921600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID558MM/",1368921600,1369008000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID559MM/",1369008000,1369094400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID560MM/",1369094400,1369180800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID561MM/",1369180800,1369267200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID557MM/",1369267200,1369353600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID550MM/",1369353600,1369440000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID562MM/",1369440000,1369526400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID563MM/",1369526400,1369612800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539MM/",1369612800,1369699200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID564MM/",1369699200,1369785600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID565MM/",1369785600,1369872000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID565MM/",1369872000,1369958400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID566MM/",1369958400,1370044800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID539MM/",1370044800,1370131200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID567MM/",1370131200,1370217600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID568MM/",1370217600,1370304000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID569MM/",1370304000,1370390400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID570MM/",1370390400,1370476800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID571MM/",1370476800,1370563200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID572MM/",1370563200,1370649600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID573MM/",1370649600,1370736000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID574MM/",1370736000,1370822400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID574MM/",1370822400,1370908800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID575MM/",1370908800,1370995200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID576MM/",1370995200,1371081600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID577MM/",1371081600,1371168000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID578MM/",1371168000,1371254400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID579MM/",1371254400,1371340800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID580MM/",1371340800,1371427200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID581MM/",1371427200,1371513600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID579MM/",1371513600,1371600000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID582MM/",1371600000,1371686400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID583MM/",1371686400,1371772800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID584MM/",1371772800,1371859200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID585MM/",1371859200,1371945600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID586MM/",1371945600,1372032000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID587MM/",1372032000,1372118400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID588MM/",1372118400,1372204800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID589MM/",1372204800,1372291200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID589MM/",1372291200,1372377600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID590MM/",1372377600,1372464000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID591MM/",1372464000,1372550400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID592MM/",1372550400,1372636800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID593MM/",1372636800,1372723200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID594MM/",1372723200,1372809600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID595MM/",1372809600,1372896000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID596MM/",1372896000,1372982400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID597MM/",1372982400,1373068800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID598MM/",1373068800,1373155200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID596MM/",1373155200,1373241600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID593MM/",1373241600,1373328000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID599MM/",1373328000,1373414400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID600MM/",1373414400,1373500800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID601MM/",1373500800,1373587200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID602MM/",1373587200,1373673600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID603MM/",1373673600,1373760000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID604MM/",1373760000,1373846400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID605MM/",1373846400,1373932800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID606MM/",1373932800,1374019200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID607MM/",1374019200,1374105600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608MM/",1374105600,1374192000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608MM/",1374192000,1374278400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID609MM/",1374278400,1374364800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID609MM/",1374364800,1374451200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID610MM/",1374451200,1374537600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID610MM/",1374537600,1374624000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611MM/",1374624000,1374710400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID611MM/",1374710400,1374796800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID612MM/",1374796800,1374883200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID612MM/",1374883200,1374969600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608MM/",1374969600,1375056000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID613MM/",1375056000,1375142400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID613MM/",1375142400,1375228800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID608MM/",1375228800,1375315200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID614MM/",1375315200,1375401600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID615MM/",1375401600,1375488000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID616MM/",1375488000,1375574400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID617MM/",1375574400,1375660800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID618MM/",1375660800,1375747200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID617MM/",1375747200,1375833600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID619MM/",1375833600,1375920000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID619MM/",1375920000,1376006400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID617MM/",1376006400,1376092800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID617MM/",1376092800,1376179200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID618MM/",1376179200,1376265600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID618MM/",1376265600,1376352000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID620MM/",1376352000,1376524800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID621MM/",1376524800,1376611200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID622MM/",1376611200,1376697600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID623MM/",1376697600,1376784000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID621MM/",1376784000,1376870400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID624MM/",1376870400,1376956800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID622MM/",1376956800,1377043200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID624MM/",1377043200,1377129600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID625MM/",1377129600,1377216000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID622MM/",1377216000,1377302400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID622MM/",1377302400,1377388800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID624MM/",1377388800,1377475200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID626MM/",1377475200,1377561600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID627MM/",1377561600,1377648000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID628MM/",1377648000,1377734400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID625MM/",1377734400,1377820800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID629MM/",1377820800,1377907200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID630MM/",1377907200,1377993600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID631MM/",1377993600,1378080000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID632MM/",1378080000,1378166400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID633MM/",1378166400,1378252800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID634MM/",1378252800,1378339200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID634MM/",1378339200,1378425600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID635MM/",1378425600,1378512000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID636MM/",1378512000,1378598400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID621MM/",1378598400,1378684800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID637MM/",1378684800,1378771200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID630MM/",1378771200,1378857600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID637MM/",1378857600,1378944000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID638MM/",1378944000,1379030400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID630MM/",1379030400,1379116800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID639MM/",1379116800,1379203200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID640MM/",1379203200,1379289600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID641MM/",1379289600,1379376000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID642MM/",1379376000,1379462400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID643MM/",1379462400,1379548800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID644MM/",1379548800,1379635200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID645MM/",1379635200,1379721600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID646MM/",1379721600,1379808000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID647MM/",1379808000,1379894400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID648MM/",1379894400,1379980800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID649MM/",1379980800,1380067200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID650MM/",1380067200,1380153600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID651MM/",1380153600,1380240000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID652MM/",1380240000,1380326400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID653MM/",1380326400,1380412800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID654MM/",1380412800,1380499200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID655MM/",1380499200,1380585600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID656MM/",1380585600,1380672000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID657MM/",1380672000,1380758400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID658MM/",1380758400,1380844800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1380844800,1381104000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID660MM/",1381104000,1381190400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID661MM/",1381190400,1381276800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381276800,1381363200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381363200,1381449600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381449600,1381536000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381536000,1381622400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381622400,1381708800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381708800,1381795200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1381795200,1381881600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID662MM/",1381881600,1381968000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID663MM/",1381968000,1382054400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID662MM/",1382054400,1382140800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID662MM/",1382140800,1382227200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1382227200,1382313600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID664MM/",1382313600,1382400000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1382400000,1382486400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID665MM/",1382486400,1382572800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID665MM/",1382572800,1382659200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID664MM/",1382659200,1382745600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID664MM/",1382745600,1382832000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1382832000,1382918400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1382918400,1383004800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID659MM/",1383004800,1383091200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID666MM/",1383091200,1383177600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667MM/",1383177600,1383264000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667MM/",1383264000,1383350400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID668MM/",1383350400,1383436800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667MM/",1383436800,1383523200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667MM/",1383523200,1383609600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID667MM/",1383609600,1383696000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID669MM/",1383696000,1383782400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID670MM/",1383782400,1383868800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID670MM/",1383868800,1383955200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID670MM/",1383955200,1384041600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID671MM/",1384041600,1384128000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID672MM/",1384128000,1384214400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID673MM/",1384214400,1384300800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID674MM/",1384300800,1384387200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID672MM/",1384387200,1384473600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID672MM/",1384473600,1384732800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID675MM/",1384732800,1384819200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID676MM/",1384819200,1384905600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID677MM/",1384905600,1384992000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID677MM/",1384992000,1385078400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID677MM/",1385078400,1385164800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID678MM/",1385164800,1385251200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID679MM/",1385251200,1385337600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID680MM/",1385337600,1385424000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID681MM/",1385424000,1385510400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID682MM/",1385510400,1385596800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID683MM/",1385596800,1385683200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684MM/",1385683200,1385769600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID685MM/",1385769600,1385856000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID686MM/",1385856000,1385942400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID687MM/",1385942400,1386028800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID688MM/",1386028800,1386115200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID689MM/",1386115200,1386201600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID690MM/",1386201600,1386288000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID691MM/",1386288000,1386374400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID692MM/",1386374400,1386460800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID693MM/",1386460800,1386547200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID694MM/",1386547200,1386633600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684MM/",1386633600,1386720000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID695MM/",1386720000,1386806400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID696MM/",1386806400,1386892800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID697MM/",1386892800,1386979200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID692MM/",1386979200,1387065600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID698MM/",1387065600,1387152000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684MM/",1387152000,1387238400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID684MM/",1387238400,1387324800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID699MM/",1387324800,1387411200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID700MM/",1387411200,1387497600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID701MM/",1387497600,1387584000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID702MM/",1387584000,1387670400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID703MM/",1387670400,1387756800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID703MM/",1387756800,1387843200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID703MM/",1387843200,1387929600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704MM/",1387929600,1388016000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704MM/",1388016000,1388102400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704MM/",1388102400,1388188800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704MM/",1388188800,1388275200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID704MM/",1388275200,1388361600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID703MM/",1388361600,1388448000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID705MM/",1388448000,1388620800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID706MM/",1388620800,1388707200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID707MM/",1388707200,1388793600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID708MM/",1388793600,1388880000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID709MM/",1388880000,1388966400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID708MM/",1388966400,1389052800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID708MM/",1389052800,1389139200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID710MM/",1389139200,1389225600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID711MM/",1389225600,1389312000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID709MM/",1389312000,1389398400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID712MM/",1389398400,1389484800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID708MM/",1389484800,1389571200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID713MM/",1389571200,1389657600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID714MM/",1389657600,1389744000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID715MM/",1389744000,1389830400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID716MM/",1389830400,1389916800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID714MM/",1389916800,1390003200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID714MM/",1390003200,1390089600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID716MM/",1390089600,1390176000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID717MM/",1390176000,1390262400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID718MM/",1390262400,1390348800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID719MM/",1390348800,1390435200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID719MM/",1390435200,1390521600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID720MM/",1390521600,1390608000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID719MM/",1390608000,1390694400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID719MM/",1390694400,1390780800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID721MM/",1390780800,1390867200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID722MM/",1390867200,1390953600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID723MM/",1390953600,1391040000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID723MM/",1391040000,1391126400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID724MM/",1391126400,1391212800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID725MM/",1391212800,1391299200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID725MM/",1391299200,1391385600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID723MM/",1391385600,1391472000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID726MM/",1391472000,1391558400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID726MM/",1391558400,1391644800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID727MM/",1391644800,1391731200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID726MM/",1391731200,1391817600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID728MM/",1391817600,1391904000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID729MM/",1391904000,1391990400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID730MM/",1391990400,1392076800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID731MM/",1392076800,1392163200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID729MM/",1392163200,1392249600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID732MM/",1392249600,1392336000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID733MM/",1392336000,1392422400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID734MM/",1392422400,1392508800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID733MM/",1392508800,1392595200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID735MM/",1392595200,1392681600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID733MM/",1392681600,1392768000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID736MM/",1392768000,1392854400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID737MM/",1392854400,1392940800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID736MM/",1392940800,1393027200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID736MM/",1393027200,1393113600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID738MM/",1393113600,1393200000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID739MM/",1393200000,1393286400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID740MM/",1393286400,1393372800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID741MM/",1393372800,1393459200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID741MM/",1393459200,1393545600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID741MM/",1393545600,1393632000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID741MM/",1393632000,1393718400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID742MM/",1393718400,1393804800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID743MM/",1393804800,1393891200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID742MM/",1393891200,1393977600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID742MM/",1393977600,1394064000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID742MM/",1394064000,1394150400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID742MM/",1394150400,1394236800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394236800,1394323200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394323200,1394409600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394409600,1394496000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394496000,1394582400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394582400,1394668800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394668800,1394755200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394755200,1394841600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394841600,1394928000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1394928000,1395014400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID745MM/",1395014400,1395100800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID746MM/",1395100800,1395187200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID746MM/",1395187200,1395273600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID746MM/",1395273600,1395360000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID746MM/",1395360000,1395446400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID747MM/",1395446400,1395532800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID748MM/",1395532800,1395705600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID749MM/",1395705600,1395792000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1395792000,1395878400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1395878400,1395964800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1395964800,1396051200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1396051200,1396137600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1396137600,1396224000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID750MM/",1396224000,1396310400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID751MM/",1396310400,1396396800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1396396800,1396483200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1396483200,1396569600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID744MM/",1396569600,1396656000,6,"trk mask",NULL);
-- MM mask set 2013-2014
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0MM2/",1396656000,1396742400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0MM2/",1396742400,1396828800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1396828800,1396915200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1396915200,1397001600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397001600,1397088000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397088000,1397174400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397174400,1397260800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397260800,1397347200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397347200,1397433600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397433600,1397520000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397520000,1397606400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID2MM2/",1397606400,1397692800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1MM2/",1397692800,1397779200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID2MM2/",1397779200,1397865600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3MM2/",1397865600,1397952000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4MM2/",1397952000,1398038400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4MM2/",1398038400,1398124800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4MM2/",1398124800,1398211200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID5MM2/",1398211200,1398297600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID6MM2/",1398297600,1398384000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID7MM2/",1398384000,1398470400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID8MM2/",1398470400,1398556800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID9MM2/",1398556800,1398643200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10MM2/",1398643200,1398729600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10MM2/",1398729600,1398816000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10MM2/",1398816000,1398902400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID11MM2/",1398902400,1398988800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1398988800,1399075200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399075200,1399161600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399161600,1399248000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399248000,1399334400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399334400,1399420800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13MM2/",1399420800,1399507200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID14MM2/",1399507200,1399593600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID15MM2/",1399593600,1399680000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13MM2/",1399680000,1399766400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399766400,1399852800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399852800,1399939200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1399939200,1400025600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1400025600,1400112000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12MM2/",1400112000,1400198400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16MM2/",1400198400,1400284800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID17MM2/",1400284800,1400371200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID18MM2/",1400371200,1400544000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID19MM2/",1400544000,1400630400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1400630400,1400716800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1400716800,1400803200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21MM2/",1400803200,1400889600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1400889600,1400976000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21MM2/",1400976000,1401062400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1401062400,1401148800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1401148800,1401235200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20MM2/",1401235200,1401321600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21MM2/",1401321600,1401408000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401408000,1401494400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401494400,1401580800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401580800,1401667200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401667200,1401753600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID23MM2/",1401753600,1401840000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401840000,1401926400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1401926400,1402012800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402012800,1402099200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402099200,1402185600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402185600,1402272000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402272000,1402358400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402358400,1402444800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402444800,1402531200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24MM2/",1402531200,1402617600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25MM2/",1402617600,1402704000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22MM2/",1402704000,1402790400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID26MM2/",1402790400,1402876800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25MM2/",1402876800,1402963200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID27MM2/",1402963200,1403049600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID27MM2/",1403049600,1403136000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID28MM2/",1403136000,1403222400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29MM2/",1403222400,1403308800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID30MM2/",1403308800,1403395200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31MM2/",1403395200,1403481600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29MM2/",1403481600,1403568000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29MM2/",1403568000,1403827200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID32MM2/",1403827200,1403913600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID33MM2/",1403913600,1404000000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID34MM2/",1404000000,1404086400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID35MM2/",1404086400,1404172800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID36MM2/",1404172800,1404259200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID37MM2/",1404259200,1404345600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38MM2/",1404345600,1404432000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID39MM2/",1404432000,1404518400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID39MM2/",1404518400,1404604800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID40MM2/",1404604800,1404691200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID35MM2/",1404691200,1404777600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID41MM2/",1404777600,1404864000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID42MM2/",1404864000,1404950400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43MM2/",1404950400,1405036800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44MM2/",1405036800,1405123200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45MM2/",1405123200,1405209600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46MM2/",1405209600,1405296000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM2/",1405296000,1405382400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM2/",1405382400,1405468800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM2/",1405468800,1405555200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM2/",1405555200,1405641600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID48MM2/",1405641600,1405728000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID48MM2/",1405728000,1405814400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47MM2/",1405814400,1405900800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1405900800,1405987200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50MM2/",1405987200,1406073600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1406073600,1406160000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1406160000,1406246400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1406246400,1406332800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1406332800,1406419200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49MM2/",1406419200,1406505600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID51MM2/",1406505600,1406592000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID51MM2/",1406592000,1406678400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID52MM2/",1406678400,1406764800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID53MM2/",1406764800,1406851200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID54MM2/",1406851200,1406937600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID55MM2/",1406937600,1407024000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID56MM2/",1407024000,1407110400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57MM2/",1407110400,1407196800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID58MM2/",1407196800,1407283200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID59MM2/",1407283200,1407369600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57MM2/",1407369600,1407456000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57MM2/",1407456000,1407542400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57MM2/",1407542400,1407628800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID60MM2/",1407628800,1407715200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61MM2/",1407715200,1407801600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62MM2/",1407801600,1407888000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62MM2/",1407888000,1407974400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62MM2/",1407974400,1408060800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID63MM2/",1408060800,1408147200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID64MM2/",1408147200,1408233600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID65MM2/",1408233600,1408406400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID66MM2/",1408406400,1408492800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID67MM2/",1408492800,1408579200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID68MM2/",1408579200,1408665600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID69MM2/",1408665600,1408752000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID70MM2/",1408752000,1408838400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID71MM2/",1408838400,1408924800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID71MM2/",1408924800,1409011200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID72MM2/",1409011200,1409097600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID73MM2/",1409097600,1409184000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID72MM2/",1409184000,1409270400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID74MM2/",1409270400,1409356800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID75MM2/",1409356800,1409443200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID76MM2/",1409443200,1409529600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77MM2/",1409529600,1409616000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77MM2/",1409616000,1409702400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78MM2/",1409702400,1409788800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79MM2/",1409788800,1409875200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79MM2/",1409875200,1409961600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79MM2/",1409961600,1410048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79MM2/",1410048000,1410134400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID80MM2/",1410134400,1410220800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID81MM2/",1410220800,1410307200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID82MM2/",1410307200,1410393600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83MM2/",1410393600,1410480000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83MM2/",1410480000,1410566400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83MM2/",1410566400,1410652800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83MM2/",1410652800,1410739200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1410739200,1410825600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1410825600,1410912000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1410912000,1410998400,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1410998400,1411084800,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1411084800,1411171200,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1411171200,1411257600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84MM2/",1411257600,1411344000,6,"trk mask",NULL);
-- mask_param-1 == no masking // UPDATE: use conservative mask calculated by Emiliano looking at quicklook plots.
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0E/",   1411344000,4294967295,6,"trk mask",NULL);
-- 
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","default_calib/",0,0,7,"default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP-dws2000.dat",1,1,101,"Calorimeter ADC to MIP from flight data dw serie 2000",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP.dat",1,1,101,"Calorimeter ADC to MIP from ground data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIPfc.dat",2,4294967295,101,"Calorimeter ADC to MIP from flight, relativistic particles",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special0.dat",1,1172976488,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special1.dat",1172976488,1190000000,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special2.dat",1190000000,1345420800,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special3.dat",1345420801,4294967295,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign.dat",1,1,102,"Calorimeter alignement",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flight.dat",1,1,102,"Calorimeter alignement with flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightEMS.dat",1,1,102,"Calorimeter alignement with flight data EM showers",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightINCp.dat",2,4294967295,102,"Calorimeter alignement with flight data, protons, Z alignment changed",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask.dat",1,1,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask18Xgood.dat",2,4294967295,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloDefaultCalib.root",1,1345420800,104,"Calorimeter default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloDefaultCalib1.root",1345420801,4294967295,104,"Calorimeter default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre0.dat",1,1169000000,105," <0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre1.dat",1169000001,4294967295,105," >0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_pre_neighbour.dat",1,1345420800,106," Calorimeter pre-amply neighbour correction table",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_pre_neighbour1.dat",1345420801,4294967295,106," Calorimeter pre-amply neighbour correction table",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_pre_IIneighbour.dat",1,4294967295,107," Calorimeter pre-amply second neighbour correction table",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_si0.dat",1,1167619688,108,"Calorimeter cross-talk silicon effect",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_si1.dat",1167619689,4294967295,108,"Calorimeter cross-talk silicon effect",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_maxrms_plane0.dat",1,1345420800,109,"Calorimeter 4*rms threshold for each plane (default 26)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_maxrms_plane1.dat",1345420801,4294967295,109,"Calorimeter 4*rms threshold for each plane (default 26)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_emin_strip0.dat",1,1167619688,111,"Calorimeter Emin threshold for each strip (default 0.7)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_emin_strip1.dat",1167619689,1345420800,111,"Calorimeter Emin threshold for each strip (default 0.7)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_emin_strip2.dat",1345420801,4294967295,111,"Calorimeter Emin threshold for each strip (default 0.7), new values for 18X",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_1.rz",1,1153660000,201," 0 - 07-23      -                       A       A       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_2.rz",1153660001,1154375000,201," 07-23 - 07-31   HV_D problems           B       B       july            Parameters_jul24-31.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_3.rz",1154375001,1155850000,201," 07-31 - 08-17   -                       C       C       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_4.rz",1155850001,1156280000,201," 08-17 - 08-22   HV_H&HV_N problems      D       D       august          Parameters_aug18-22.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_5.rz",1156280001,1158700000,201," 08-22 - 09-18  S115B failure	          E       E       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_5B.rz",1158700001,1165400000,201," 09-18 - 12-06                           5B       5B       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_6.rz",1165400001,1168490000,201," 12-06 - 01-11   December Tracker off/on F       F       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_7.rz",1168490001,1168940000,201," 01-11 - 01-16   HV_D problems           G       G       january         calper02.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_8.rz",1168940001,1169580000,201," 01-16 - 01-23   HV_F & HV_M problems    G       G       january         calper03.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_9.rz",1169580001,1170200000,201," 01-23 - 01-30                           H       H       .               calper04.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_10.rz",1170200001,1171000000,201," 01-30 - 02-09   30.1. Threshold changed I       I       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_11.rz",1171000001,1174665000,201," 02-09 - 03-23   09.2. Threshold changed J       J       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_12.rz",1174665001,1175000000,201," 03-23 - 03-27   HV_B problems           K       K       .               calper05.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_13.rz",1175000001,1176120000,201," 03-27 - 04-09                           L       L       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_14.rz",1176120001,1176800000,201," 04-09 - 04-17   HV_H problems           M       M       .               calper06.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_15.rz",1176800001,1178330000,201," 04-17 - 05-05   HV_E problems           N       N       .               calper08.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_16.rz",1178330001,1181322000,201," 05-05 - 06-08   HV_H problems           O       O       .               calper09.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_17.rz",1181322001,1182100000,201," 06-08 - 06-17                           P       P       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_18.rz",1182100001,1183030000,201," 06-17 - 06-28   HV_A problems (~2 days) Q       Q       ?",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_19.rz",1183030001,1184000000,201," 06-28 - 07-09                           R       R       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_20.rz",1184000001,1184570000,201," 07-09 - 07-16   HV_H problems           S       S       .               calper10.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_21.rz",1184570001,1185090000,201," 07-16 - 07-22                           T       T       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_22.rz",1185090001,1185212000,201," 07-22 - 07-23   HV_D problems           U       U       .               calper11.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_23.rz",1185212001,1191100000,201," 07-23 - 09-29                           V       V       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_24.rz",1191100001,1191940000,201," 09-23 - 10-09   HV_D problems          24      24       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_25.rz",1191940001,1195200000,201," 10-09 - 11-16                          25      25      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_26.rz",1195200001,1196230000,201," 11-16 - 11-28   Timing changes         26      26      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_27.rz",1196230001,1196280000,201," 11-28 - 11-28   HV_D problems          27      27      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_28.rz",1196280001,1206100000,201," 11-29 - 03-21                          28      28      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_29.rz",1206100001,1206375600,201," 03-21 - 03-24   HV_C problems          29      29 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_30.rz",1206375601,1217989200,201," 03-24 - 08-06   good                    30      30      calper_30 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_31.rz",1217989201,1218550000,201," 08-06 - 08-12   HV_E problems ?         31      31      calper_31",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_32.rz",1218550001,1225789200,201," 08-12 - 11-04   good                    32      32      calper_32",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_33.rz",1225789201,1226566800,201," 11-04 - 11-13   HV_E problems ?         33      33      calper_33 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_34.rz",1226566801,1229400000,201," 11-13 - 12-16   good                    34      34      calper_34",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_35.rz",1229400001,1229470000,201," 12-16 - 12-17   HV_F probl. + HV_E (?)  35      35      calper_35",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_36.rz",1229470001,1229730000,201," 12-17 - 12-19   HV_E problems (?)       36      36      calper_36",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_37.rz",1229730001,1230318000,201," 12-19 - 12-26   good                    37      37      calper_37",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_38.rz",1230318001,1230410000,201," 12-26 - 12-27   HV_H problems           38      38      calper_38",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_39.rz",1230410001,1230768000,201," 12-27 - 12-31   good                    39      39      calper_39",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_41.rz",1230768001,1232496000,201," 09-01-01 09-01-20         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_42.rz",1232496001,1235347200,201," 09-01-21 09-02-22         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_43.rz",1235347201,1238544000,201," 09-02-23 09-03-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_44.rz",1238544001,1241136000,201," 09-04-01 09-04-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_45.rz",1241136001,1243814400,201," 09-05-01 09-05-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_46.rz",1243814401,1246406400,201," 09-06-01 09-06-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_47.rz",1246406401,1249084800,201," 09-07-01 09-07-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_48.rz",1249084801,1251763200,201," 09-08-01 09-08-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_49.rz",1251763201,1254355200,201," 09-09-01 09-09-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_50.rz",1254355201,1257033600,201," 09-10-01 09-10-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_51.rz",1257033601,1259625600,201," 09-11-01 09-11-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_52.rz",1259625601,1262304000,201," 09-12-01 09-12-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_53.rz",1262304001,1264464000,201," 10-01-01 10-01-26         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_54.rz",1264464001,1277935200,201," 10-01-26 10-06-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_55.rz",1277935201,1293836400,201," 10-06-30 10-12-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_56.rz",1293836401,1304200800,201," 11-01-01 11-04-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_57.rz",1304200801,1314828000,201," 11-05-01 11-08-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_58.rz",1314828001,1320700000,201," 11-09-01 11-11-07         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_59.rz",1320700001,1322020000,201," 11-11-07 11-11-23 HV_D problems",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_60.rz",1322020001,1325372400,201," 11-11-23 11-12-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_61.rz",1325372401,1335823200,201," 12-01-01 12-04-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_62.rz",1335823201,1346450400,201," 12-05-01 12-08-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_63.rz",1346450401,1356994800,201," 12-08-31 12-12-31         good",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_64.rz",1356994801,4294967295,201," >13-01-01                 good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_64.rz",1356994801,1372629600,201," 13-01-01 13-06-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_65.rz",1372629601,1384700000,201," 13-06-30 13-11-17         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_66.rz",1384700001,1387400000,201," 13-11-17 13-12-08 HV_H problems",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_67.rz",1387400001,1388530800,201," 13-12-08 13-12-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_68.rz",1388530801,1404172800,201," 13-12-31 14-06-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_69.rz",1404172801,4294967295,201," >14-06-30                 good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","ToFCalibParam.txt",1,4294967295,202," GP ToF parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","adcmonitor.100k.cut.dat",1,1,203," ToF dE/dx II order correction parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.C.5d.8th.all.dat",1,1,203," ToF dE/dx II order correction parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.He.8th.all.dat",1,1,203," ToF dE/dx II order correction parameters based on He",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.He.9th.all.dat",1,1,203," ToF dE/dx II order correction parameters based on He 9th data reduction",NULL);
-- Rita param
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","calibfile_tofdedx_x10thred.txt",1,1,203," ToF dE/dx II order correction parameters - Rita",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","biscale_tofdedx_x10thred.txt",1,1364790400,203," ToF dE/dx II order correction parameters - Rita",NULL);
-- EM param
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","biscale_tofdedx_x10thred_corrected2014.txt",1364790400,4294967295,203," ToF dE/dx II order correction parameters - EM",NULL);
--
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_1.dat",1,1150848001,204," ToF attenuation parameter file period 1 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_2.dat",1150848000,1154995201,204," ToF attenuation parameter file period 2 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_3.dat",1154995200,1158019201,204," ToF attenuation parameter file period 3 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_4.dat",1158019200,1161216001,204," ToF attenuation parameter file period 4 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_5.dat",1161216000,1164499201,204," ToF attenuation parameter file period 5 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_6.dat",1164499200,1167955201,204," ToF attenuation parameter file period 6 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_7.dat",1167955200,1171670401,204," ToF attenuation parameter file period 7 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_8.dat",1171670400,1175472001,204," ToF attenuation parameter file period 8 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_9.dat",1175472000,1179446401,204," ToF attenuation parameter file period 9 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_10.dat",1179446400,1184284801,204," ToF attenuation parameter file period 10 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_11.dat",1184284800,1188691201,204," ToF attenuation parameter file period 11 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_12.dat",1188691200,1193356801,204," ToF attenuation parameter file period 12 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_13.dat",1193356800,1198195201,204," ToF attenuation parameter file period 13 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_14.dat",1198195200,1203292801,204," ToF attenuation parameter file period 14 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_15.dat",1203292800,1208822401,204," ToF attenuation parameter file period 15 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_16.dat",1208822400,1214524801,204," ToF attenuation parameter file period 16 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_17.dat",1214524800,1220659201,204," ToF attenuation parameter file period 17 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_18.dat",1220659200,1228953601,204," ToF attenuation parameter file period 18 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_19.dat",1228953600,1237593601,204," ToF attenuation parameter file period 19 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_20.dat",1237593600,1244592001,204," ToF attenuation parameter file period 20 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_21.dat",1244592000,1252108801,204," ToF attenuation parameter file period 21 ",NULL);
-- Rita param:
-- insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_22.dat",1252108800,4294967295,204," ToF attenuation parameter file period 22 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_21r.dat",1252108800,1260230401,204," ToF attenuation parameter file period 21 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_22r.dat",1260230400,1268352001,204," ToF attenuation parameter file period 22 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_23r.dat",1268352000,1291161601,204," ToF attenuation parameter file period 23 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_24r.dat",1291161600,1300233601,204," ToF attenuation parameter file period 24 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_25r.dat",1300233600,1309737601,204," ToF attenuation parameter file period 25 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_26r.dat",1309737600,1324771201,204," ToF attenuation parameter file period 26 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_27r.dat",1324771200,1337731201,204," ToF attenuation parameter file period 27 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_28r.dat",1337731200,1350691201,204," ToF attenuation parameter file period 28 Rita ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_29r.dat",1350691200,1364774401,204," ToF attenuation parameter file period 29 Rita ",NULL);
-- EM param:
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_30e.dat",1364774400,1383177601,204," ToF attenuation parameter file period 30 EM ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_31e.dat",1383177600,1398816001,204," ToF attenuation parameter file period 31 EM ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","atten_period_32e.dat",1398816000,4294967295,204," ToF attenuation parameter file period 32 EM ",NULL);
--
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","attenuation.txt",1,1,204," ToF attenuation parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","desaturation_position.txt",1,4294967295,205," ToF desaturation on position parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","BetheBloch.txt",1,4294967295,206," ToF BetheBloch parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","BetheBloch_betagt1.txt",1,4294967295,207," ToF Bethe-Bloch parameter file for beta gt1 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","desaturation_beta.txt",1,4294967295,208," ToF desaturation on beta parameter file ",NULL);
insert into GL_PARAM values(0,"","",1182100001,1183030000,210," A connector ",NULL);
insert into GL_PARAM values(0,"","",1174665001,1175000000,211," B connector ",NULL);
insert into GL_PARAM values(0,"","",1206100001,1206375600,212," C connector ",NULL);
insert into GL_PARAM values(0,"","",1153660001,1154375000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1168490001,1168940000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1185090001,1185212000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1191100001,1191940000,213," D connector ",NULL);
-- Rita new:
insert into GL_PARAM values(0,"","",1320710401,1322006400,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1176800001,1178330000,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1217989201,1218547800,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1225789201,1226566800,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1229400901,1229700000,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1230318001,1230415200,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1168940001,1169580000,215," F connector ",NULL);
insert into GL_PARAM values(0,"","",1155850001,1156280000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1176120001,1176800000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1178330001,1181322000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1184000001,1184570000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1196230001,1196280000,217," H connector ",NULL);
-- Rita new:
insert into GL_PARAM values(0,"","",1309910401,1310083200,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1168940001,1169580000,220," M connector ",NULL);
insert into GL_PARAM values(0,"","",1155850001,1156280000,221," N connector ",NULL);
-- WM new:
insert into GL_PARAM values(0,"","",1384700001,1387400000,217," H connector ",NULL);
-- 10RED bug: all IGRF parameters updataed, no need for 301 and 304 types anymore
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf00.dat",1,1104537600,301,"igrf 2000",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05.dat",1104537601,1264400000,301,"igrf 2005",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf10.dat",1264400001,4294967295,301,"igrf 2010",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf00.dat",1,946684800,302,"igrf 2000 for interpolations",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05.dat",946684801,1104537600,302,"igrf 2005 for interpolations",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf10.dat",1104537601,1264400000,302,"igrf 2010 for interpolations",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf10s.dat",1264400001,4294967295,302,"igrf 2015 estimated",NULL);
-- insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","IGRF.tab",0,0,304,"11th Generation International Geomagnetic Reference Field Schmidt semi-normalised spherical harmonic coefficients",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf12_d05.txt",1104537600,1262304000,302,"IGRF12 - dgrf2005 from 2005 to 2010",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf12_d10.txt",1262304000,1420070400,302,"IGRF12 - dgrf2010 from 2010 to 2015",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf12_i15.txt",1420070400,1577836800,302,"IGRF12 - igrf2015 from 2015 to 2020",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf12_i15s.txt",1577836800,4294967295,302,"IGRF12 - igrf2015s secular variation",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","SortQuat.txt",0,0,303,"Quaternion from Resurs",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","RDBCC.txt",0,0,305,"Resurs-DK1 rotations table",NULL);

CREATE TABLE `GL_TLE` (
  `ID` int(10) NOT NULL auto_increment,
  `TLE1` varchar(255) NOT NULL default '',
  `TLE2` varchar(255) NOT NULL default '',
  `TLE3` varchar(255) NOT NULL default '',
  `FROM_TIME` datetime NOT NULL default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ;

CREATE TABLE `GL_RUN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `ID_ROOT_L2_index` (`ID_ROOT_L2`),
  KEY `COMPILATIONTS_index` (`COMPILATIONTIMESTAMP`),
  KEY `VALID_index` (`VALIDATION`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `CALDSPMASK_index` (`CAL_DSP_MASK`),
  KEY `EFF_WS_index` (`EFF_WRK_SCHEDULE`),
  KEY `FAV_WS_index` (`FAV_WRK_SCHEDULE`),
  KEY `RM_ACQ_AFTER_CALIB_index` (`RM_ACQ_AFTER_CALIB`),
  KEY `RM_ACQ_SETTING_MODE_index` (`RM_ACQ_SETTING_MODE`),
  KEY `ACQ_VAR_INFO_index` (`ACQ_VAR_INFO`),
  KEY `TRG_MODE_A_index` (`PRH_VAR_TRG_MODE_A`),
  KEY `TRG_MODE_B_index` (`PRH_VAR_TRG_MODE_B`),
  KEY `NEVENTS_index` (`NEVENTS`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `ID_RUN_fk_constraint` (`ID_ROOT_L0`),
  KEY `ID_RUN_L2_fk_constraint` (`ID_ROOT_L2`)
) ;

CREATE TABLE `GL_RUN_FRAGMENTS` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `NID_RUN_fk_constraint` (`ID_ROOT_L0`)
) ;

CREATE TABLE `GL_RUN_TRASH` (
  `ID_TRASH` int(10) unsigned NOT NULL auto_increment,
  `ID` int(10) unsigned NOT NULL default '0',
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `FILENAMEL0` varchar(255) NOT NULL default '',
  `FILENAMEL2` varchar(255) NOT NULL default '',
  `BELONGED_TO` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_TRASH`),
  KEY `TID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `TID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `TBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TTRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `TFNAME0_index` (`FILENAMEL0`),
  KEY `TFNAME2_index` (`FILENAMEL2`),
  KEY `TBELONG_index` (`BELONGED_TO`)
) ;

CREATE TABLE `GL_CALO_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `SECTION_index` (`SECTION`),
  KEY `EV_ROOT_index` (`EV_ROOT`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID1_index` (`VALIDATION`)
) ;

CREATE TABLE `GL_CALOPULSE_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `PULSED_STRIP` tinyint(3) unsigned default NULL,
  `PULSE_AMPLITUDE` tinyint(3) unsigned default NULL,
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `PSECTION_index` (`SECTION`),
  KEY `PULSEDSTRIP_index` (`PULSED_STRIP`),
  KEY `PULSEAMPL_index` (`PULSE_AMPLITUDE`),
  KEY `PEV_ROOT_index` (`EV_ROOT`),
  KEY `PID_ROOT_index` (`ID_ROOT_L0`),
  KEY `PBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PVALID1_index` (`VALIDATION`)
) ;


CREATE TABLE `GL_TRK_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT_CALIBTRK1` int(10) unsigned default NULL,
  `EV_ROOT_CALIBTRK2` int(10) unsigned default NULL,
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT1` int(10) unsigned NOT NULL default '0',
  `PKT1` int(10) unsigned NOT NULL default '0',
  `OBT2` int(10) unsigned NOT NULL default '0',
  `PKT2` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `EV_ROOT_CALIBTRK1index` (`EV_ROOT_CALIBTRK1`),
  KEY `EV_ROOT_CALIBTRK2index` (`EV_ROOT_CALIBTRK2`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID2_index` (`VALIDATION`)
) ;

CREATE TABLE `GL_S4_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',  
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`)
) ;


drop table if exists dbname.ROOT_TABLE ;

CREATE TABLE `dbname`.`ROOT_TABLE` (
  `ID_N`  int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID (SERIAL)',
  `FOLDER_NAME` varchar(255)  default '.'  COMMENT 'It is the folder containing the ROOT files', 
  `FILE_NAME` varchar(255) NOT NULL  default 'yoda_nnnnn_mmm_ppp_0' COMMENT 'It is the ROOT filename.',
  `PKT_NUMBER_INIT` int unsigned NOT NULL default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet (ms)',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet (ms)',
  `OBT_TIME_SYNC` int unsigned  default '0' COMMENT 'The TIMESYNC used to compute the real time (s)',
  `LAST_TIME_SYNC_INFO` int unsigned  default '0' COMMENT 'The LAST SYNC used to compute the real time (s)',
  `REAL_TIME_INIT` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the first packet (s)', 
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the last packet (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	
  `TIME_OFFSET` int unsigned default '0' COMMENT 'The time offset used (s)',	
  `BAD_PKT` int  default '0' COMMENT 'The number of packet that could have problems. Due to the fact that one or more cadres did not pass the vrl check.',
  `BAD_PKT_READ` int  default '0' COMMENT 'The number of packet that could have problems. In general CRC errors detected in the Packet Reader part',
  `BAD_PKT_CALREAD` int  default '0' COMMENT 'The number of Calibration packet that could have problems.',
  `NUM_PKT_SAVED` int  default '0' COMMENT 'The total number of packet saved in the ROOT file',
  `INPUT_NAME` varchar(255) default './nnnnmmm.pam' COMMENT 'It is the filename of the input file',  
  `TIME_IS_ESTIMATED` tinyint(1) unsigned NOT NULL default '0' COMMENT 'No timesync was found for this entry, we use a timesync from the same download',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP, 
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `ON_DISK` varchar(3) NOT NULL default 'YES' COMMENT 'The file is on disk (no deleted)',
 PRIMARY KEY  (`ID_N`)
) 
;

drop table if exists dbname.ROOT_TABLE_BAD ;
CREATE TABLE `dbname`.`ROOT_TABLE_BAD` (
  `ID_N` int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID',
  `FOLDER_NAME` varchar(255) default '.'  COMMENT 'It is the folder containing the ROOT files', 
  `FILE_NAME` varchar(255) NOT NULL  default 'yoda_nnnnn_mmm_ppp_0' COMMENT 'It is the ROOT filename.',
  `PKT_NUMBER_INIT` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet ',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet ',
  `OBT_TIME_SYNC` int unsigned  default '0' COMMENT 'The TIMESYNC used to compute the real time',
  `LAST_TIME_SYNC_INFO` int unsigned default '0' COMMENT 'The LAST SYNC used to compute the real time',
  `REAL_TIME_INIT` int unsigned  NOT NULL default '0' COMMENT 'The Absolute real time of the first packet',
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the last packet (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	 
  `TIME_OFFSET` int unsigned  default '0' COMMENT 'The time offset us	ed (s)',	
  `BAD_PKT` int  default '0' COMMENT 'The number of packet that could have problems. Due to the fact that one or more cadres did not pass the vrl check.',
  `BAD_PKT_READ` int  default '0' COMMENT 'The number of packet that could have problems. In general CRC errors detected in the EventReader part',
  `BAD_PKT_CALREAD` int  default '0' COMMENT 'The number of Calibration packet that could have problems.',
  `NUM_PKT_SAVED` int  default '0' COMMENT 'The number of packet saved in the ROOT file',
  `INPUT_NAME` varchar(255) default './nnnnmmm.pam' COMMENT 'It is the filename of the input file',  
  `TIME_IS_ESTIMATED` tinyint(1) unsigned NOT NULL default '0' COMMENT 'No timesync was found for this entry, we use a timesync from the same download',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP, 
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `ON_DISK` varchar(3) NOT NULL default 'YES' COMMENT 'The file is on disk (no deleted)',
  PRIMARY KEY  (`ID_N`)
) 
;

drop table if exists dbname.ROOT_TABLE_MERGING ;
CREATE TABLE `dbname`.`ROOT_TABLE_MERGING` (
  `ID_N` int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID',
  `ROOT_ID_N` int unsigned NOT NULL  COMMENT 'It is the ID of the ROOT file in table ROOT_TABLE',
  `PKT_NUMBER_INIT` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet ',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet ',
  `REAL_TIME_INIT` int unsigned  NOT NULL default '0' COMMENT 'The Absolute real time from where I want to start',
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time when I want to stop using this ROOT file (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	
  `BAD_PKT_PERCENTAGE` double  default '0' COMMENT 'The percentage of bad packets',
  `GOOD` tinyint(1) unsigned NOT NULL default '1' COMMENT 'The entry must be used if and only if GOOD=1',
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_N`)
) 
; 

