//============================================================================
// $Id: Logger.h,v 1.1.1.1 2008-09-23 07:20:11 mocchiut Exp $ 
// Description : 
//============================================================================
#ifndef LOGGER_H_
#define LOGGER_H_

#include <string>
#include <fstream>
#include <sstream>

namespace PamOffLineSW{

class LogUtil{
public:
		enum logLevel{
			LOGERROR=0,
			LOGWARN,
			LOGINFO,
			LOGALL
		};
	LogUtil(std::string& filename, logLevel level);
	LogUtil(std::string& filename);
	LogUtil(const char* filename,logLevel level);
	LogUtil(const char* filename);
	void setLoglevel(logLevel level);
	std::string& getLogFileName();
	void logError(std::string& msg);
	void logWarning(std::string& msg);
	void logInfo(std::string& msg);
	void logAll(std::string& msg);	

	void logAlways(std::string& msg);
	void logAlways(const char* msg);
	void logError(const char* msg);
	void logWarning(const char* msg);
	void logInfo(const char* msg);
	void logAll(const char* msg);

	void appendLog(const char* msg){mtempstring+=msg;};
	void flushLog(logLevel level){
		if(level == LOGERROR) logError(mtempstring);
		if(level == LOGWARN) logError(mtempstring);
		if(level == LOGINFO) logError(mtempstring);
		mtempstring+"";
		};
	~LogUtil();
	template <class T>
	std::string value2string(T& val)
	{
		std::ostringstream os;
		os << val;
		return os.str();
	}
private:
	std::string mFilename;
	std::ofstream mOutStream;
	std::string mtempstring;
	logLevel mLevel;
};

class Logger{
public:
	Logger();
	Logger(bool autoflush);	//currently not used
	~Logger();
	bool setLogFile(std::string& fileName);
	bool setLogFile(char* fileName);
	std::string& getLogFileName();
	
	//TODO: this need to be checked
	template <class T> 
	bool logValue(T& val)
	{
		mOutStream << val;
	    return checkOutFileStreamError(Logger::LOG_MSG_OPERATION);
	}
	
	bool logENDL();
	bool logMsg(std::string&);
	bool logMsg(char* charstar, int lenght);
	bool logMsg(char* charstar, long int lenght);
	//If the charstar buffer is null terminated
	bool logMsg(char* charstar_nullterminated);

	bool close();
	std::ofstream& getOutStream();
	//void setToBeflushedMemorySize(long charCountSize);
private:
	bool checkOutFileStreamError(int operationKind,std::string& optionalMsg);
	bool checkOutFileStreamError(int operationKind);
	std::string mFileName;
	std::string mDummyOptionalMsg;
	std::string mBlankString;
	std::string mUnableToOpenFileMsg;
	std::string mUnableToLogMsg;
	std::string mToFileMsg;
	std::string mUnableToCloseMsg;
	std::string mFileMsg;
	std::ofstream mOutStream;
	bool mAutoFlush;//currently not used. it is here for future improvements, if any
	static const int OPEN_FILE_OPERATION;
	static const int LOG_MSG_OPERATION;
	static const int CLOSE_FILE_OPERATION;
	void initStringMsg();
};
}

#endif /*LOGGER_H_*/
