//
// CaloADC2MIP.cc -- standalone program to call the CaloADC2MIP macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <caloclasses.h>
#include <iostream>
// void CaloADC2MIP(TString Filename, TString calcalibfile = "", TString flist="")
extern void CaloADC2MIP(TString, TString ,TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString calname;
  TString list;
  if ( numinp < 4 ){
    if ( numinp == 2 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
	printf("\nUsage:\n\n CaloADC2MIP file calibration_file list \n");
	printf("\n - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf("\n                       or /path/to/filesfromyoda/ if a file list is given \n");
	printf("\n - calibration_file    must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf("\n - list                text file containing a list of files \n");
	printf("\n                       in the form: dw_000000_00000 <new line> dw_000000_00000 ... \n");
	printf("\nExample: \n\nCaloADC2MIP /home/pamela/filesfromyoda/dw_050301_00100/ \"\" \"\" \n\n");
	return(0);
      };
      printf(" Try with --help or -h \n");
      return(0);
    };
    if ( numinp == 1 ){
      printf("\n Welcome to CaloADC2MIP! \n");
      //
      printf("\n You must provide the following input parameters: \n\n");
      //
      char input[256];
      //
      printf(" Path to YODA unpacked directory or to the FilesFromYoda: \n ");
      cin.getline(input,256);
      name = (TString)input;
      printf(" Path to YODA unpacked directory for a calorimeter calibration: \n ");
      cin.getline(input,256);
      calname = (TString)input;
      printf(" Filename of the list of files (if any): \n ");
      cin.getline(input,256);
      list = (TString)input;
    };
  } else {
    printf("\n Welcome to CaloADC2MIP! \n");
    name = (TString)inps[1];
    calname = (TString)inps[2];
    list = (TString)inps[3];
  };
  //
  CaloADC2MIP(name,calname,list);
  //
  return(0);
}
