//
// CaloPULSE.cc -- standalone program to call the CaloPLANES macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/07)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <caloclasses.h>
#include <iostream>
extern void CaloPULSEMATRA(TString, TString, int, TString);
extern void CaloPULSE(TString, TString, int, TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString program;
  TString name;
  TString outdir;
  TString figty;
  int sflag;
  if ( numinp != 5 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n CaloPULSE program file outDir save_flag figformat \n");
    printf("\n - program             can be PULSE or MATRA \n");
    printf(  " - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - outDir              directory where to save figures\n");
    printf(  " - save_flag           when 0 does not save figures, when 1 saves figures\n");
    printf(  " - figformat           format to save figures (eps,ps,root,...) \n");
    printf("\nExample: \n\nCaloPULSE PULSE /home/pamela/filesfromyoda/dw_050301_00100/ 1 /home/pamela/ ps \n\n");
    return(0);
    //
  } else {
    printf("\n Welcome to CaloPULSE! \n");
    program = (TString)inps[1];
    name = (TString)inps[2];
    outdir = (TString)inps[3];
    sflag = atoi(inps[4]);
    figty = (TString)inps[5];
  };
  //
  if ( !strcmp(program.Data(),"PULSE") ){
    printf("\n Calling CaloPULSE\n");
    CaloPULSE(name,outdir,sflag,figty);
  };
  if ( !strcmp(program.Data(),"MATRA") ){
    printf("\n Calling CaloPULSEMATRA\n");
    CaloPULSEMATRA(name,outdir,sflag,figty);
  };
  //
  return(0);
}
