//
//   Show pulse distributions of the calorimeter PULSE calibration
//
//   CaloPULSE.c      version 1.05  (2005-11-15)
//
//   The only input needed is the path to the directory created by YODA for the data file you want to analyze.
//
//   Changelog:
//
//   1.04 - 1.05 : compiled!
//
//   1.03 - 1.04 : don't load yodaUtility.c use clones of routines
//
//   1.02 - 1.03 : small changes for compilation.
//
//   1.01 - 1.02 : changed to be inserted in package CaloQLOOK.
//
//   1.00 - 1.01 : check if file is older than 05015_007.
//
//      1.00     : it works.
//
#include <fstream>
#include <sstream>
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TChain.h>
#if !defined (__CINT__)				
#include <event/PamelaRun.h>
#include <event/physics/calorimeter/CalorimeterEvent.h>
#include <event/physics/trigger/TriggerEvent.h>
#include <event/CalibCalPedEvent.h>
#include <event/CalibCalPulse1Event.h>
#include <event/CalibCalPulse2Event.h>
#include <event/varDump/VarDumpEvent.h>
#include <event/varDump/VarDumpRecord.h>
#include <caloclasses.h>
#endif
#include <CaloFunctions.h>


void CaloPULSE(TString filename, TString outDir = "", Int_t tosave = 0, TString saveas = "eps"){
    gROOT->GetListOfCanvases()->Delete("a");
    gDirectory->GetList()->Delete();
    emicheckLib();
    if ( outDir == "" ) outDir = filename;
    //    TString *file[17];
    //file = "dw_000000_000.dat";
    //file = getFilename(filename);     
    TString fififile =  getFilename(filename);
    const char *file = fififile;
    //
    TFile       *vardumphFile;
    TFile       *vardumpFile;
    TFile       *calheadFile;
    TFile       *calcalibFile;
    calheadFile = emigetFile(filename, "CalibCalPulse1", "Header");
    calcalibFile = emigetFile(filename, "CalibCalPulse1");    
    //Takes the tree of the header file
    TTree *tr = (TTree*)calheadFile->Get("Pscu");
    tr->AddFriend("CalibCalPulse1", calcalibFile);
    pamela::CalibCalPulse1Event *ce = 0;   
    pamela::EventHeader *ceh = new pamela::EventHeader(); 
    tr->SetBranchAddress("Header", &ceh);
    tr->SetBranchAddress("Event", &ce);
    Int_t        tmpSize;    
    vardumphFile = emigetFile(filename, "VarDump", "Header");
    vardumpFile = emigetFile(filename, "VarDump");    
    //Takes the tree of the header file
    TTree *vdtr = (TTree*)vardumphFile->Get("Pscu");
    vdtr->AddFriend("VarDump", vardumpFile);
    pamela::VarDumpEvent  *vde = 0;
    pamela::VarDumpRecord *vdr = 0;
    vdtr->SetBranchAddress("VarDump.Event", &vde);
    Long64_t nevents    = vdtr->GetEntries();
    //    char *ptype = 0;
    stringstream ptype;
    stringstream stno;
    //    char *stno = 0;
    for (Int_t i = 0; i < nevents ; i++){
	vdtr->GetEntry(i);
	tmpSize = vde->Records->GetEntries();
	for (Int_t j = 0; j < tmpSize; j++){
	    vdr = (pamela::VarDumpRecord*)vde->Records->At(j);	
	    if ( (int)vdr->VAR_VALUE>32760 && (int)vdr->VAR_VALUE<32790 ){
		printf(" PULSE TYPE = %X ",vdr->VAR_VALUE);
		ptype.str("");
		ptype << " PULSE TYPE = ";
		ptype << hex << vdr->VAR_VALUE;
		//		ptype = Form(" PULSE TYPE = %X ",vdr->VAR_VALUE);
		vdr = (pamela::VarDumpRecord*)vde->Records->At(j+1);	
		printf(" STRIP = %X \n",vdr->VAR_VALUE);
		stno.str("");
		stno << " STRIP = ";
		stno << hex << vdr->VAR_VALUE;
		//stno = Form(" STRIP = %X \n",vdr->VAR_VALUE);
	    };
	};
    };    
    vardumphFile->Close();
    vardumpFile->Close();

    TCanvas *figura2 = new TCanvas("calpulse", "calpulse", 950, 850);
    figura2->cd();
    gPad->SetLogy();
    Long64_t ncalibs    = tr->GetEntries();
    TH1F *calpulse1;
    Int_t workornot = 1;
    int stoppa = 0;
    for (Int_t ci = 0; ci < ncalibs ; ci++){
	int stoppa = 0;
	int per = 0;
	tr->GetEntry(ci);
	gDirectory->Delete("calpulse");
	calpulse1 = new TH1F("calpulse","",96,-0.5,8000.);
	calpulse1->SetBit(TH1F::kCanRebin);
	for ( Int_t s=0 ; s<4 ;s++  ){
	    if ( ce->unpackError  ) {
		per = 1;
	    } else {
		per = 0;
		//gPad->SetLogy();
		for ( Int_t d=0 ; d<11 ;d++  ){
		    for ( Int_t j=0; j<96 ;j++){
			calpulse1->Fill(ce->calpuls[s][d][j]);
			if ( ce->calpuls[s][d][j] != 0. ) stoppa = 1;
			if ( ce->calpuls[s][d][j] < 0. ) workornot = 0;
		    };
		};
	    };
	};
	if ( !per ){
	    figura2->cd();
	    figura2->SetFillColor(10);
	    //	    char *titolo = 0;
	    stringstream titolo;
	    titolo.str("");
	    titolo << "Pulse1 " << ptype.str().c_str();
	    titolo << " " << stno.str().c_str();
	    //	    titolo = Form("Pulse1 %s %s",ptype,stno);
	    calpulse1->Draw();
	    calpulse1->SetTitle(titolo.str().c_str());
	    figura2->Modified();
	    figura2->Update();

	    //	    char *figrec = 0;
	    //figrec = "dw_000000_000";
	    //	    memcpy(figrec, file, 13);		    
	    //const char *outdir = outDir;
	    //const char *format = saveas;
	    stringstream figsave;
	    figsave.str("");
	    //figsave << outdir << "/";
	    //figsave << figrec << "_pulse1_";
	    figsave << "pulse1_";
	    figsave << ci;
	    //	    figsave << ci << ".";
	    //	    figsave << format;
	    //if ( tosave ) figura2->SaveAs(figsave.str().c_str());

	    if ( tosave ) PrintFigure(filename,outDir,figsave.str().c_str(),saveas,*figura2);
	};
	//	printf("press enter to continue, 1 calib no. %i \n ",ci);
	//        if ( stoppa ) getchar();
    };    	   
    calheadFile = emigetFile(filename, "CalibCalPulse2", "Header");
    calcalibFile = emigetFile(filename, "CalibCalPulse2");    
    //Takes the tree of the header file
    tr = (TTree*)calheadFile->Get("Pscu");
    tr->AddFriend("CalibCalPulse2", calcalibFile);
    pamela::CalibCalPulse2Event *cee = 0;   
    //    pamela::PscuHeader *cph = new pamela::PscuHeader();
    //pamela::EventHeader *ceh = new pamela::EventHeader(); 
    tr->SetBranchAddress("Header", &ceh);
    tr->SetBranchAddress("Event", &cee);
    
    figura2 = new TCanvas("calpulse", "calpulse", 950, 850);
    figura2->cd();
    gPad->SetLogy();
    ncalibs    = tr->GetEntries();
    TH1F *calpulse2;
    for (Int_t ci = 0; ci < ncalibs ; ci++){
	int stoppa = 0;
	int per = 0;
	tr->GetEntry(ci);
	gDirectory->Delete("calpulse");
	calpulse2 = new TH1F("calpulse","",96,-0.5,8000.);
	calpulse2->SetBit(TH1F::kCanRebin);
	for ( Int_t s=0 ; s<4 ;s++  ){
	    if ( cee->unpackError  ){
		per = 1;
	    } else {
		per = 0;
		for ( Int_t d=0 ; d<11 ;d++  ){
		    for ( Int_t j=0; j<96 ;j++){
			calpulse2->Fill(cee->calpuls[s][d][j]);
			if ( cee->calpuls[s][d][j] != 0. ) {
			    stoppa = 1;
			    //	printf("ce->calpuls[s][d][j] %f \n",ce->calpuls[s][d][j]);
			};
			if ( cee->calpuls[s][d][j] < 0. ) workornot = 0;
		    };
		};
	    };
	};
	if ( !per ){
	    figura2->cd();
	    figura2->SetFillColor(10);
	    figura2->Range(0,0,100,100);
	    //	    char *titolo = 0;
	    stringstream titolo;
	    titolo.str("");
	    titolo << "Pulse2 " << ptype.str().c_str();
	    titolo << " " << stno.str().c_str();
	    //	    titolo = Form("Pulse2 %s %s",ptype,stno);
	    calpulse2->SetTitle(titolo.str().c_str());
	    calpulse2->Draw();
	    //	    gPad->SetLogy();
	    figura2->Modified();
	    figura2->Update();
	    //
	    //	    char *figrec = 0;
	    //figrec = "dw_000000_000";
	    //	    memcpy(figrec, file, 13);		    
	    //const char *outdir = outDir;
	    //const char *format = saveas;
	    stringstream figsave;
	    figsave.str("");
	    //figsave << outdir << "/";
	    //figsave << figrec << "_pulse1_";
	    figsave << "pulse2_";
	    figsave << ci;
	    //	    figsave << ci << ".";
	    //	    figsave << format;
	    //if ( tosave ) figura2->SaveAs(figsave.str().c_str());

	    if ( tosave ) PrintFigure(filename,outDir,figsave.str().c_str(),saveas,*figura2);

	    //
	    //char *figrec = 0;
	    //figrec = "dw_000000_000";
	    //memcpy(figrec, file, 13);		    
	    //const char *outdir = outDir;
	    ////	    char *figsave = 0;
	    //const char *format = saveas;
	    //stringstream figsave;
	    //figsave.str("");
	    //figsave << outdir << "/";
	    //figsave << figrec << "_pulse2_";
	    //figsave << ci << ".";
	    //figsave << format;
	    ////	    figsave = Form("%s/%s_pulse2_%i.%s",outdir,figrec,ci,format);	    
	    //if ( tosave ) figura2->SaveAs(figsave.str().c_str());
	};
	//	printf("press enter to continue, 2 calib no. %i\n ",ci);
	//	if ( stoppa ) getchar();
    };    
    if ( stoppa ){
	if ( workornot ){
	    printf("File %s is ok \n",file);
	} else {
	    printf("File %s is NOT OK! \n",file);
	};
    };
}

void CaloPULSEMATRA(TString filename, TString outDir = "", Int_t tosave = 0, TString saveas = "eps"){
    gROOT->GetListOfCanvases()->Delete("a");
    gDirectory->GetList()->Delete();
    emicheckLib();
    if ( outDir == "" ) outDir = filename;
    //TString *file[17];
    //file = "dw_000000_000.dat";
    //file = getFilename(filename);     
    TString fififile =  getFilename(filename);
    const char *file = fififile;
    //
    struct Calib calib;
    for (Int_t s=0; s<4;s++){
	for (Int_t d = 0; d<50; d++){
	    calib.ttime[s][d] = 0 ;
	    if ( d < 49 ) calib.time[s][d] = 0 ;
	};
    };
    //
    // first of all find the calibrations in the file 
    //
    OLDCaloFindCalibs(filename, calib);    
    //
    // print on the screen the results:   
    //
    printf(" ---------------------------------------------------------- \n \n");	
    Int_t calibex = 0;
    for (Int_t s=0; s<4;s++){
	Int_t stop = 0;
	for (Int_t d = 0; d<48; d++){
	    if ( calib.ttime[s][d] != 0 ) {
		calibex++;
	    };
	    if ( calib.time[s][0] != 0 ){
		if ( d == 0 )  printf(" Section %i from time 0 to time %i use calibration at time %i \n",s,calib.time[s][d],calib.ttime[s][d]);
		if ( calib.time[s][d+1] != 0 ) {
		    printf(" Section %i from time %i to time %i use calibration at time %i \n",s,calib.time[s][d],calib.time[s][d+1],calib.ttime[s][d+1]);
		} else {
		    if ( !stop ){
			printf(" Section %i from time %i use calibration at time %i \n",s,calib.time[s][d],calib.ttime[s][d+1]);		
			stop = 1;
		    };
		};
	    } else {
		if ( calib.ttime[s][d] != 0 ) printf(" Section %i from time 0 use calibration at time %i \n",s,calib.ttime[s][d]);
	    };
	};
	printf("\n");	
    };

    Int_t workornot = 1;
    TFile       *vardumphFile;
    TFile       *vardumpFile;
    Int_t        tmpSize;    
    vardumphFile = emigetFile(filename, "VarDump", "Header");
    vardumpFile = emigetFile(filename, "VarDump");    
    //Takes the tree of the header file
    TTree *vdtr = (TTree*)vardumphFile->Get("Pscu");
    vdtr->AddFriend("VarDump", vardumpFile);
    pamela::VarDumpEvent  *vde = 0;
    pamela::VarDumpRecord *vdr = 0;
    vdtr->SetBranchAddress("VarDump.Event", &vde);
    Long64_t nevents    = vdtr->GetEntries();
    stringstream ptype;
    stringstream stno;
    //    char *ptype = 0;
    //char *stno = 0;
    for (Int_t i = 0; i < nevents ; i++){
	vdtr->GetEntry(i);
	tmpSize = vde->Records->GetEntries();
	for (Int_t j = 0; j < tmpSize; j++){
	    vdr = (pamela::VarDumpRecord*)vde->Records->At(j);	
	    if ( (int)vdr->VAR_VALUE>32760 && (int)vdr->VAR_VALUE<32790 ){
		printf(" PULSE TYPE = %X ",vdr->VAR_VALUE);
		ptype.str("");
		ptype << " PULSE TYPE = ";
		ptype << hex << vdr->VAR_VALUE;
		//		ptype = Form(" PULSE TYPE = %X ",vdr->VAR_VALUE);
		vdr = (pamela::VarDumpRecord*)vde->Records->At(j+1);	
		printf(" STRIP = %X \n",vdr->VAR_VALUE);
		stno.str("");
		stno << " STRIP = ";
		stno << hex << vdr->VAR_VALUE;
	    };
	};
    };    
    vardumphFile->Close();
    vardumpFile->Close();


    TFile       *calheadFile;
    TFile       *calcalibFile;
    TFile       *calcalibFile3;
    calheadFile = emigetFile(filename, "CalibCalPulse2", "Header");
    calcalibFile = emigetFile(filename, "CalibCalPulse2");    
    calcalibFile3 = emigetFile(filename, "CalibCalPulse1");    
    //Takes the tree of the header file
    TTree *tr = (TTree*)calheadFile->Get("Pscu");
    tr->AddFriend("CalibCalPulse2", calcalibFile);
    tr->AddFriend("CalibCalPulse1", calcalibFile3);
    pamela::CalibCalPulse2Event *cee = 0;   
    pamela::CalibCalPulse1Event *cee1 = 0;   
    pamela::EventHeader *ceh = new pamela::EventHeader(); 
    tr->SetBranchAddress("Header", &ceh);
    tr->SetBranchAddress("CalibCalPulse2.Event", &cee);
    tr->SetBranchAddress("CalibCalPulse1.Event", &cee1);

    Long64_t ncalibs    = tr->GetEntries();
    //
    TCanvas *figura2 = new TCanvas("Calorimeter_tracks", "Calorimeter_tracks", 750, 650);
    figura2->SetFillColor(10);
    figura2->Range(0,0,100,100);
    Int_t ci = 0;
    int stoppa = 0;
    while ( ci < ncalibs ){
	stoppa = 0;
	int per = 0;
	//	if ( ci !=0 && ci%4==0 && ci<5){
	
	//	if ( ci%8 != 0 && ci%4==0 ){
	//   printf("sto calibrando! ci = %i \n",ci);
	//   calibr++;
	//   calib.iev = 0;
	//   for (Int_t m = 0; m < 22; m++){ 
	//	if ( m < 4) {
	//	    calib.cstwerr[m] = 0;
	//	    calib.cperror[m] = 0.;		
	//	};
	//	for (Int_t l = 0; l < 2; l++){
	//	    for (Int_t n = 0; n < 96; n++){
	//		calib.calped[l][m][n] = 0.;
	//		calib.calgood[l][m][n] = 0.;
	//		calib.calrms[l][m][n] = 0.;
	//		if ( n < 6 ) {
	//		    calib.calthr[l][m][n] = 0.;
	//		    calib.calbase[l][m][n] = 0.;
	//		    calib.calvar[l][m][n] = 0.;
	//		};
	//	    };
	//	};
	//   };
	//   //
	//   // call calibration
	//   //
	//   for (Int_t s = 0; s < 4; s++){
	//	CaloPede(filename,s,calib.ttime[s][calibr],calib);
	//   };		    
	//};
	//otr->GetEntry(0);
	//for (Int_t l = 0; l < 2; l++){	    	   
	//   for (Int_t m = 0; m < 22; m++){ 
	//	Int_t pre = -1;
	//	for (Int_t n = 0; n < 96; n++){
	//	    if ( n%16 == 0 ) pre++;			
	//	    if ( cp->base[l][m][pre] != 0. ) calib.calbase[l][m][pre] = cp->base[l][m][pre];
	//	};
	//   };
	//};
	//
	figura2->Clear();
	//
	// Book the histograms:
	//
	//
	stringstream xview;
	xview.str("");
	xview << "x-view event " << (ci+1);
	stringstream yview;
	yview.str("");
	yview << "y-view event " << (ci+1);
	gDirectory->Delete(xview.str().c_str());
	gDirectory->Delete(yview.str().c_str());
	TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
	TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
	//
	// figures:
	//
	Int_t bgcolor = 10;
	TLatex *t=new TLatex();
	t->SetTextFont(32);
	t->SetTextColor(1);
	t->SetTextSize(0.03);
	t->SetTextAlign(12);
	//	char *titolo = 0;
	//sprintf(titolo,"Calorimeter tracks - file %s - event number %i ",file,i+1);	
	//t->DrawLatex(0.5,97.,titolo);
	TPad *pd1 = new TPad("pd1","This is pad1",0.02,0.05,0.88,0.49,bgcolor);
	TPad *pd2 = new TPad("pd2","This is pad2",0.02,0.51,0.88,0.95,bgcolor);
	TPad *palette = new TPad("palette","This is palette",0.90,0.05,0.98,0.9,bgcolor);
	figura2->cd();
	t=new TLatex();
	t->SetTextFont(32);
	t->SetTextColor(1);
	t->SetTextSize(0.03);
	t->SetTextAlign(12);
	t->DrawLatex(92.,92.5,"MIP");
	pd1->Range(0,0,100,100);
	pd2->Range(0,0,100,100);
	palette->Range(0,0,100,100);
	pd1->SetTicks();
	pd2->SetTicks();
	pd1->Draw();
	pd2->Draw();
	palette->Draw();
	palette->cd();
	// palette
	TPaveLabel *box1 = new TPaveLabel(2,2,98,16.3,"0","");
	box1->SetTextFont(32);
	box1->SetTextColor(1);	
	box1->SetTextSize(0.25);	
	box1->SetFillColor(10);
	box1->Draw();
	TPaveLabel *box2 = new TPaveLabel(2,18.3,98,32.66,"0-2","");
	box2->SetTextFont(32);
	box2->SetTextColor(1);		
	box2->SetTextSize(0.25);	
	box2->SetFillColor(38);
	box2->Draw();
	TPaveLabel *box3 = new TPaveLabel(2,34.66,98,48.96,"2-10","");
	box3->SetTextFont(32);
	box3->SetTextColor(1);	
	box3->SetTextSize(0.25);	
	box3->SetFillColor(4);
	box3->Draw();
	TPaveLabel *box4 = new TPaveLabel(2,50.96,98,65.26,"10-100","");
	box4->SetTextFont(32);
	box4->SetTextColor(1);	
	box4->SetTextSize(0.25);	
	box4->SetFillColor(3);
	box4->Draw();
	TPaveLabel *box5 = new TPaveLabel(2,67.26,98,81.56,"100-500","");
	box5->SetTextFont(32);
	box5->SetTextColor(1);	
	box5->SetTextSize(0.2);	
	box5->SetFillColor(2);
	box5->Draw();
	TPaveLabel *box6 = new TPaveLabel(2,83.56,98,97.86,">500","");
	box6->SetTextFont(32);
	box6->SetTextColor(1);	
	box6->SetTextSize(0.25);	
	box6->SetFillColor(6);
	box6->Draw();
	figura2->cd();
	gStyle->SetOptDate(1);
	pd1->cd();	   
	gStyle->SetOptStat(0);
	Xview->SetXTitle("strip");
	Xview->SetYTitle("X - plane");
	Xview->GetYaxis()->SetTitleOffset(0.5);
	Xview->SetFillColor(bgcolor);	    
	Xview->Fill(1.,1.,1.);	    
	Xview->Draw("box");
	pd1->Update();
	pd2->cd();
	gStyle->SetOptStat(0);
	Yview->SetXTitle("strip");
	Yview->SetYTitle("Y - plane");
	Yview->GetYaxis()->SetTitleOffset(0.5);	
	Yview->SetFillColor(bgcolor);	    
	Yview->Fill(1.,1.,1.);	    
	Yview->Draw("box");
	pd2->Update();
	//	
	Int_t m = 0;
	Int_t l = 3;
	Int_t ss = 0;
	Float_t estrip = 0.;
	for ( Int_t s=0 ; s<4 ;s++  ){
	    tr->GetEntry(ci);	
	    //	    printf("ci = %i unpkerr = %i \n",ci,cee->unpackError);
	    if ( cee->unpackError  ){
		per = 1;
	    } else {
		if ( s == 0 ) ss = 0;
		if ( s == 1 ) ss = 2;
		if ( s == 2 ) ss = 3;
		if ( s == 3 ) ss = 1;	       		
		per = 0;
		for ( Int_t d=0 ; d<11 ;d++  ){
		    Int_t pre = -1;
		    for ( Int_t j=0; j<96 ;j++){
			figura2->cd();
			if ( j%16 == 0 ) pre++;			
			estrip = 0.;
			if ( s == 2 ) m = 2*d+1;
			if ( s == 3 ) m = 2*d;
			if ( s == 0 ) m = 2*d;
			if ( s == 1 ) m = 2*d+1;
			if ( s == 3 ) l = 0;
			if ( s == 2 ) l = 0;
			if ( s == 1 ) l = 1;
			if ( s == 0 ) l = 1;	
			//			estrip = (cee->calpuls[ss][d][j]-calib.calbase[l][m][pre]-calib.calped[l][m][j])/26.;
			estrip = (cee->calpuls[ss][d][j]-cee1->calpuls[ss][d][j])/26.;
			if ( estrip > 0.7 ){
			    //			    if ( d == 0 ) printf("strip number: %i   MIP: %f \n",j,estrip);
			    xview.str("");
			    xview << "x-view event " << j;
			    xview << " " << m;
			    xview << " " << l;
			    yview.str("");
			    yview << "y-view event " << j;
			    yview << " " << m;
			    yview << " " << l;
			    gDirectory->Delete(xview.str().c_str());
			    gDirectory->Delete(yview.str().c_str());
			    TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
			    TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
			    Int_t colo;
			    ColorMIP(estrip,colo);
			    Xview->SetFillColor(colo);
			    Yview->SetFillColor(colo);
			    if ( l == 0 ) {
				Xview->Fill(j,m,1.);
				pd1->cd();				    
				Xview->Draw("box same");
			    };				    
			    if ( l == 1 ) {
				Yview->Fill(j,m,1.);
				pd2->cd();
				Yview->Draw("box same");
			    };				
			};	       
			if ( cee->calpuls[s][d][j] != 0. ) {
			    stoppa = 1;
			};
			if ( cee->calpuls[s][d][j] < 0. ) workornot = 0;
		    };
		};
	    };
	    ci++;
	};
	if ( !per ){
	    pd1->Update();
	    pd2->Update();
	    figura2->Modified();
	    figura2->Update();

	    //	    char *figrec = 0;
	    //figrec = "dw_000000_000";
	    //	    memcpy(figrec, file, 13);		    
	    //const char *outdir = outDir;
	    //const char *format = saveas;
	    stringstream figsave;
	    figsave.str("");
	    //figsave << outdir << "/";
	    //figsave << figrec << "_pulse1_";
	    figsave << "pulsematra2_";
	    figsave << ci;
	    //	    figsave << ci << ".";
	    //	    figsave << format;
	    //if ( tosave ) figura2->SaveAs(figsave.str().c_str());

	    if ( tosave ) PrintFigure(filename,outDir,figsave.str().c_str(),saveas,*figura2);

	    //char *figrec = 0;
	    //figrec = "dw_000000_000";
	    //memcpy(figrec, file, 13);		    
	    //const char *outdir = outDir;
	    ////	    char *figsave = 0;
	    //const char *format = saveas;
	    //stringstream figsave;
	    //figsave.str("");
	    //figsave << outdir << "/";
	    //figsave << figrec << "_pulsematra2_";
	    //figsave << ci << ".";
	    //figsave << format;
	    ////	    figsave = Form("%s/%s_pulsematra2_%i.%s",outdir,figrec,ci,format);	    
	    //if ( tosave ) figura2->SaveAs(figsave.str().c_str());

	    //	    printf("Press enter to continue \n");
	    //getchar();
	};
    };
    //	printf("press enter to continue, 2 calib no. %i\n ",ci);
    //	if ( stoppa ) getchar();
    if ( stoppa ){
	if ( workornot ){
	    printf("File %s is ok \n",file);
	} else {
	    printf("File %s is NOT OK! \n",file);
	};
    };
}
