//
// CaloQLOOK.cc -- standalone program to call the CaloQLOOK macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog:
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <iostream>
//
extern void CaloQLOOK(TString ,  int , int , TString , TString );
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir;
  TString format;
  int fromev;
  int toev;
  if ( numinp != 6 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n CaloQLOOK file from_event to_event output_dir figure_format \n");
    printf("\n - file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - from_event       is an integer (progressive number) \n");
    printf(  " - to_event         is an integer (progressive number) \n");
    printf(  " - output_dir       directory where to store figures \n");
    printf(  " - figure format    any format recognized by ROOT (eps,gif,...)\n");
    printf("\nExample: \n\nCaloQLOOK /home/pamela/filesfromyoda/dw_050301_00100/ 0 0 /tmp/ eps \n\n");
    return(0);
    //
  } else {
    printf("\n Welcome to CaloQLOOK! \n");
    name = (TString)inps[1];
    fromev = atoi(inps[2]);
    toev = atoi(inps[3]);
    outdir = (TString)inps[4];
    format = (TString)inps[5];
  };
  //
  CaloQLOOK(name,fromev,toev,outdir,format);
  //
  return(0);
}
