//
// CaloLEVEL2.cc -- standalone program to call the CaloLEVEL2 macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/05)
//
// Changelog:
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <iostream>
//
extern short int CaloLEVEL2(TString ,  TString , TString , TString , int );
extern void info();
//
using namespace std;
//
int main(int numinp, char *inps[]){
  int force = 0;
  TString name;
  TString trkdir;
  TString outdir;
  TString frame;
  if ( numinp < 6 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
	printf("\nUsage:\n\n CaloLEVEL2 file tracker_dir output_dir framework force \n");
	printf("\n - file         must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf(  " - tracker_dir  is the path to the tracker data directory \n");
	printf(  " - output_dir   is the path where to store output \n");
	printf(  " - framework    is the type of output data you want, can be \"root\" or \"paw\"\n");
	printf(  " - force        can be 0 (the program will abort at any problem) or 1 \n                (the program will try to process data anyway)\n");
	printf("\nExample: \n\nCaloLEVEL2 /home/pamela/filesfromyoda/dw_050301_00100/ \"\" /tmp/ paw 1 \n\n");
	return(0);
      };
    };
    printf("\n Welcome to CaloLEVEL2! \n");
    //
    printf("\n You must provide the following input parameters: \n\n");
    //
    char input[256];
    //
    printf(" Path to YODA unpacked directory: \n ");
    cin.getline(input,256);
    name = (TString)input;
    printf(" Path to the tracker data directory: \n ");
    cin.getline(input,256);
    trkdir = (TString)input;
    printf(" Path to the output directory: \n ");
    cin.getline(input,256);
    outdir = (TString)input;
    printf(" Framework (root/paw): \n ");
    cin.getline(input,256);
    frame = (TString)input;
    printf(" FORCE (0/1): \n ");
    cin.getline(input,256);
    force = atoi(input);      
    //
  } else {
    printf("\n Welcome to CaloLEVEL2! \n");
    name = (TString)inps[1];
    trkdir = (TString)inps[2];
    outdir = (TString)inps[3];
    frame = (TString)inps[4];
    force = atoi(inps[5]);
  };
  //
  int error = CaloLEVEL2(name,trkdir,outdir,frame,force);
  //
  return(error);
}
