#!/bin/bash --norc 
THISDIR=`pwd`
if [ $# -gt 0 ]; then
    I=1
    NOENV=""
    INDIR=""
    YODA=""
    while [ $I -le $# ]; do
	if [ $I -eq 1 ]; then 
	    INPUT=$1
	fi
	if [ $I -eq 2 ]; then 
	    INPUT=$2
	fi
	if [ $I -eq 3 ]; then 
	    INPUT=$3
	fi
	if [ $I -eq 4 ]; then 
	    INPUT=$4
	fi
	if [ $I -eq 5 ]; then 
	    INPUT=$5
	fi
	if [ $INPUT == "--clean" ]; then
	    echo ""
	    echo ""
	    echo "============= MAKE DISTCLEAN  =================="
	    echo ""
	    make distclean 
	    cd $THISDIR &>/dev/null
	    exit 0;
	fi
	if [ $INPUT == "--no-env" ]; then
	    NOENV="1"
	fi
	if [ $INPUT == "--help" ] || [ $INPUT == "-h" ]; then
	    echo ""
	    echo " Usage: ./install.sh [options] "
	    echo ""
	    echo " Options: "
	    echo ""
	    echo " --no-env : compile and install without PAMELA environmental setup. "
	    echo "            In this case only standalone program will work and it will"
	    echo "            not possible to use the ROOT macros (they will NOT be "
	    echo "            installed). Notice that the executables will statically "
	    echo "            search for the calibration files in the given path."
	    echo "            If this option is set it is mandatory to give also"
	    echo "            the --install-dir and --with-yoda options."
	    echo ""
	    echo " --install-dir=[directory] : the directory were to install programs."
	    echo "            If not existing the following subdirectories will be created:"
	    echo "            lib/ include/ calib/ doc/ bin/"
	    echo "            To be able to use the compiled program you will need to add"
	    echo "            the [directory]/lib/ directory to your ld.so.conf file or to"
	    echo "            the LD_CONFIG_PATH environmental variable."
	    echo ""
	    echo " --with-yoda=[directory] :  path to the YODA source. To compile"
	    echo "            programs you need the YODA header files that must be found in"
	    echo "            [directory]/include/yoda/ and the YODA library that must be in"
	    echo "            [directory]/lib/ ."
	    echo ""
	    echo " To compile and install using the PAMELA environmental setup you do not"
	    echo " need any option and, if given, they will not be considered."
	    echo ""
	    echo ""
	    exit 0
	fi
	TEST=`echo $INPUT | sed 's/--install-dir=//g'`
	if [ $TEST != $INPUT  ]; then
	    INDIR=$TEST
	fi
	TEST=`echo $INPUT | sed 's/--with-yoda=//g'`
	if [ $TEST != $INPUT  ]; then
	    YODA=$TEST
	fi
	let I=$I+1
    done
    if [ $NOENV ]; then
	if [ $YODA ]; then
	    if [ $INDIR ]; then
		echo ""
		echo " Compiling and installing software _WITHOUT_ environmental setup "
		echo ""
		echo " WARNING: only standalone programs will work "
		echo ""
		echo ""
		rm -rf ${THISDIR}/target
		mkdir ${THISDIR}/target
		mkdir ${THISDIR}/target/macros
		unset PAM_CCO
		export PAM_CCO=1
		unset PAM_MACROS			
		export PAM_MACROS=${THISDIR}/target/macros
		unset PAM_YODA
		export PAM_YODA=$INDIR
		if [ $YODA ]; then
		    unset PAM_YODA
		    export PAM_YODA=$YODA 
		fi;		    
		if [ ! -d $INDIR ]; then
		    mkdir $INDIR
		fi
		if [ ! -d $INDIR/bin/ ]; then
		    mkdir $INDIR/bin/
		fi
		unset PAM_BIN
		export PAM_BIN=$INDIR/bin/
		if [ ! -d $INDIR/lib/ ]; then
		    mkdir $INDIR/lib/
		fi
		unset PAM_LIB
		export PAM_LIB=$INDIR/lib/
		if [ ! -d $INDIR/include/ ]; then
		    mkdir $INDIR/include/
		fi
		unset PAM_INC
		export PAM_INC=$INDIR/include/
		if [ ! -d $INDIR/calib/ ]; then
		    mkdir $INDIR/calib/
		fi
		unset PAM_CALIB
		export PAM_CALIB=$INDIR/calib/		
		if [ ! -d $INDIR/doc/ ]; then
		    mkdir $INDIR/doc/
		fi
		unset PAM_DOC
		export PAM_DOC=$INDIR/doc/		
	    fi
	fi;
    else
	echo ""
	echo " Compiling and installing software _USING_ the environmental setup "
    fi;
else
    echo ""
    echo " Compiling and installing software _USING_ the environmental setup "
fi;
echo ""
echo " WARNING: you will need to add ${PAM_LIB} "
echo " to your LD_LIBRARY_PATH or to the /etc/ld.so.conf file"
echo " You may also want to add ${PAM_BIN} to your PATH "
echo ""
sleep 5
#
unset ARCH
export ARCH=`uname`
export THISDIR=`pwd`
export LD_LIBRARY_PATH==$LD_LIBRARY_PATH:$PAM_LIB:$PAM_YODA/lib:$ROOTSYS/lib
echo ""
echo ""
echo "============= COMPILING AND INSTALLING THE CALOLEVEL2 PACKAGE ================="
echo ""
    make distclean all upgrade
cd $THISDIR &>/dev/null
#
rm -rf ${THISDIR}/target
